# Generated by Django 6.0 on 2025-12-31 22:54

import django.db.models.deletion
import django.utils.timezone
import uuid
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('machine', '0005_converge_binary_model'),
    ]

    operations = [
        migrations.CreateModel(
            name='Process',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid7, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(db_index=True, default=django.utils.timezone.now)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('pwd', models.CharField(blank=True, default='', help_text='Working directory for process execution', max_length=512)),
                ('cmd', models.JSONField(blank=True, default=list, help_text='Command as array of arguments')),
                ('env', models.JSONField(blank=True, default=dict, help_text='Environment variables for process')),
                ('timeout', models.IntegerField(default=120, help_text='Timeout in seconds')),
                ('pid', models.IntegerField(blank=True, default=None, help_text='OS process ID', null=True)),
                ('exit_code', models.IntegerField(blank=True, default=None, help_text='Process exit code (0 = success)', null=True)),
                ('stdout', models.TextField(blank=True, default='', help_text='Standard output from process')),
                ('stderr', models.TextField(blank=True, default='', help_text='Standard error from process')),
                ('started_at', models.DateTimeField(blank=True, default=None, help_text='When process was launched', null=True)),
                ('ended_at', models.DateTimeField(blank=True, default=None, help_text='When process completed/terminated', null=True)),
                ('url', models.URLField(blank=True, default=None, help_text='Connection URL (CDP endpoint, sonic server, etc.)', max_length=2048, null=True)),
                ('status', models.CharField(choices=[('queued', 'Queued'), ('running', 'Running'), ('exited', 'Exited')], db_index=True, default='queued', max_length=16)),
                ('retry_at', models.DateTimeField(blank=True, db_index=True, default=django.utils.timezone.now, help_text='When to retry this process', null=True)),
                ('binary', models.ForeignKey(blank=True, help_text='Binary used by this process', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='process_set', to='machine.binary')),
                ('iface', models.ForeignKey(blank=True, help_text='Network interface used by this process', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='process_set', to='machine.networkinterface')),
                ('machine', models.ForeignKey(help_text='Machine where this process executed', on_delete=django.db.models.deletion.CASCADE, related_name='process_set', to='machine.machine')),
            ],
            options={
                'verbose_name': 'Process',
                'verbose_name_plural': 'Processes',
                'indexes': [models.Index(fields=['machine', 'status', 'retry_at'], name='machine_pro_machine_5e3a87_idx'), models.Index(fields=['binary', 'exit_code'], name='machine_pro_binary__7bd19c_idx')],
            },
        ),
    ]
