# Getting Started

<video controls="" autoplay="" name="media"><source src="https://github.com/blacklanternsecurity/bbot/assets/20261699/e539e89b-92ea-46fa-b893-9cde94eebf81" type="video/mp4"></video>

_A BBOT scan in real-time - visualization with [VivaGraphJS](https://github.com/blacklanternsecurity/bbot-vivagraphjs)_

## Installation

!!! info "Supported Platforms"

    Only **Linux** is supported at this time. **Windows** and **macOS** are *not* supported. If you use one of these platforms, consider using [Docker](#Docker).

BBOT offers multiple methods of installation, including **pipx** and **Docker**. If you're looking to tinker or write your own module, see [Setting up a Dev Environment](./dev/dev_environment.md).

### [Python (pip / pipx)](https://pypi.org/project/bbot/)


???+ note inline end

    `pipx` installs BBOT inside its own virtual environment.

```bash
# stable version
pipx install bbot

# bleeding edge (dev branch)
pipx install --pip-args '\--pre' bbot

# execute bbot command
bbot --help
```

### [Docker](https://hub.docker.com/r/blacklanternsecurity/bbot)

Docker images are provided, along with helper script `bbot-docker.sh` to persist your scan data. Images come in four flavors: `dev`, `dev-full`, `stable`, and `stable-full`. `dev` is the latest bleeding edge version. `-full` images are larger and have all of BBOT's module dependencies preinstalled (wordlists, pip packages, etc.).

Scans are output to `~/.bbot/scans` (the usual place for BBOT scan data).

```bash
# dev (bleeding edge)
docker run -it blacklanternsecurity/bbot --help
# dev (bleeding edge - full)
docker run -it blacklanternsecurity/bbot:dev-full --help

# stable
docker run -it blacklanternsecurity/bbot:stable --help
# stable (full)
docker run -it blacklanternsecurity/bbot:stable-full --help

# helper script
git clone https://github.com/blacklanternsecurity/bbot && cd bbot
./bbot-docker.sh --help
```

Note: If you need to pass in a custom preset, you can do so by mapping the preset into the container:

```bash
# use the preset `my_preset.yml` from the current directory
docker run --rm -it \
  -v "$HOME/.bbot/scans:/root/.bbot/scans" \
  -v "$PWD/my_preset.yml:/my_preset.yml" \
  blacklanternsecurity/bbot -p /my_preset.yml
```

## Example Commands

Below are some examples of common scans.

<!-- BBOT EXAMPLE COMMANDS -->
**Subdomains:**

```bash
# Perform a full subdomain enumeration on evilcorp.com
bbot -t evilcorp.com -p subdomain-enum
```

**Subdomains (passive only):**

```bash
# Perform a passive-only subdomain enumeration on evilcorp.com
bbot -t evilcorp.com -p subdomain-enum -rf passive
```

**Subdomains + port scan + web screenshots:**

```bash
# Port-scan every subdomain, screenshot every webpage, output to current directory
bbot -t evilcorp.com -p subdomain-enum -m portscan gowitness -n my_scan -o .
```

**Subdomains + basic web scan:**

```bash
# A basic web scan includes wappalyzer, robots.txt, and other non-intrusive web modules
bbot -t evilcorp.com -p subdomain-enum web-basic
```

**Web spider:**

```bash
# Crawl www.evilcorp.com up to a max depth of 2, automatically extracting emails, secrets, etc.
bbot -t www.evilcorp.com -p spider -c web.spider_distance=2 web.spider_depth=2
```

**Everything everywhere all at once:**

```bash
# Subdomains, emails, cloud buckets, port scan, basic web, web screenshots, nuclei
bbot -t evilcorp.com -p kitchen-sink
```
<!-- END BBOT EXAMPLE COMMANDS -->

## API Keys

BBOT works just fine without API keys. However, there are certain modules that need them to function. If you have API keys and want to make use of these modules, you can place them either in your preset:

```yaml title="my_preset.yml"
description: My custom subdomain enum preset

include:
  - subdomain-enum
  - cloud-enum

config:
  modules:
    shodan_dns:
      api_key: deadbeef
    virustotal:
      api_key: cafebabe
```

...in BBOT's global YAML config (`~/.config/bbot/bbot.yml`):

Note: this will ensure the API keys are used in all scans, regardless of preset.

```yaml title="~/.config/bbot/bbot.yml"
modules:
  shodan_dns:
    api_key: deadbeef
  virustotal:
    api_key: cafebabe
```

...or directly on the command-line:

```bash
# specify API key with -c
bbot -t evilcorp.com -f subdomain-enum -c modules.shodan_dns.api_key=deadbeef modules.virustotal.api_key=cafebabe
```

For more information, see [Configuration](./scanning/configuration.md). For a full list of modules, including which ones require API keys, see [List of Modules](./modules/list_of_modules.md).

[Next Up: Scanning -->](./scanning/index.md){ .md-button .md-button--primary }
