# Results

When you call the `Runner.run` methods, you either get a:

-   [`RunResult`][cai.sdk.agents.result.RunResult] if you call `run` or `run_sync`
-   [`RunResultStreaming`][cai.sdk.agents.result.RunResultStreaming] if you call `run_streamed`

Both of these inherit from [`RunResultBase`][cai.sdk.agents.result.RunResultBase], which is where most useful information is present.

## Final output

The [`final_output`][cai.sdk.agents.result.RunResultBase.final_output] property contains the final output of the last agent that ran. This is either:

-   a `str`, if the last agent didn't have an `output_type` defined
-   an object of type `last_agent.output_type`, if the agent had an output type defined.

!!! note

    `final_output` is of type `Any`. We can't statically type this, because of handoffs. If handoffs occur, that means any Agent might be the last agent, so we don't statically know the set of possible output types.

## Inputs for the next turn

You can use [`result.to_input_list()`][cai.sdk.agents.result.RunResultBase.to_input_list] to turn the result into an input list that concatenates the original input you provided, to the items generated during the agent run. This makes it convenient to take the outputs of one agent run and pass them into another run, or to run it in a loop and append new user inputs each time.

## Last agent

The [`last_agent`][cai.sdk.agents.result.RunResultBase.last_agent] property contains the last agent that ran. Depending on your application, this is often useful for the next time the user inputs something. For example, if you have a frontline triage agent that hands off to a language-specific agent, you can store the last agent, and re-use it the next time the user messages the agent.

## New items

The [`new_items`][cai.sdk.agents.result.RunResultBase.new_items] property contains the new items generated during the run. The items are [`RunItem`][cai.sdk.agents.items.RunItem]s. A run item wraps the raw item generated by the LLM.

-   [`MessageOutputItem`][cai.sdk.agents.items.MessageOutputItem] indicates a message from the LLM. The raw item is the message generated.
-   [`HandoffCallItem`][cai.sdk.agents.items.HandoffCallItem] indicates that the LLM called the handoff tool. The raw item is the tool call item from the LLM.
-   [`HandoffOutputItem`][cai.sdk.agents.items.HandoffOutputItem] indicates that a handoff occurred. The raw item is the tool response to the handoff tool call. You can also access the source/target agents from the item.
-   [`ToolCallItem`][cai.sdk.agents.items.ToolCallItem] indicates that the LLM invoked a tool.
-   [`ToolCallOutputItem`][cai.sdk.agents.items.ToolCallOutputItem] indicates that a tool was called. The raw item is the tool response. You can also access the tool output from the item.
-   [`ReasoningItem`][cai.sdk.agents.items.ReasoningItem] indicates a reasoning item from the LLM. The raw item is the reasoning generated.

## Other information

### Guardrail results

The [`input_guardrail_results`][cai.sdk.agents.result.RunResultBase.input_guardrail_results] and [`output_guardrail_results`][cai.sdk.agents.result.RunResultBase.output_guardrail_results] properties contain the results of the guardrails, if any. Guardrail results can sometimes contain useful information you want to log or store, so we make these available to you.

### Raw responses

The [`raw_responses`][cai.sdk.agents.result.RunResultBase.raw_responses] property contains the [`ModelResponse`][cai.sdk.agents.items.ModelResponse]s generated by the LLM.

### Original input

The [`input`][cai.sdk.agents.result.RunResultBase.input] property contains the original input you provided to the `run` method. In most cases you won't need this, but it's available in case you do.
