/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.actions;

import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.graph.table.io.TabularGraphFileImporter;
import com.paterva.maltego.graph.table.io.actions.TabularGraphOpenAction;
import com.paterva.maltego.graph.table.io.wizard.ImportWizard;
import com.paterva.maltego.matching.MatchingRule;
import com.paterva.maltego.merging.GraphMatchStrategy;
import com.paterva.maltego.merging.GraphMergeStrategy;
import com.paterva.maltego.merging.GraphMerger;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Comparator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import yguard.A.A.D;

public class TabularGraphImportAction
extends SystemAction {
    public String getName() {
        return "Import Graph from Table";
    }

    protected String iconResource() {
        return "com/paterva/maltego/graph/table/io/resources/ImportTabularGraph.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.perform(Lookup.getDefault());
    }

    public void perform(Lookup lookup) {
        TabularGraphFileImporter[] tabularGraphFileImporterArray = TabularGraphFileImporter.getAll(lookup);
        if (tabularGraphFileImporterArray.length == 0) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"The chosen import operation is not available in this version of Maltego."));
        } else {
            this.sortImporters(tabularGraphFileImporterArray);
            WizardDescriptor wizardDescriptor = ImportWizard.create(tabularGraphFileImporterArray);
            if (WizardUtilities.runWizard((WizardDescriptor)wizardDescriptor)) {
                D d = (D)wizardDescriptor.getProperty("importedGraph");
                boolean bl = (Boolean)wizardDescriptor.getProperty("newGraph");
                if (bl) {
                    TabularGraphFileImporter tabularGraphFileImporter = (TabularGraphFileImporter)wizardDescriptor.getProperty("fileImporter");
                    this.openNewGraph(d, tabularGraphFileImporter.getSourceName());
                } else {
                    this.mergeWithTopGraph(d);
                }
            }
        }
    }

    private void openNewGraph(D d, String string) {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        TabularGraphOpenAction tabularGraphOpenAction = (TabularGraphOpenAction)SystemAction.get(TabularGraphOpenAction.class);
        tabularGraphOpenAction.setGraph(d, string);
        tabularGraphOpenAction.performAction();
    }

    private void mergeWithTopGraph(D d) {
        GraphMatchStrategy.Simple simple = new GraphMatchStrategy.Simple(MatchingRule.Default, MatchingRule.Default);
        GraphMergeStrategy.PreferNew preferNew = new GraphMergeStrategy.PreferNew();
        GraphMerger.Strategic strategic = new GraphMerger.Strategic((GraphMatchStrategy)simple, (GraphMergeStrategy)preferNew, null);
        strategic.setGraphs(MaltegoGraphManager.getWrapper((D)this.getTopGraph()), MaltegoGraphManager.get((D)d), null);
        strategic.append();
    }

    private void sortImporters(TabularGraphFileImporter[] tabularGraphFileImporterArray) {
        Arrays.sort(tabularGraphFileImporterArray, new Comparator<TabularGraphFileImporter>(){

            @Override
            public int compare(TabularGraphFileImporter tabularGraphFileImporter, TabularGraphFileImporter tabularGraphFileImporter2) {
                return tabularGraphFileImporter.getFileTypeDescription().compareToIgnoreCase(tabularGraphFileImporter2.getFileTypeDescription());
            }
        });
    }

    private D getTopGraph() {
        TopComponent topComponent = GraphEditorRegistry.getDefault().getTopmost();
        if (topComponent != null) {
            GraphCookie graphCookie = (GraphCookie)topComponent.getLookup().lookup(GraphCookie.class);
            D d = graphCookie.getGraph();
            return d;
        }
        return null;
    }
}

