/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.registry;

import com.paterva.maltego.entity.api.EntitySpecSerializer;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.typing.descriptor.ToolboxItemSpec;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.XmlSerializationException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

class FileSystemRegistry<T extends ToolboxItemSpec> {
    private String _folderName;
    private String _extension;
    private Map<String, T> _map;
    private final Object _lock = new String();
    private EntitySpecSerializer _serializer = EntitySpecSerializer.getDefault();

    public FileSystemRegistry(String string, String string2) {
        this._folderName = string;
        this._extension = string2;
    }

    private Map<String, T> map() {
        if (this._map == null) {
            this._map = this.load();
        }
        return this._map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String string) {
        Object object = this._lock;
        synchronized (object) {
            return (T)((ToolboxItemSpec)this.map().get(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getAll() {
        Object object = this._lock;
        synchronized (object) {
            return this.map().values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T t, String string) {
        try {
            Object object = this._lock;
            synchronized (object) {
                this.addEntity(t, string);
                this.map().put(t.getTypeName(), t);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) {
        Object object = this._lock;
        synchronized (object) {
            if (this.contains(string)) {
                try {
                    this.removeEntity(string);
                    this.map().remove(string);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String string) {
        Object object = this._lock;
        synchronized (object) {
            return this.map().containsKey(string);
        }
    }

    private Map<String, T> load() {
        HashMap<String, T> hashMap = new HashMap<String, T>();
        FileObject fileObject = FileUtil.getConfigRoot().getFileObject(this._folderName);
        if (fileObject != null) {
            Enumeration enumeration = fileObject.getFolders(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                for (FileObject fileObject3 : fileObject2.getChildren()) {
                    if (fileObject3.isFolder()) continue;
                    try {
                        T t = this.loadEntity(fileObject3);
                        t.setDefaultCategory(fileObject2.getName());
                        hashMap.put(t.getTypeName(), t);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    catch (TypeInstantiationException typeInstantiationException) {
                        Exceptions.printStackTrace((Throwable)typeInstantiationException);
                    }
                }
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T loadEntity(FileObject fileObject) throws FileNotFoundException, XmlSerializationException, TypeInstantiationException, IOException {
        InputStream inputStream = null;
        FileLock fileLock = null;
        try {
            fileLock = fileObject.lock();
            inputStream = fileObject.getInputStream();
            MaltegoEntitySpec maltegoEntitySpec = this.serializer().read(inputStream);
            return (T)maltegoEntitySpec;
        }
        finally {
            fileLock.releaseLock();
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntity(T t, String string) throws IOException, XmlSerializationException {
        FileObject fileObject = FileUtilities.getOrCreate((String)this._folderName);
        FileObject fileObject2 = FileUtilities.getOrCreate((FileObject)fileObject, (String)string);
        FileObject fileObject3 = fileObject2.getFileObject(t.getTypeName(), this._extension);
        if (fileObject3 == null) {
            fileObject3 = fileObject2.createData(t.getTypeName(), this._extension);
        }
        FileLock fileLock = null;
        OutputStream outputStream = null;
        try {
            fileLock = fileObject3.lock();
            outputStream = fileObject3.getOutputStream(fileLock);
            this.serializer().write((MaltegoEntitySpec)t, outputStream);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntity(T t) throws IOException, XmlSerializationException {
        FileObject fileObject = FileUtil.getConfigRoot().getFileObject(this._folderName);
        if (fileObject != null) {
            Enumeration enumeration = fileObject.getChildren(true);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (fileObject2.isFolder() || !fileObject2.getName().equals(t.getTypeName())) continue;
                FileLock fileLock = null;
                OutputStream outputStream = null;
                try {
                    fileLock = fileObject2.lock();
                    outputStream = fileObject2.getOutputStream(fileLock);
                    this.serializer().write((MaltegoEntitySpec)t, outputStream);
                }
                finally {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntity(String string) throws IOException {
        FileObject fileObject = FileUtil.getConfigRoot().getFileObject(this._folderName);
        if (fileObject != null) {
            Enumeration enumeration = fileObject.getChildren(true);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (fileObject2.isFolder() || !fileObject2.getName().equals(string)) continue;
                FileLock fileLock = null;
                try {
                    fileLock = fileObject2.lock();
                    fileObject2.delete(fileLock);
                }
                finally {
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        }
    }

    private EntitySpecSerializer serializer() {
        return this._serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(T t) {
        try {
            Object object = this._lock;
            synchronized (object) {
                this.updateEntity(t);
                this.map().put(t.getTypeName(), t);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public String[] getFolders() {
        ArrayList<String> arrayList = new ArrayList<String>();
        FileObject fileObject = FileUtil.getConfigRoot().getFileObject(this._folderName);
        if (fileObject != null) {
            Enumeration enumeration = fileObject.getFolders(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                arrayList.add(fileObject2.getName());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

