/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import com.paterva.maltego.util.StringUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class FileUtilities {
    public static final String TYPE_IMAGE = "Image";
    public static final String TYPE_TEXT = "Text";
    public static final String TYPE_BINARY = "Binary";
    private static String ENV_ALLUSERSPROFILE = "ALLUSERSPROFILE";

    private FileUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTo(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            byte[] byArray = new byte[1024];
            fileOutputStream = new FileOutputStream(file);
            int n = inputStream.read(byArray, 0, byArray.length);
            while (n > 0) {
                fileOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray, 0, byArray.length);
            }
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static FileObject getOrCreate(String string) throws IOException {
        return FileUtilities.getOrCreate(FileUtil.getConfigRoot(), string);
    }

    public static FileObject getOrCreate(FileObject fileObject, String string) throws IOException {
        String[] stringArray;
        for (String string2 : stringArray = string.split("/")) {
            fileObject = FileUtilities.getOrCreateSingle(fileObject, string2);
        }
        return fileObject;
    }

    private static FileObject getOrCreateSingle(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createFolder(string);
        }
        return fileObject.getFileObject(string);
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtilities.getFileExtension(file.getName());
    }

    public static String getFileExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n < 0 || n >= string.length() - 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static File getUserHome() {
        String string = System.getProperty("user.home");
        return new File(string);
    }

    public static File getAllUsersSettings() {
        if (FileUtilities.isWindows()) {
            File file = new File(FileUtilities.getEnvVar(ENV_ALLUSERSPROFILE), "Paterva");
            file = new File(file, "Maltego");
            file.mkdirs();
            file.setWritable(true, false);
            return file;
        }
        String string = System.getProperty("netbeans.user");
        return new File(string);
    }

    public static void windowsFullControl(File file) {
    }

    private static String getEnvVar(String string) {
        String string2 = System.getenv(string);
        if (string.equalsIgnoreCase(ENV_ALLUSERSPROFILE) && FileUtilities.isWindowsXP()) {
            string2 = string2.concat(System.getProperty("file.separator"));
            string2 = string2.concat(FileUtilities.getAppdataFolderName());
        }
        return string2;
    }

    private static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().contains("windows");
    }

    private static boolean isWindowsXP() {
        String string = System.getProperty("os.name");
        return string.contains("Windows XP");
    }

    private static String getAppdataFolderName() {
        String string = System.getenv("APPDATA");
        String[] stringArray = string.split("\\" + System.getProperty("file.separator"));
        return stringArray[stringArray.length - 1];
    }

    public static String replaceIllegalChars(String string) {
        return string.replaceAll("[^A-Za-z0-9_ ]", "_");
    }

    public static String createUniqueLegalFilename(Collection<String> collection, String string) {
        return StringUtilities.createUniqueString(collection, FileUtilities.replaceIllegalChars(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        long l = 0xA00000L;
        if (!file2.exists()) {
            file2.createNewFile();
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel2 = null;
        try {
            fileInputStream = new FileInputStream(file);
            abstractInterruptibleChannel = fileInputStream.getChannel();
            fileOutputStream = new FileOutputStream(file2);
            abstractInterruptibleChannel2 = fileOutputStream.getChannel();
            long l2 = ((FileChannel)abstractInterruptibleChannel).size();
            for (long i = 0L; i < l2; i += ((FileChannel)abstractInterruptibleChannel2).transferFrom((ReadableByteChannel)((Object)abstractInterruptibleChannel), i, 0xA00000L)) {
            }
        }
        finally {
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            } else if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (abstractInterruptibleChannel2 != null) {
                abstractInterruptibleChannel2.close();
            } else if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static String createTempDir(String string) {
        String string2 = FileUtilities.getMaltegoTempDir();
        string2 = string2 + string + File.separatorChar;
        File file = new File(string2);
        try {
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (SecurityException securityException) {
            Logger.getLogger(FileUtilities.class.getName()).log(Level.SEVERE, null, securityException);
        }
        return string2;
    }

    public static String getMaltegoTempDir() {
        String string = System.getProperty("java.io.tmpdir");
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + File.separatorChar;
        }
        String string2 = System.getProperty("maltego.fullversion");
        string2 = string2 + System.getProperty("maltego.branding-code", "");
        string = string + "Maltego" + string2 + File.separatorChar;
        return string;
    }

    public static String getFileType(String string) {
        Object[] objectArray = new String[]{"csv", "htm", "html", "ini", "text", "txt"};
        Object[] objectArray2 = ImageIO.getReaderFileSuffixes();
        Arrays.sort(objectArray);
        Arrays.sort(objectArray2);
        String string2 = FileUtilities.getFileExtension(string).toLowerCase();
        if (Arrays.binarySearch(objectArray, string2) >= 0) {
            return TYPE_TEXT;
        }
        if (Arrays.binarySearch(objectArray2, string2) >= 0) {
            return TYPE_IMAGE;
        }
        return TYPE_BINARY;
    }

    public static boolean delete(File file) {
        FileUtilities.deleteContents(file);
        return file.delete();
    }

    public static void deleteContents(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (FileUtilities.delete(file2)) continue;
                Logger.getLogger(FileUtilities.class.getName()).log(Level.SEVERE, null, "Failed to delete " + file2);
            }
        }
    }

    public static List<File> removeDirectories(List<File> list) {
        if (list == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : list) {
            if (file.isDirectory()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }
}

