/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.DataProviders;
import com.paterva.maltego.imgfactory.ImageFactory;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ImageUtils;
import java.awt.Dimension;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import yguard.A.A.D;
import yguard.A.A.K;

public abstract class EntityImageFactory {
    private static final String IMAGE_FACTORY_PROVIDER_KEY = "maltego.EntityImageFactory";

    public static EntityImageFactory getDefault() {
        EntityImageFactory entityImageFactory = (EntityImageFactory)Lookup.getDefault().lookup(EntityImageFactory.class);
        if (entityImageFactory == null) {
            entityImageFactory = new Trivial();
        }
        return entityImageFactory;
    }

    public static synchronized EntityImageFactory forGraph(D d) {
        DataProviders.Singleton singleton = (DataProviders.Singleton)d.G((Object)IMAGE_FACTORY_PROVIDER_KEY);
        if (singleton == null) {
            singleton = new DataProviders.Singleton((Object)new Registry(EntityRegistry.forGraph((D)d)));
            d.A((Object)IMAGE_FACTORY_PROVIDER_KEY, (K)singleton);
        }
        return (EntityImageFactory)singleton.get();
    }

    public abstract Image getImage(MaltegoEntity var1, int var2, int var3, ImageCallback var4);

    public Image getImage(MaltegoEntity maltegoEntity, ImageCallback imageCallback) {
        return this.getImage(maltegoEntity, -1, -1, imageCallback);
    }

    public abstract Icon getIcon(MaltegoEntity var1, int var2, int var3, ImageCallback var4);

    public abstract Icon getIconMax(MaltegoEntity var1, int var2, int var3, ImageCallback var4);

    public Icon getIcon(MaltegoEntity maltegoEntity, ImageCallback imageCallback) {
        return this.getIcon(maltegoEntity, -1, -1, imageCallback);
    }

    public Icon getTypeIcon(String string, ImageCallback imageCallback) {
        return this.getTypeIcon(string, -1, -1, imageCallback);
    }

    public Icon getSmallTypeIcon(String string, ImageCallback imageCallback) {
        return this.getTypeIcon(string, 16, 16, imageCallback);
    }

    public abstract boolean hasImage(MaltegoEntity var1);

    public abstract Icon getTypeIcon(String var1, int var2, int var3, ImageCallback var4);

    public abstract Image getTypeImage(String var1, int var2, int var3, ImageCallback var4);

    public Image getTypeImage(String string, ImageCallback imageCallback) {
        return this.getTypeImage(string, -1, -1, imageCallback);
    }

    public Image getSmallTypeImage(String string, ImageCallback imageCallback) {
        return this.getTypeImage(string, 16, 16, imageCallback);
    }

    public abstract Image getDefaultSmallImage();

    public abstract Image getDefaultLargeImage();

    public abstract Icon getDefaultSmallIcon();

    public abstract Icon getDefaultLargeIcon();

    private static class Trivial
    extends Abstract {
        @Override
        public Image getImage(MaltegoEntity maltegoEntity, int n, int n2, ImageCallback imageCallback) {
            return this.defaultImageIcon(n2).getImage();
        }

        @Override
        public Icon getIcon(MaltegoEntity maltegoEntity, int n, int n2, ImageCallback imageCallback) {
            return this.defaultImageIcon(n2);
        }

        @Override
        public Icon getTypeIcon(String string, int n, int n2, ImageCallback imageCallback) {
            return this.defaultImageIcon(n2);
        }

        @Override
        public Image getTypeImage(String string, int n, int n2, ImageCallback imageCallback) {
            return this.defaultImageIcon(n2).getImage();
        }

        @Override
        public Icon getIconMax(MaltegoEntity maltegoEntity, int n, int n2, ImageCallback imageCallback) {
            return this.defaultImageIcon(48);
        }

        @Override
        public boolean hasImage(MaltegoEntity maltegoEntity) {
            return false;
        }
    }

    public static class Registry
    extends Abstract {
        private AwtImageCallback _internalCallback = new AwtImageCallback();
        private EntityRegistry _registry;

        public Registry(EntityRegistry entityRegistry) {
            this._registry = entityRegistry;
        }

        public Registry(EntityRegistry entityRegistry, String string) {
            super(string);
            this._registry = entityRegistry;
        }

        @Override
        public Image getImage(MaltegoEntity maltegoEntity, int n, int n2, ImageCallback imageCallback) {
            Image image;
            Object object = InheritanceHelper.getImage((EntityRegistry)this._registry, (MaltegoEntity)maltegoEntity);
            if (object == null) {
                image = this.getTypeImage(maltegoEntity.getTypeName(), n, n2, imageCallback);
            } else {
                image = this.getImageFromFactory(object, n, n2, imageCallback);
                if (image == null) {
                    return this.getTypeImage(maltegoEntity.getTypeName(), n, n2, imageCallback);
                }
            }
            return image;
        }

        private Image getImageFromFactory(Object object, int n, int n2, ImageCallback imageCallback) {
            if (imageCallback == null) {
                imageCallback = this._internalCallback;
            }
            return ImageFactory.getDefault().getImage(object, n, n2, imageCallback);
        }

        private Icon getIconFromFactory(Object object, int n, int n2, ImageCallback imageCallback) {
            if (imageCallback == null) {
                imageCallback = this._internalCallback;
            }
            return ImageFactory.getDefault().getImageIcon(object, n, n2, imageCallback);
        }

        @Override
        public Icon getIcon(MaltegoEntity maltegoEntity, int n, int n2, ImageCallback imageCallback) {
            Icon icon;
            Object object = InheritanceHelper.getImage((EntityRegistry)this._registry, (MaltegoEntity)maltegoEntity);
            if (object == null) {
                icon = this.getTypeIcon(maltegoEntity.getTypeName(), n, n2, imageCallback);
            } else {
                icon = this.getIconFromFactory(object, n, n2, imageCallback);
                if (icon == null) {
                    return this.getTypeIcon(maltegoEntity.getTypeName(), n, n2, imageCallback);
                }
            }
            return icon;
        }

        @Override
        public Icon getTypeIcon(String string, int n, int n2, ImageCallback imageCallback) {
            Image image;
            ImageIcon imageIcon = null;
            MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)this._registry.get(string);
            if (maltegoEntitySpec != null && (image = maltegoEntitySpec.getIcon(n, n2)) != null) {
                imageIcon = new ImageIcon(image);
            }
            if (imageIcon == null) {
                return this.defaultImageIcon(n2);
            }
            return imageIcon;
        }

        @Override
        public Image getTypeImage(String string, int n, int n2, ImageCallback imageCallback) {
            Image image = null;
            MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)this._registry.get(string);
            if (maltegoEntitySpec != null) {
                image = maltegoEntitySpec.getIcon(n, n2);
            }
            if (image == null) {
                image = this.defaultImageIcon(n2).getImage();
            }
            return image;
        }

        private static boolean mustResize(int n, int n2, int n3, int n4) {
            if (n == -1 && n2 == -1) {
                return false;
            }
            return n != n3 || n2 != n4;
        }

        @Override
        public Icon getIconMax(MaltegoEntity maltegoEntity, final int n, final int n2, final ImageCallback imageCallback) {
            Icon icon;
            ImageCallback imageCallback2 = new ImageCallback(){

                public void imageReady(Object object, Object object2) {
                    Icon icon = (Icon)object2;
                    Dimension dimension = Registry.this.calcNewSize(icon.getIconWidth(), icon.getIconHeight(), n, n2);
                    if (dimension != null) {
                        object2 = Registry.this.getIconFromFactory(object, -1, -1, imageCallback);
                    } else {
                        imageCallback.imageReady(object, (Object)icon);
                    }
                }

                public void imageFailed(Object object, Exception exception) {
                    imageCallback.imageFailed(object, exception);
                }

                public boolean needAwtThread() {
                    return imageCallback.needAwtThread();
                }
            };
            Object object = InheritanceHelper.getImage((EntityRegistry)this._registry, (MaltegoEntity)maltegoEntity);
            if (object == null) {
                icon = this.getTypeIcon(maltegoEntity.getTypeName(), imageCallback2);
            } else {
                icon = this.getIconFromFactory(object, -1, -1, imageCallback2);
                if (icon == null) {
                    return this.getTypeIcon(maltegoEntity.getTypeName(), imageCallback2);
                }
                Dimension dimension = this.calcNewSize(icon.getIconWidth(), icon.getIconHeight(), n, n2);
                if (dimension != null) {
                    icon = this.getIconFromFactory(object, dimension.width, dimension.height, imageCallback2);
                }
            }
            return icon;
        }

        private Dimension calcNewSize(float f, float f2, float f3, float f4) {
            float f5;
            float f6;
            if (f <= f3 && f2 <= f4) {
                return null;
            }
            float f7 = f / f2;
            float f8 = f3 / f4;
            if (f7 > f8) {
                f6 = f3;
                f5 = f3 / f7;
            } else {
                f5 = f4;
                f6 = f7 * f4;
            }
            return new Dimension((int)f6, (int)f5);
        }

        @Override
        public boolean hasImage(MaltegoEntity maltegoEntity) {
            return InheritanceHelper.getImage((EntityRegistry)this._registry, (MaltegoEntity)maltegoEntity) != null;
        }

        private static class AwtImageCallback
        implements ImageCallback {
            private AwtImageCallback() {
            }

            public void imageReady(Object object, Object object2) {
            }

            public void imageFailed(Object object, Exception exception) {
            }

            public boolean needAwtThread() {
                return true;
            }
        }
    }

    public static abstract class Abstract
    extends EntityImageFactory {
        private String _defaultResource;
        private ImageIcon[] _default = new ImageIcon[3];
        private static final int ICON_16 = 0;
        private static final int ICON_32 = 1;
        private static final int ICON_48 = 2;

        public Abstract() {
            this("com/paterva/maltego/ui/graph/impl/Unknown.png");
        }

        public Abstract(String string) {
            this._defaultResource = string;
        }

        @Override
        public Image getDefaultSmallImage() {
            return this.defaultImageIcon(16).getImage();
        }

        @Override
        public Image getDefaultLargeImage() {
            return this.defaultImageIcon(48).getImage();
        }

        @Override
        public Icon getDefaultSmallIcon() {
            return this.defaultImageIcon(16);
        }

        @Override
        public Icon getDefaultLargeIcon() {
            return this.defaultImageIcon(48);
        }

        protected ImageIcon defaultImageIcon(int n) {
            int n2 = Abstract.getType(n = Abstract.normalize(n));
            ImageIcon imageIcon = this._default[n2];
            if (imageIcon == null) {
                String string = ImageUtils.getImageFile((String)this._defaultResource, (int)n);
                this._default[n2] = imageIcon = new ImageIcon(ImageUtilities.loadImage((String)string));
            }
            return imageIcon;
        }

        protected static int normalize(int n) {
            if (n < 0) {
                return 48;
            }
            if (n <= 20) {
                return 16;
            }
            if (n <= 38) {
                return 32;
            }
            return 48;
        }

        private static int getType(int n) {
            switch (n) {
                case 16: {
                    return 0;
                }
                case 32: {
                    return 1;
                }
            }
            return 2;
        }
    }
}

