/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import org.openide.explorer.ExplorerManager;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public abstract class ExplorerManagerAction
extends SystemAction {
    public ExplorerManagerAction() {
        this.setEnabled(false);
        TopComponent.getRegistry().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("activated".equals(propertyChangeEvent.getPropertyName())) {
                    TopComponent topComponent = (TopComponent)propertyChangeEvent.getNewValue();
                    ExplorerManager explorerManager = ExplorerManagerAction.find(topComponent);
                    ExplorerManagerAction.this.setEnabled(explorerManager != null);
                }
            }
        });
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        ExplorerManager explorerManager = ExplorerManagerAction.find(topComponent);
        if (explorerManager != null) {
            try {
                this.performAction(explorerManager);
                topComponent.requestActive();
            }
            catch (PropertyVetoException propertyVetoException) {
                Exceptions.printStackTrace((Throwable)propertyVetoException);
            }
        }
    }

    protected static ExplorerManager find(TopComponent topComponent) {
        if (topComponent == null) {
            return null;
        }
        if (topComponent instanceof ExplorerManager.Provider) {
            return ((ExplorerManager.Provider)topComponent).getExplorerManager();
        }
        return (ExplorerManager)topComponent.getLookup().lookup(ExplorerManager.class);
    }

    protected abstract void performAction(ExplorerManager var1) throws PropertyVetoException;

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }
}

