/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.ui.graph.actions.ShowLabelsListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class ShowLabels {
    private static final int MANUAL = 0;
    private static final int TRANSFORM = 1;
    private static final String[] SHOW_LABELS_SETTING = new String[]{"showLabelsManual", "showLabelsTransform"};
    private static boolean[] _showLabels = new boolean[2];
    private static Collection<ShowLabelsListener> _listeners = Collections.synchronizedCollection(new HashSet());

    public static boolean isShowLabelsForManualLinks() {
        return _showLabels[0];
    }

    public static boolean isShowLabelsForTransformLinks() {
        return _showLabels[1];
    }

    public static boolean isShowLabelsForAllLinks() {
        return _showLabels[0] && _showLabels[1];
    }

    public static void setShowLabelsForManualLinks(boolean bl) {
        if (_showLabels[0] != bl) {
            ShowLabels._showLabels[0] = bl;
            ShowLabels.updateShowLabelsSetting(0);
            ShowLabels.fireShowLabelsChanged();
        }
    }

    public static void setShowLabelsForTransformLinks(boolean bl) {
        if (_showLabels[1] != bl) {
            ShowLabels._showLabels[1] = bl;
            ShowLabels.updateShowLabelsSetting(1);
            ShowLabels.fireShowLabelsChanged();
        }
    }

    public static void setShowLabelsForAllLinks(boolean bl) {
        if ((_showLabels[0] && _showLabels[1]) != bl) {
            ShowLabels._showLabels[0] = bl;
            ShowLabels._showLabels[1] = bl;
            ShowLabels.updateShowLabelsSetting(0);
            ShowLabels.updateShowLabelsSetting(1);
            ShowLabels.fireShowLabelsChanged();
        }
    }

    public static void addListener(ShowLabelsListener showLabelsListener) {
        _listeners.add(showLabelsListener);
    }

    public static void removeListener(ShowLabelsListener showLabelsListener) {
        _listeners.remove(showLabelsListener);
    }

    public static boolean isShowLabelForLink(MaltegoLink maltegoLink) {
        MaltegoLinkSpec maltegoLinkSpec = MaltegoLinkSpec.getSpec((MaltegoLink)maltegoLink);
        if (maltegoLinkSpec != null) {
            boolean bl = maltegoLinkSpec.equals((TypeSpec)MaltegoLinkSpec.getManualSpec());
            if (maltegoLink.getShowLabel() == 1) {
                return true;
            }
            if (maltegoLink.getShowLabel() == 0) {
                if (bl && ShowLabels.isShowLabelsForManualLinks()) {
                    return true;
                }
                if (!bl && ShowLabels.isShowLabelsForTransformLinks()) {
                    return true;
                }
            }
        }
        return false;
    }

    private static void updateShowLabelsSetting(int n) {
        Preferences preferences = NbPreferences.forModule(ShowLabels.class);
        preferences.putBoolean(SHOW_LABELS_SETTING[n], _showLabels[n]);
    }

    private static void fireShowLabelsChanged() {
        for (ShowLabelsListener showLabelsListener : _listeners) {
            showLabelsListener.showLabelsChanged();
        }
    }

    static {
        Preferences preferences = NbPreferences.forModule(ShowLabels.class);
        ShowLabels._showLabels[0] = preferences.getBoolean(SHOW_LABELS_SETTING[0], true);
        ShowLabels._showLabels[1] = preferences.getBoolean(SHOW_LABELS_SETTING[1], false);
    }
}

