/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.clipboard;

import com.paterva.maltego.ui.graph.GraphStructureUtils;
import com.paterva.maltego.ui.graph.clipboard.GraphML;
import com.paterva.maltego.ui.graph.clipboard.GraphMLConverter;
import com.paterva.maltego.ui.graph.clipboard.GraphMLTransferable;
import com.paterva.maltego.ui.graph.clipboard.MaltegoFlavor;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import com.paterva.maltego.ui.graph.view2d.Cursors;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import yguard.A.A.A;
import yguard.A.A.D;
import yguard.A.A.E;
import yguard.A.A.Y;
import yguard.A.A.Z;
import yguard.A.I.QA;

public class EntityTransfer
implements ExClipboard.Convertor {
    private String _lastString = null;
    private GraphML _lastGraphML = null;

    public Transferable convert(Transferable transferable) {
        boolean bl = transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
        boolean bl2 = transferable.isDataFlavorSupported(MaltegoFlavor.graphMLFlavor);
        if (!bl2 && !bl) {
            Node[] nodeArray = NodeTransfer.nodes((Transferable)transferable, (int)7);
            if (nodeArray != null && nodeArray.length > 0) {
                try {
                    final GraphML graphML = this.nodesToGraphML(nodeArray);
                    if (graphML != null) {
                        ExTransferable exTransferable = ExTransferable.create((Transferable)transferable);
                        exTransferable.put((ExTransferable.Single)new GraphMLTransferable(graphML));
                        exTransferable.put(new ExTransferable.Single(DataFlavor.stringFlavor){

                            protected Object getData() throws IOException, UnsupportedFlavorException {
                                return graphML.getText();
                            }
                        });
                        nodeArray = NodeTransfer.nodes((Transferable)transferable, (int)6);
                        if (nodeArray != null) {
                            for (Node node : nodeArray) {
                                if (!node.canDestroy()) continue;
                                node.destroy();
                            }
                        }
                        return exTransferable;
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        } else if (bl && !bl2) {
            try {
                ExTransferable exTransferable = ExTransferable.create((Transferable)transferable);
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (!Utilities.compareObjects((Object)string, (Object)this._lastString)) {
                    this._lastString = string;
                    this._lastGraphML = GraphMLConverter.convert(string);
                }
                exTransferable.put((ExTransferable.Single)new GraphMLTransferable(this._lastGraphML));
                return exTransferable;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Exceptions.printStackTrace((Throwable)unsupportedFlavorException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return transferable;
    }

    private GraphML nodesToGraphML(Node[] nodeArray) throws IOException {
        QA qA = EntityTransfer.getGraph(nodeArray[0]);
        if (qA != null) {
            Node[] nodeArray2 = GraphNodeManager.getEntityNodes(nodeArray);
            E e = EntityTransfer.getNodeCursor(nodeArray2);
            Z z = EntityTransfer.getEdgeCursor(qA, nodeArray2);
            return GraphMLConverter.convert(qA, e, z);
        }
        return null;
    }

    private static QA getGraph(Node node) {
        Y y = (Y)node.getLookup().lookup(Y.class);
        if (y != null) {
            D d2 = y.H();
            return (QA)d2;
        }
        return null;
    }

    private static E getNodeCursor(Node[] nodeArray) {
        Cursors.Node node = new Cursors.Node(nodeArray);
        return node;
    }

    private static Z getEdgeCursor(QA qA, Node[] nodeArray) {
        A a2 = GraphStructureUtils.getEdgesBetween((D)qA, new Cursors.Node(nodeArray));
        Z z = a2.q();
        return z;
    }
}

