/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.data;

import com.paterva.maltego.ui.graph.GraphViewManager;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.data.GraphOpenSupport;
import com.paterva.maltego.ui.graph.data.SaveAsCapable;
import com.paterva.maltego.util.FileExtensionFileFilter;
import com.paterva.maltego.util.ui.PasswordUtil;
import com.paterva.maltego.util.ui.ProductRestrictions;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.api.progress.ProgressUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.WeakListeners;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.WindowManager;
import yguard.A.A.D;

class GraphEditorSupport
extends GraphOpenSupport
implements SaveAsCapable {
    private PropertyChangeListener _pcl;

    public GraphEditorSupport(MultiDataObject.Entry entry) {
        super(entry);
        this.attachListener((DataObject)entry.getDataObject());
    }

    private void attachListener(DataObject dataObject) {
        this._pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("modified".equals(propertyChangeEvent.getPropertyName()) && !GraphEditorSupport.this.allEditors.isEmpty()) {
                    GraphEditorSupport.this.updateTitle((Boolean)propertyChangeEvent.getNewValue(), GraphEditorSupport.this.allEditors.getComponents());
                }
            }
        };
        dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._pcl, (Object)this.entry));
    }

    private void updateTitle(final boolean bl, final Enumeration<CloneableTopComponent> enumeration) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = " *";
                while (enumeration.hasMoreElements()) {
                    CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
                    if (bl) {
                        if (cloneableTopComponent.getDisplayName().endsWith(" *")) continue;
                        cloneableTopComponent.setDisplayName(cloneableTopComponent.getDisplayName() + " *");
                        continue;
                    }
                    while (cloneableTopComponent.getDisplayName().endsWith(" *")) {
                        cloneableTopComponent.setDisplayName(cloneableTopComponent.getDisplayName().substring(0, cloneableTopComponent.getDisplayName().length() - " *".length()));
                    }
                }
            }
        });
    }

    protected D getSaveProxy() {
        return GraphViewManager.getDefault().getDefaultViewGraph(this.getGraphDataObject().getGraph());
    }

    public void save() throws IOException {
        if (ProductRestrictions.isGraphSaveEnabled()) {
            GraphDataObject graphDataObject = this.getGraphDataObject();
            if (!graphDataObject.isModified()) {
                return;
            }
            FileObject fileObject = graphDataObject.getPrimaryFile();
            File file = new File(fileObject.getPath());
            if (file.isAbsolute()) {
                SaveWithProgress saveWithProgress = new SaveWithProgress(graphDataObject, graphDataObject.getPassword());
                FileObject fileObject2 = (FileObject)ProgressUtils.showProgressDialogAndRun((ProgressRunnable)saveWithProgress, (String)"Saving graph", (boolean)true);
                if (fileObject2 != null) {
                    graphDataObject.setModified(false);
                    StatusDisplayer.getDefault().setStatusText(this.savedMessage((DataObject)graphDataObject));
                }
            } else {
                this.saveAs();
            }
        }
    }

    protected String savedMessage(DataObject dataObject) {
        return "Saved " + dataObject.getPrimaryFile().getName();
    }

    @Override
    public void saveAs() {
        if (ProductRestrictions.isGraphSaveEnabled()) {
            GraphDataObject graphDataObject = this.getGraphDataObject();
            String string = NbBundle.getMessage(GraphEditorSupport.class, (String)"MSG_SaveTitle");
            FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(GraphEditorSupport.class).setTitle(string);
            fileChooserBuilder.setFileFilter((FileFilter)new FileExtensionFileFilter(graphDataObject.getDefaultExtension(), graphDataObject.getFileDescription()));
            JFileChooser jFileChooser = fileChooserBuilder.createFileChooser();
            jFileChooser.setSelectedFile(new File(graphDataObject.getPrimaryFile().getName()));
            JCheckBox jCheckBox = PasswordUtil.addEncryptOption((JFileChooser)jFileChooser, (boolean)false);
            Frame frame = WindowManager.getDefault().getMainWindow();
            if (jFileChooser.showSaveDialog(frame) == 0) {
                Object object;
                Object object2;
                File file;
                String string2 = null;
                if (jCheckBox.isSelected() && (string2 = PasswordUtil.getPasswordInput((boolean)true)) == null) {
                    return;
                }
                File file2 = jFileChooser.getSelectedFile();
                File file3 = file2.getParentFile();
                String string3 = file2.getName();
                FileObject fileObject = FileUtil.toFileObject((File)file3);
                DataObject dataObject = null;
                if (!string3.toLowerCase().endsWith("." + graphDataObject.getDefaultExtension().toLowerCase())) {
                    string3 = string3 + "." + graphDataObject.getDefaultExtension().toLowerCase();
                }
                if ((file = new File(file3, string3)).exists()) {
                    object2 = NbBundle.getMessage(GraphEditorSupport.class, (String)"MSG_Overwrite", (Object)string3);
                    object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation(object2));
                    if (!NotifyDescriptor.OK_OPTION.equals(object)) {
                        return;
                    }
                }
                if ((object = (FileObject)ProgressUtils.showProgressDialogAndRun((ProgressRunnable)(object2 = new SaveWithProgress(graphDataObject, fileObject, string3, string2)), (String)"Saving graph", (boolean)true)) != null) {
                    graphDataObject.setModified(false);
                    try {
                        dataObject = DataObject.find((FileObject)object);
                        if (dataObject instanceof GraphDataObject) {
                            ((GraphDataObject)dataObject).setPassword(string2);
                        }
                        if (null != dataObject) {
                            this.closeOldOpenNew((DataObject)graphDataObject, dataObject);
                            StatusDisplayer.getDefault().setStatusText(this.savedMessage(dataObject));
                        }
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                    }
                }
            }
        }
    }

    private void closeOldOpenNew(DataObject dataObject, final DataObject dataObject2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println("closed: " + GraphEditorSupport.this.close(false));
                OpenCookie openCookie = (OpenCookie)dataObject2.getCookie(OpenCookie.class);
                if (openCookie != null) {
                    openCookie.open();
                }
            }
        });
    }

    protected boolean close(boolean bl) {
        System.out.println("closing " + this.entry.getDataObject().getPrimaryFile().getName());
        return super.close(bl);
    }

    public void open() {
        FileObject fileObject;
        File file;
        boolean bl = true;
        if (this.getGraphDataObject().getPassword() == null && (file = FileUtil.toFile((FileObject)(fileObject = this.getGraphDataObject().getPrimaryFile()))) != null) {
            try {
                ZipFile zipFile = new ZipFile(file);
                if (zipFile.isEncrypted()) {
                    bl = false;
                    String string = PasswordUtil.getPasswordInput((boolean)false);
                    if (string != null) {
                        zipFile.setPassword(string);
                        if (PasswordUtil.isPasswordValid((ZipFile)zipFile)) {
                            this.getGraphDataObject().setPassword(string);
                            bl = true;
                        } else {
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Unable to open the file because the password was entered incorrectly.");
                            message.setTitle("Incorrect Password");
                            message.setMessageType(0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        }
                    }
                }
            }
            catch (ZipException zipException) {
                Exceptions.printStackTrace((Throwable)zipException);
            }
        }
        if (bl) {
            super.open();
        }
    }

    private class SaveWithProgress
    implements ProgressRunnable<FileObject>,
    Cancellable {
        private GraphDataObject _gdp;
        private FileObject _folder;
        private String _filename;
        private boolean _saveAs;
        private AtomicBoolean _cancelled = new AtomicBoolean(false);
        private ZipParameters _zipParams;

        public SaveWithProgress(GraphDataObject graphDataObject, String string) {
            this._gdp = graphDataObject;
            this._saveAs = false;
            this.setPassword(string);
        }

        public SaveWithProgress(GraphDataObject graphDataObject, FileObject fileObject, String string, String string2) {
            this._gdp = graphDataObject;
            this._folder = fileObject;
            this._filename = string;
            this._saveAs = true;
            this.setPassword(string2);
        }

        private void setPassword(String string) {
            this._zipParams = PasswordUtil.getZipParameters((String)string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject run(ProgressHandle progressHandle) {
            OutputStream outputStream = null;
            FileObject fileObject = null;
            try {
                FileObject fileObject2;
                if (this._saveAs) {
                    fileObject2 = FileUtil.createData((FileObject)this._folder, (String)this._filename);
                } else {
                    fileObject2 = this._gdp.getPrimaryFile();
                    this._filename = fileObject2.getName();
                }
                if (this._zipParams == null) {
                    outputStream = fileObject2.getOutputStream();
                    this._gdp.saveGraph(GraphEditorSupport.this.getSaveProxy(), outputStream, progressHandle, this._cancelled);
                } else {
                    try {
                        File file = FileUtil.toFile((FileObject)fileObject2);
                        if (file.exists()) {
                            file.delete();
                        }
                        ZipFile zipFile = new ZipFile(file);
                        this._gdp.saveGraph(GraphEditorSupport.this.getSaveProxy(), zipFile, this._zipParams, progressHandle, this._cancelled);
                    }
                    catch (ZipException zipException) {
                        throw new IOException(zipException);
                    }
                }
                fileObject = fileObject2;
            }
            catch (UserCancelException userCancelException) {
                StatusDisplayer.getDefault().setStatusText("Save cancelled");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                String string = NbBundle.getMessage(GraphEditorSupport.class, (String)"MSG_SaveFailed", (Object)this._filename);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)iOException, (Object)string));
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
            return fileObject;
        }

        public boolean cancel() {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)"Are you sure you want to cancel?", "Cancel", 2, 3);
            if (NotifyDescriptor.Confirmation.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation))) {
                this._cancelled.set(true);
                return true;
            }
            return false;
        }
    }
}

