/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.graph.DataProviders;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.nodes.EdgeToLinkConverter;
import com.paterva.maltego.ui.graph.nodes.EntityNode;
import com.paterva.maltego.ui.graph.nodes.GraphNode;
import com.paterva.maltego.ui.graph.nodes.LinkNode;
import com.paterva.maltego.ui.graph.nodes.NodeToEntityConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import yguard.A.A.C;
import yguard.A.A.D;
import yguard.A.A.E;
import yguard.A.A.G;
import yguard.A.A.H;
import yguard.A.A.I;
import yguard.A.A.J;
import yguard.A.A.K;
import yguard.A.A.Y;
import yguard.A.A.Z;
import yguard.A.A._;

public class GraphNodeManager {
    private static final String NODE_MANAGER_PROVIDER_KEY = "maltego.GraphNodeManager";
    private GraphNode _root;
    private GraphChildFactory _children;
    private final D _graph;

    public static synchronized GraphNodeManager getInstance(D d2) {
        DataProviders.Singleton singleton = (DataProviders.Singleton)d2.G((Object)NODE_MANAGER_PROVIDER_KEY);
        if (singleton == null) {
            singleton = new DataProviders.Singleton((Object)new GraphNodeManager(d2));
            d2.A((Object)NODE_MANAGER_PROVIDER_KEY, (K)singleton);
        }
        return (GraphNodeManager)singleton.get();
    }

    private GraphNodeManager(D d2) {
        this._graph = d2;
    }

    public Node getNode(Y y) {
        Node node = this._children.get(y);
        return node;
    }

    public Node getNode(H h) {
        return this._children.get(h);
    }

    public Node getNode() {
        if (this._root == null) {
            this._children = new GraphChildFactory(this._graph);
            this._root = new GraphNode(this._graph, Children.create((ChildFactory)this._children, (boolean)false));
        }
        return this._root;
    }

    public int getNodeNodeCount() {
        return this._children._nodes;
    }

    public Collection<Node> getNodes(E e) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        e.toFirst();
        while (e.ok()) {
            linkedList.add(this.getNode(e.node()));
            e.next();
        }
        return linkedList;
    }

    public Collection<Node> getNodes(Z z) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        z.toFirst();
        while (z.ok()) {
            linkedList.add(this.getNode(z.edge()));
            z.next();
        }
        return linkedList;
    }

    public static Node[] getEntityNodes(Node[] nodeArray) {
        if (nodeArray == null) {
            return null;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : nodeArray) {
            Y y = (Y)node.getLookup().lookup(Y.class);
            if (y == null) continue;
            arrayList.add(node);
        }
        return arrayList.toArray(new Node[0]);
    }

    public static Node[] getLinkNodes(Node[] nodeArray) {
        if (nodeArray == null) {
            return null;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : nodeArray) {
            H h = (H)node.getLookup().lookup(H.class);
            if (h == null) continue;
            arrayList.add(node);
        }
        return arrayList.toArray(new Node[0]);
    }

    private static class GraphChildFactory
    extends ChildFactory.Detachable {
        private final D _graph;
        private NodeToEntityConverter _nodeConverter;
        private EdgeToLinkConverter _edgeConverter;
        private I _nodeMap;
        private J _edgeMap;
        private UpdateHandler _updater;
        private int _nodes = 0;

        public GraphChildFactory(D d2) {
            this._graph = d2;
        }

        protected void addNotify() {
            super.addNotify();
            if (this._nodeConverter == null) {
                this._nodeConverter = new NodeToEntityConverter(MaltegoGraphManager.getWrapper((D)this._graph));
                this._edgeConverter = new EdgeToLinkConverter(MaltegoGraphManager.getWrapper((D)this._graph));
                this._nodeMap = this._graph.\u00d5();
                this._edgeMap = this._graph.\u00e6();
                this._updater = new UpdateHandler();
                this._graph.A((_)this._updater);
            }
        }

        protected void removeNotify() {
            super.removeNotify();
            if (this._nodeConverter != null) {
                this._graph.A(this._edgeMap);
                this._graph.A(this._nodeMap);
                this._nodeConverter = null;
                this._edgeConverter = null;
                this._graph.B((_)this._updater);
            }
        }

        protected boolean createKeys(List list) {
            this.populateList(list, (G)this._graph.\u00d1());
            this.populateList(list, (G)this._graph.\u00c9());
            return true;
        }

        private void populateList(List list, G g) {
            while (g.ok()) {
                list.add(g.current());
                g.next();
            }
        }

        public Node get(Y y) {
            assert (y != null);
            Node node = (Node)this._nodeMap.get((Object)y);
            return node;
        }

        public Node get(H h) {
            assert (h != null);
            Node node = (Node)this._edgeMap.get((Object)h);
            return node;
        }

        protected Node createNodeForKey(Object object) {
            if (object instanceof Y) {
                Object object2 = (Node)this._nodeMap.get(object);
                if (object2 == null) {
                    object2 = new EntityNode((Y)object, this._nodeConverter);
                    this._nodeMap.set(object, object2);
                }
                return object2;
            }
            if (object instanceof H) {
                Object object3 = (Node)this._edgeMap.get(object);
                if (object3 == null) {
                    object3 = new LinkNode((H)object, this._edgeConverter);
                    this._edgeMap.set(object, object3);
                }
                return object3;
            }
            throw new IllegalArgumentException("key must be edge or node and not " + object);
        }

        private class UpdateHandler
        implements _ {
            private int _block;
            private boolean _structureChanged = false;

            private UpdateHandler() {
            }

            public void onGraphEvent(C c2) {
                switch (c2.C()) {
                    case 12: {
                        ++this._block;
                        break;
                    }
                    case 13: {
                        --this._block;
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 3: 
                    case 5: 
                    case 10: 
                    case 11: {
                        this._structureChanged = true;
                        break;
                    }
                }
                if (this._block == 0 && this._structureChanged) {
                    this._structureChanged = false;
                    GraphChildFactory.this.refresh(false);
                }
            }
        }
    }
}

