/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.SpecAction;
import com.paterva.maltego.entity.api.SpecActionDescriptor;
import com.paterva.maltego.entity.api.SpecActionRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class SpecActionMenuFactory {
    public JMenu createMenu(String string, List<MaltegoEntity> list, EntityRegistry entityRegistry) {
        JMenu jMenu = null;
        List<Action> list2 = this.getActions(entityRegistry, list);
        if (!list2.isEmpty()) {
            jMenu = new JMenu(string);
            for (Action action : list2) {
                jMenu.add(action);
            }
        }
        return jMenu;
    }

    public JPopupMenu createPopupMenu(String string, List<MaltegoEntity> list, EntityRegistry entityRegistry) {
        JPopupMenu jPopupMenu = null;
        List<Action> list2 = this.getActions(entityRegistry, list);
        if (!list2.isEmpty()) {
            jPopupMenu = new JPopupMenu(string);
            for (Action action : list2) {
                jPopupMenu.add(action);
            }
        }
        return jPopupMenu;
    }

    public List<Action> getActions(EntityRegistry entityRegistry, List<MaltegoEntity> list) {
        List<SpecActionDescriptor> list2 = this.getSortedActionDescriptors(entityRegistry, list);
        ArrayList<Action> arrayList = new ArrayList<Action>(list2.size());
        for (SpecActionDescriptor specActionDescriptor : list2) {
            arrayList.add(new SpecActionMenuAction(entityRegistry, specActionDescriptor, list));
        }
        return arrayList;
    }

    private List<SpecActionDescriptor> getSortedActionDescriptors(EntityRegistry entityRegistry, List<MaltegoEntity> list) {
        Set<SpecActionDescriptor> set = this.getEnabledActionDescriptors(entityRegistry, list);
        ArrayList<SpecActionDescriptor> arrayList = new ArrayList<SpecActionDescriptor>(set);
        Collections.sort(arrayList, new Comparator<SpecActionDescriptor>(){

            @Override
            public int compare(SpecActionDescriptor specActionDescriptor, SpecActionDescriptor specActionDescriptor2) {
                return specActionDescriptor.getDisplayName().compareTo(specActionDescriptor2.getDisplayName());
            }
        });
        return arrayList;
    }

    private Set<SpecActionDescriptor> getEnabledActionDescriptors(EntityRegistry entityRegistry, List<MaltegoEntity> list) {
        HashSet<SpecActionDescriptor> hashSet = new HashSet<SpecActionDescriptor>();
        for (MaltegoEntity maltegoEntity : list) {
            hashSet.addAll(this.getSpecActions((SpecRegistry)entityRegistry, maltegoEntity).keySet());
        }
        return hashSet;
    }

    private Map<SpecActionDescriptor, SpecAction> getSpecActions(SpecRegistry specRegistry, MaltegoEntity maltegoEntity) {
        SpecActionRegistry specActionRegistry = SpecActionRegistry.getDefault();
        Collection collection = InheritanceHelper.getAggregatedActions((SpecRegistry)specRegistry, (String)maltegoEntity.getTypeName());
        HashMap<SpecActionDescriptor, SpecAction> hashMap = new HashMap<SpecActionDescriptor, SpecAction>();
        for (SpecActionDescriptor specActionDescriptor : collection) {
            SpecAction specAction = specActionRegistry.getAction(specActionDescriptor.getType());
            if (specAction == null || !specAction.isEnabledFor(specRegistry, (MaltegoPart)maltegoEntity, specActionDescriptor.getConfig())) continue;
            hashMap.put(specActionDescriptor, specAction);
        }
        return hashMap;
    }

    private class SpecActionMenuAction
    extends AbstractAction {
        private final EntityRegistry _registry;
        private final SpecActionDescriptor _descriptor;
        private final List<MaltegoEntity> _entities;

        public SpecActionMenuAction(EntityRegistry entityRegistry, SpecActionDescriptor specActionDescriptor, List<MaltegoEntity> list) {
            super(specActionDescriptor.getDisplayName());
            this._registry = entityRegistry;
            this._descriptor = specActionDescriptor;
            this._entities = list;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (MaltegoEntity maltegoEntity : this._entities) {
                SpecAction specAction = (SpecAction)SpecActionMenuFactory.this.getSpecActions((SpecRegistry)this._registry, maltegoEntity).get(this._descriptor);
                if (specAction == null || !specAction.isEnabledFor((SpecRegistry)this._registry, (MaltegoPart)maltegoEntity, this._descriptor.getConfig())) continue;
                specAction.perform((SpecRegistry)this._registry, (MaltegoPart)maltegoEntity, this._descriptor.getConfig());
            }
        }
    }
}

