/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityConverter;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.view2d.LabelEditMode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openide.util.WeakListeners;
import yguard.A.A.D;
import yguard.A.I.;
import yguard.A.I.FA;
import yguard.A.I.QA;
import yguard.A.I.aB;

public abstract class EntityLabelNodeRealizer
extends FA
implements PropertyChangeListener {
    private PropertyChangeListener _notesAndBookmarkListener;

    public EntityLabelNodeRealizer() {
        this.setLabel(new EntityLabel());
    }

    public .A createCopy() {
        FA fA = this.create();
        fA.setCenter(this.getCenterX(), this.getCenterY());
        return fA;
    }

    public .A createCopy(.A a2) {
        return super.createCopy(a2);
    }

    protected abstract FA create();

    protected void onTextUpdated() {
    }

    protected void onNotesUpdated(String string) {
    }

    protected void onShowNotesUpdated(boolean bl) {
    }

    protected void onBookmarkUpdated(Integer n) {
    }

    public void setUserData(Object object) {
        super.setUserData(object);
        if (object != null) {
            MaltegoEntity maltegoEntity = (MaltegoEntity)object;
            maltegoEntity.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)maltegoEntity));
            this.updateText(maltegoEntity);
            this._notesAndBookmarkListener = new NotesChangeListener();
            maltegoEntity.addNotesListener(WeakListeners.propertyChange((PropertyChangeListener)this._notesAndBookmarkListener, (Object)maltegoEntity));
            maltegoEntity.addBookmarkListener(WeakListeners.propertyChange((PropertyChangeListener)this._notesAndBookmarkListener, (Object)maltegoEntity));
            this.updateNotesAndBookmark(maltegoEntity);
        }
    }

    private void updateText(MaltegoEntity maltegoEntity) {
        ((EntityLabel)this.getLabel()).updateText(maltegoEntity);
        this.onTextUpdated();
    }

    private void updateNotesAndBookmark(MaltegoEntity maltegoEntity) {
        this.onNotesUpdated(maltegoEntity.getNotes());
        this.onShowNotesUpdated(maltegoEntity.isShowNotes());
        this.onBookmarkUpdated(maltegoEntity.getBookmark());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("displayValue".equals(propertyChangeEvent.getPropertyName()) || "value".equals(propertyChangeEvent.getPropertyName())) {
            MaltegoEntity maltegoEntity = (MaltegoEntity)propertyChangeEvent.getSource();
            this.updateText(maltegoEntity);
            this.repaint();
        }
    }

    private class NotesChangeListener
    implements PropertyChangeListener {
        private NotesChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getNewValue();
            if ("notesChanged".equals(propertyChangeEvent.getPropertyName())) {
                EntityLabelNodeRealizer.this.onNotesUpdated((String)object);
            } else if ("showNotesChanged".equals(propertyChangeEvent.getPropertyName())) {
                EntityLabelNodeRealizer.this.onShowNotesUpdated((Boolean)object);
            } else if ("bookmarkChanged".equals(propertyChangeEvent.getPropertyName())) {
                EntityLabelNodeRealizer.this.onBookmarkUpdated((Integer)object);
            }
            EntityLabelNodeRealizer.this.repaint();
        }
    }

    private static class EntityLabel
    extends aB
    implements LabelEditMode.EditableLabel {
        private EntityLabel() {
        }

        public void updateText(MaltegoEntity maltegoEntity) {
            EntityRegistry entityRegistry = this.getRegistry();
            Object object = null;
            if (entityRegistry != null) {
                object = InheritanceHelper.getDisplayValue((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity);
            }
            this.setTextInternal(object == null ? "<empty>" : object.toString());
        }

        private MaltegoEntity entity() {
            Object object;
            .A a2 = this.getRealizer();
            if (a2 instanceof FA && (object = ((FA)a2).getUserData()) instanceof MaltegoEntity) {
                return (MaltegoEntity)object;
            }
            return null;
        }

        private PropertyDescriptor getDisplayValueProperty() {
            EntityRegistry entityRegistry;
            MaltegoEntity maltegoEntity = this.entity();
            if (maltegoEntity != null && (entityRegistry = this.getRegistry()) != null) {
                return InheritanceHelper.getDisplayValueProperty((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity);
            }
            return null;
        }

        @Override
        public boolean canEdit() {
            PropertyDescriptor propertyDescriptor = this.getDisplayValueProperty();
            if (propertyDescriptor != null) {
                return !propertyDescriptor.isReadonly();
            }
            return true;
        }

        public void setText(String string) {
            PropertyDescriptor propertyDescriptor;
            this.setTextInternal(string);
            MaltegoEntity maltegoEntity = this.entity();
            if (maltegoEntity != null && (propertyDescriptor = this.getDisplayValueProperty()) != null) {
                Object object;
                EntityConverter entityConverter;
                boolean bl = false;
                EntityRegistry entityRegistry = this.getRegistry();
                if (entityRegistry != null && (entityConverter = InheritanceHelper.getConverter((EntityRegistry)entityRegistry, (MaltegoEntity)maltegoEntity, (String)string, (PropertyDescriptor)(object = InheritanceHelper.getValueProperty((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity)))) != null) {
                    entityConverter.convertFrom((Object)string, maltegoEntity, object);
                    bl = true;
                }
                if (!bl) {
                    object = Converter.convertFrom((String)string, (Class)propertyDescriptor.getType());
                    maltegoEntity.setValue(propertyDescriptor, object);
                }
            }
        }

        private EntityRegistry getRegistry() {
            QA qA = this.getGraph2D();
            return EntityRegistry.forGraph((D)qA);
        }

        void setTextInternal(String string) {
            super.setText(string);
        }
    }
}

