/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.GraphWrapper;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.BookmarkFactory;
import com.paterva.maltego.ui.graph.EntityColorFactory;
import com.paterva.maltego.ui.graph.view2d.NodeRealizerSettings;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.GraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import org.openide.util.Exceptions;
import yguard.A.A.D;
import yguard.A.I.;
import yguard.A.I.F;

public class EntitySloppyPainter
extends F {
    private static final int NORMAL_BORDER = 3;
    private static final int SELECTION_BORDER = 5;
    private static final int SELECTION_HIGHLIGHT = 19;
    private static BufferedImage _cachedImage = null;
    private static int _cachedImageSize = 0;
    private static Color _cachedImageColor = null;
    private static Integer _cachedBookmark = null;
    private static boolean _cachedHasNotes = false;
    private static EntityColorFactory _colorFactory = EntityColorFactory.getDefault();

    protected void paintNode(.A a2, Graphics2D graphics2D, boolean bl) {
        if (bl) {
            this.paintSloppy(a2, graphics2D);
        } else {
            this.paint(a2, graphics2D);
        }
    }

    public void paintSloppy(.A a2, Graphics2D graphics2D) {
        int n;
        double d2 = a2.getX();
        double d3 = a2.getY();
        double d4 = a2.getWidth();
        double d5 = a2.getHeight();
        GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)a2.getNode().H());
        MaltegoEntity maltegoEntity = graphWrapper.entity(a2.getNode());
        d2 = d4 / 2.0 - d5 / 2.0 + d2;
        Color color = _colorFactory.getColor(maltegoEntity);
        boolean bl = a2.isSelected();
        if (bl) {
            color = color.darker();
        }
        Integer n2 = maltegoEntity.getBookmark();
        boolean bl2 = !StringUtilities.isNullOrEmpty((String)maltegoEntity.getNotes());
        AffineTransform affineTransform = graphics2D.getTransform();
        int n3 = n = (int)d5;
        if (bl) {
            n3 += 5;
            n3 += 19;
        } else {
            n3 += 3;
        }
        int n4 = (int)((double)n3 * affineTransform.getScaleX()) + 1;
        if (_cachedImage == null || !color.equals(_cachedImageColor) || n4 != _cachedImageSize || !EntitySloppyPainter.areEqual(n2, _cachedBookmark) || bl2 != _cachedHasNotes) {
            Color color2;
            _cachedImage = graphics2D.getDeviceConfiguration().createCompatibleImage(n4, n4, 3);
            Graphics2D graphics2D2 = _cachedImage.createGraphics();
            graphics2D2.setRenderingHints(graphics2D.getRenderingHints());
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.scale(affineTransform.getScaleX(), affineTransform.getScaleY());
            graphics2D2.transform(affineTransform2);
            int n5 = bl ? 5 : 3;
            int n6 = bl ? 19 : 0;
            int n7 = (n5 + n6) / 2;
            if (bl) {
                color2 = NodeRealizerSettings.getDefault().getSelectionBorderColor();
                graphics2D2.setColor(color2);
                graphics2D2.setStroke(new BasicStroke(19.0f));
                graphics2D2.drawOval(9, 9, n3 - 19, n3 - 19);
            }
            graphics2D2.translate(n7, n7);
            graphics2D2.setColor(color);
            graphics2D2.fillOval(0, 0, n, n);
            color2 = bl ? Color.BLACK : color.darker();
            graphics2D2.setColor(color2);
            graphics2D2.setStroke(new BasicStroke(n5));
            graphics2D2.drawOval(0, 0, n, n);
            int n8 = n / 4;
            int n9 = (int)(((double)n + 0.5) / 2.0);
            if (bl2) {
                graphics2D2.setColor(Color.YELLOW);
                graphics2D2.fillRect(n8, n8, n9, n9);
            }
            if (n2 != null) {
                Color color3 = BookmarkFactory.getDefault().getColor(n2);
                GraphicsUtils.drawShadedFatPentagram((Graphics2D)graphics2D2, (int)n8, (int)n8, (int)n9, (int)n9, (Color)color3, (boolean)false, (boolean)false);
            }
            _cachedImageSize = n4;
            _cachedImageColor = color;
            _cachedBookmark = n2;
            _cachedHasNotes = bl2;
        }
        try {
            graphics2D.transform(affineTransform.createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            Exceptions.printStackTrace((Throwable)noninvertibleTransformException);
        }
        double d6 = (double)(n3 - n) / 2.0;
        Point2D.Double double_ = new Point2D.Double(d2 - d6, d3 - d6);
        Point2D.Double double_2 = new Point2D.Double();
        affineTransform.transform(double_, double_2);
        graphics2D.drawImage(_cachedImage, null, (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY());
        graphics2D.setTransform(affineTransform);
    }

    private static boolean areEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object != null) {
            return object.equals(object2);
        }
        return false;
    }
}

