/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.wizard.ex;

import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigComparator;
import com.paterva.maltego.importexport.ConfigExporter;
import com.paterva.maltego.importexport.nodes.AllConfigsNode;
import com.paterva.maltego.importexport.wizard.ex.ExportWizardIterator;
import java.text.MessageFormat;
import java.util.TreeMap;
import org.openide.WizardDescriptor;
import org.openide.util.NbPreferences;

public class ExportWizard {
    public static WizardDescriptor create(ConfigExporter[] configExporterArray) {
        String string = "Export Wizard";
        ExportWizardIterator exportWizardIterator = new ExportWizardIterator();
        WizardDescriptor wizardDescriptor = new WizardDescriptor(exportWizardIterator);
        wizardDescriptor.setTitleFormat(new MessageFormat("Export Wizard - {0}"));
        wizardDescriptor.setTitle("Export Wizard");
        ExportWizard.initializeProperties(wizardDescriptor, configExporterArray);
        exportWizardIterator.initialize(wizardDescriptor);
        return wizardDescriptor;
    }

    private static void initializeProperties(WizardDescriptor wizardDescriptor, ConfigExporter[] configExporterArray) {
        TreeMap<Config, ConfigExporter> treeMap = new TreeMap<Config, ConfigExporter>(new ConfigComparator());
        for (ConfigExporter configExporter : configExporterArray) {
            Config config = configExporter.getCurrentConfig();
            if (config == null) continue;
            treeMap.put(config, configExporter);
        }
        wizardDescriptor.putProperty("selectEverything", (Object)Boolean.TRUE);
        wizardDescriptor.putProperty("encrypt", (Object)Boolean.FALSE);
        wizardDescriptor.putProperty("configsMap", treeMap);
        wizardDescriptor.putProperty("allConfigs", (Object)new AllConfigsNode(treeMap.keySet(), false));
        wizardDescriptor.putProperty("browseDir", (Object)NbPreferences.root().get("browseDir", ""));
    }
}

