/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.Externalizable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

final class MultiFileObject
extends AbstractFolder
implements FileObject.PriorityFileChangeListener {
    static final long serialVersionUID = -2343651324897646809L;
    private static final char EXT_SEP = '.';
    private static final char PATH_SEP = '/';
    static final String WEIGHT_ATTRIBUTE = "weight";
    private static final FileSystem.AtomicAction markAtomicAction = new FileSystem.AtomicAction(){

        @Override
        public void run() {
        }
    };
    static final ThreadLocal<FileObject> attrAskedFileObject = new ThreadLocal();
    private Set delegates;
    private FileObject leader;
    private Reference<MfLock> lock;
    protected Throwable lockedBy;
    private FileChangeListener weakL = (FileChangeListener)WeakListeners.create(FileObject.PriorityFileChangeListener.class, FileChangeListener.class, (EventListener)this, null);
    private static Map<MultiFileObject, AttributeCache> fo2AttribCache = new WeakHashMap<MultiFileObject, AttributeCache>();
    private static final Set<String> SPECIAL_ATTR_NAMES = new HashSet<String>(Arrays.asList("removeWritables", "weight", "java.io.File"));

    public MultiFileObject(MultiFileSystem fs, MultiFileObject parent, String name) {
        super(fs, parent, name);
        this.update();
        if (this.leader == null) {
            this.leader = new AbstractFileObject.Invalid(name);
            this.validFlag = false;
        }
    }

    public MultiFileObject(MultiFileSystem fs) {
        this(fs, null, "");
    }

    public FileSystem getLeaderFileSystem() throws FileStateInvalidException {
        return this.leader.getFileSystem();
    }

    static synchronized void freeAllAttribCaches() {
        fo2AttribCache.clear();
    }

    private void freeAttribCache() {
        this.getAttributeCache().free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeCache getAttributeCache() {
        Class<MultiFileObject> clazz = MultiFileObject.class;
        synchronized (MultiFileObject.class) {
            AttributeCache retval = fo2AttribCache.get(this);
            if (retval == null) {
                retval = new AttributeCache();
                fo2AttribCache.put(this, retval);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return retval;
        }
    }

    private void update() {
        MultiFileSystem mfs = this.getMultiFileSystem();
        FileSystem[] arr = mfs.getDelegates();
        Set now = this.delegates == null ? Collections.EMPTY_SET : this.delegates;
        HashSet<FileObject> del = new HashSet<FileObject>(arr.length * 2);
        Number maxWeight = 0;
        Object led = null;
        String name = this.getPath();
        FileSystem writable = mfs.writableLayer(name);
        for (int i = 0; i < arr.length; ++i) {
            Number weight;
            FileObject fo;
            if (arr[i] == null || (fo = mfs.findResourceOn(arr[i], name)) == null) continue;
            del.add(fo);
            if (!now.remove(fo)) {
                fo.addFileChangeListener(this.weakL);
            }
            if (!fo.isValid()) continue;
            Number number = weight = fo.isRoot() && !mfs.canHaveRootAttributeOnReadOnlyFS(WEIGHT_ATTRIBUTE) ? (Number)0 : (Number)MultiFileObject.weightOf(fo, writable);
            if (led != null && !(weight.doubleValue() > ((Number)maxWeight).doubleValue())) continue;
            led = fo;
            maxWeight = weight;
        }
        for (FileObject fo : now) {
            fo.removeFileChangeListener(this.weakL);
        }
        if (led != null) {
            if (!led.equals(this.leader) && this.leader != null) {
                if (this.isData() && this.isValid()) {
                    this.fileChanged0(new FileEvent(this));
                }
                this.getMultiFileSystem().notifyMigration(this);
            }
            this.leader = led;
        }
        this.delegates = del;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAll() {
        MultiFileSystem mfs = this.getMultiFileSystem();
        try {
            mfs.beginAtomicAction();
            Enumeration<AbstractFolder> en = this.existingSubFiles(true);
            while (en.hasMoreElements()) {
                MultiFileObject mfo = (MultiFileObject)en.nextElement();
                if (mfo.isFolder() && !mfo.isInitialized()) continue;
                mfo.freeAttribCache();
                mfo.superRefresh(true);
            }
        }
        finally {
            mfs.finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAllAfterSetDelegates(FileSystem[] oldFileSystems) {
        try {
            this.getMultiFileSystem().beginAtomicAction();
            FileSystem[] fileSystems = this.getMultiFileSystem().getDelegates();
            Enumeration<AbstractFolder> en = this.existingSubFiles(true);
            while (en.hasMoreElements()) {
                MultiFileObject mfo = (MultiFileObject)en.nextElement();
                if (mfo.isFolder() && !mfo.isInitialized()) continue;
                if (mfo.hasListeners()) {
                    String path = mfo.getPath();
                    FileObject oldLeader = this.findLeader(oldFileSystems, path);
                    FileObject newLeader = this.findLeader(fileSystems, path);
                    if (oldLeader != null && newLeader != null && !oldLeader.equals(newLeader)) {
                        mfo.fileAttributeChanged0(new FileAttributeEvent(mfo, null, null, null));
                    }
                }
                mfo.freeAttribCache();
                mfo.refresh(true);
            }
        }
        finally {
            this.getMultiFileSystem().finishAtomicAction();
        }
    }

    private void refreshAfterEvent(FileEvent fe) {
        FileObject fFile = fe.getFile();
        this.superRefresh(false);
        MultiFileObject mFile = (MultiFileObject)this.getFileObject(fFile.getName(), fFile.getExt());
        if (mFile != null) {
            mFile.superRefresh(false);
        }
    }

    private void superRefresh(boolean expected) {
        super.refresh(expected);
    }

    private FileObject findLeader(FileSystem[] fs, String path) {
        MultiFileSystem mfs = this.getMultiFileSystem();
        Number maxWeight = 0;
        FileObject _leader = null;
        FileSystem writable = mfs.writableLayer(path);
        for (FileSystem f : fs) {
            FileObject fo;
            if (f == null || (fo = mfs.findResourceOn(f, path)) == null) continue;
            Number weight = MultiFileObject.weightOf(fo, writable);
            if (_leader != null && !(weight.doubleValue() > ((Number)maxWeight).doubleValue())) continue;
            _leader = fo;
            maxWeight = weight;
        }
        return _leader;
    }

    private static Number weightOf(FileObject f, FileSystem writable) {
        try {
            if (f.getFileSystem() == writable) {
                return Double.MAX_VALUE;
            }
        }
        catch (FileStateInvalidException x) {
            // empty catch block
        }
        Object weight = f.getAttribute(WEIGHT_ATTRIBUTE);
        if (weight instanceof Number) {
            return (Number)weight;
        }
        if (weight == null) {
            return 0;
        }
        try {
            Logger.getLogger(MultiFileObject.class.getName()).log(Level.WARNING, "File {0} in {1} has nonnumeric weight {2} of type {3}", new Object[]{f.getPath(), f.getFileSystem(), weight, weight.getClass().getName()});
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return 0;
    }

    private MultiFileSystem getMultiFileSystem() {
        return (MultiFileSystem)this.getFileSystem();
    }

    private MultiFileObject getMultiChild(String name) {
        return (MultiFileObject)this.getChild(name);
    }

    private FileObject writable(boolean copyContents) throws IOException {
        MultiFileSystem fs = this.getMultiFileSystem();
        FileSystem single = fs.createWritableOn(this.getPath());
        if (single != this.leader.getFileSystem()) {
            MfLock l;
            if (this.leader.isFolder()) {
                this.leader = FileUtil.createFolder(this.root(single), this.getPath());
            } else {
                FileObject folder = FileUtil.createFolder(this.root(single), this.getParent().getPath());
                this.leader = copyContents ? this.leader.copy(folder, this.leader.getName(), this.leader.getExt()) : folder.createData(this.leader.getNameExt());
            }
            MfLock mfLock = l = this.lock == null ? null : this.lock.get();
            if (l != null) {
                l.addLock(this.leader);
            }
        }
        return this.leader;
    }

    private Enumeration<FileObject> delegates() {
        return this.getMultiFileSystem().delegates(this.getPath());
    }

    private static void updateFoldersLock(FileObject fo) throws IOException {
        while (fo != null) {
            MfLock l;
            MultiFileObject mfo = (MultiFileObject)fo;
            MfLock mfLock = l = mfo.lock == null ? null : mfo.lock.get();
            if (l != null) {
                mfo.writable(true);
            }
            fo = fo.getParent();
        }
    }

    @Override
    protected final String[] list() {
        Properties exclude = new Properties();
        LinkedList<String> addList = new LinkedList<String>();
        HashSet<String> addSet = new HashSet<String>(101);
        Enumeration<FileObject> it = this.delegates();
        while (it.hasMoreElements()) {
            FileObject folder = it.nextElement();
            if (folder == null || !folder.isFolder()) continue;
            FileObject[] arr = folder.getChildren();
            Properties local = null;
            for (int i = 0; i < arr.length; ++i) {
                String name = arr[i].getNameExt();
                if (name.endsWith("_hidden")) {
                    String basename = name.substring(0, name.length() - "_hidden".length());
                    if (local == null) {
                        local = new Properties();
                        local.putAll((Map<?, ?>)exclude);
                    }
                    local.setProperty(basename, basename);
                    if (!this.getMultiFileSystem().getPropagateMasks()) continue;
                }
                if (addSet.contains(name) || exclude.getProperty(name) != null) continue;
                addSet.add(name);
                addList.add(name);
            }
            if (local == null) continue;
            exclude = local;
        }
        if (this.getMultiFileSystem().getPropagateMasks()) {
            addList.removeAll(exclude.keySet());
        }
        String[] res = addList.toArray(new String[addList.size()]);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refresh(String add, String remove, boolean fire, boolean expected) {
        try {
            this.getFileSystem().beginAtomicAction();
            MultiFileObject multiFileObject = this;
            synchronized (multiFileObject) {
                this.update();
                super.refresh(add, remove, fire, expected);
            }
            this.validFlag &= this.leader.isValid();
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    @Override
    protected final AbstractFolder createFile(String name) {
        return new MultiFileObject(this.getMultiFileSystem(), this, name);
    }

    @Override
    public boolean isFolder() {
        return this.parent == null || this.leader.isFolder();
    }

    @Override
    public Date lastModified() {
        return this.leader.lastModified();
    }

    @Override
    public boolean isData() {
        return this.leader.isData();
    }

    @Override
    public boolean isVirtual() {
        return this.leader.isVirtual();
    }

    @Override
    @Deprecated
    public boolean isReadOnly() {
        MultiFileSystem fs = this.getMultiFileSystem();
        if (fs.isReadOnly()) {
            return true;
        }
        if (this.leader.isReadOnly()) {
            try {
                FileSystem simple = fs.createWritableOn(this.getPath());
                return simple == this.leader.getFileSystem();
            }
            catch (IOException e) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canWrite() {
        MultiFileSystem fs = this.getMultiFileSystem();
        if (fs.isReadOnly()) {
            return false;
        }
        if (!this.leader.canWrite()) {
            try {
                FileSystem simple = fs.createWritableOn(this.getPath());
                return simple != this.leader.getFileSystem();
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getMIMEType() {
        return this.leader.getMIMEType();
    }

    @Override
    public long getSize() {
        return this.leader.getSize();
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        return this.leader.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream(FileLock lock) throws IOException {
        try {
            FileLock lWritable;
            FileObject fo;
            this.getFileSystem().beginAtomicAction(markAtomicAction);
            Object object = this;
            synchronized (object) {
                MfLock l = this.testLock(lock);
                fo = this.writable(false);
                lWritable = l.findLock(fo);
            }
            object = fo.getOutputStream(lWritable);
            return object;
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    @Override
    public synchronized boolean isLocked() {
        return this.lock != null && this.lock.get() != null;
    }

    @Override
    public synchronized FileLock lock() throws IOException {
        FileLock f;
        if (this.lock != null && (f = (FileLock)this.lock.get()) != null) {
            FileAlreadyLockedException alreadyLockedException = new FileAlreadyLockedException(this.getPath());
            alreadyLockedException.initCause(this.lockedBy);
            throw alreadyLockedException;
        }
        Set<? extends FileSystem> set = this.getMultiFileSystem().createLocksOn(this.getPath());
        MfLock l = new MfLock(this.leader, this.delegates(), set);
        this.lock = new WeakReference<MfLock>(l);
        assert ((this.lockedBy = new Throwable("Locked by:")) != null);
        return l;
    }

    private MfLock testLock(FileLock l) throws IOException {
        if (this.lock == null) {
            throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_InvalidLock", (Object)l, (Object)this.getPath(), (Object)this.getMultiFileSystem().getDisplayName(), this.lock, (Object[])new Object[0]));
        }
        if (this.lock.get() != l) {
            throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_InvalidLock", (Object)l, (Object)this.getPath(), (Object)this.getMultiFileSystem().getDisplayName(), (Object)this.lock.get(), (Object[])new Object[0]));
        }
        return (MfLock)l;
    }

    @Override
    @Deprecated
    public void setImportant(boolean b) {
        Enumeration<FileObject> en = this.delegates();
        while (en.hasMoreElements()) {
            FileObject fo = en.nextElement();
            fo.setImportant(b);
        }
        if (!b) {
            this.getMultiFileSystem().markUnimportant(this);
        }
    }

    private static final Object voidify(Object o) {
        if (o == null) {
            return new VoidValue(0);
        }
        if (o instanceof VoidValue) {
            VoidValue vv = (VoidValue)o;
            return new VoidValue(vv.level + 1);
        }
        return o;
    }

    private static final Object devoidify(Object o) {
        if (o instanceof VoidValue) {
            VoidValue vv = (VoidValue)o;
            if (vv.level == 0) {
                return null;
            }
            return new VoidValue(vv.level - 1);
        }
        return o;
    }

    @Override
    public Object getAttribute(String attrName) {
        return this.getAttribute(attrName, this.getPath());
    }

    private final Object getAttribute(String attrName, String path) {
        String prefixattr = path.length() == 0 ? null : path.replace('/', '\\') + '\\' + attrName;
        FileObject localFo = this.getAttributeCache().getDelegate();
        String cachedAttrName = this.getAttributeCache().getAttributeName();
        if (localFo != null && !localFo.equals(this) && cachedAttrName.equals(attrName)) {
            Object oPerf;
            if (localFo.isRoot() && prefixattr != null) {
                try {
                    FileSystem foFs = localFo.getFileSystem();
                    if ((!foFs.isReadOnly() || this.getMultiFileSystem().canHaveRootAttributeOnReadOnlyFS(prefixattr)) && (oPerf = this.getAttribute(localFo = foFs.getRoot(), prefixattr, "")) != null) {
                        return MultiFileObject.devoidify(oPerf);
                    }
                }
                catch (FileStateInvalidException fiex) {
                    // empty catch block
                }
            }
            if ((oPerf = this.getAttribute(localFo, attrName, localFo.getPath())) != null) {
                return MultiFileObject.devoidify(oPerf);
            }
        }
        FileSystem[] systems = this.getMultiFileSystem().getDelegates();
        Number maxWeight = 0;
        Object attr = null;
        FileSystem writable = this.getMultiFileSystem().writableLayer(path);
        for (int i = 0; i < systems.length; ++i) {
            Number weight;
            Object o;
            if (systems[i] == null) continue;
            FileObject fo = this.getMultiFileSystem().findResourceOn(systems[i], path);
            if (fo != null && (o = this.getAttribute(fo, attrName, fo.getPath())) != null) {
                if (SPECIAL_ATTR_NAMES.contains(attrName)) {
                    return MultiFileObject.devoidify(o);
                }
                weight = MultiFileObject.weightOf(fo, writable);
                if (attr == null || weight.doubleValue() > ((Number)maxWeight).doubleValue()) {
                    this.getAttributeCache().setDelegate(fo);
                    this.getAttributeCache().setAttributeName(attrName);
                    attr = o;
                    maxWeight = weight;
                }
            }
            if (prefixattr == null || systems[i].isReadOnly() && !this.getMultiFileSystem().canHaveRootAttributeOnReadOnlyFS(prefixattr) || (o = this.getAttribute(fo = systems[i].getRoot(), prefixattr, "")) == null) continue;
            weight = MultiFileObject.weightOf(fo, writable);
            if (attr != null && !(weight.doubleValue() > ((Number)maxWeight).doubleValue())) continue;
            this.getAttributeCache().setDelegate(fo);
            this.getAttributeCache().setAttributeName(attrName);
            attr = o;
            maxWeight = weight;
        }
        return MultiFileObject.devoidify(attr);
    }

    private static boolean sameFullName(FileObject f1, FileObject f2) {
        while (f1 != null && f2 != null) {
            if (!f1.getNameExt().equals(f2.getNameExt())) {
                return false;
            }
            f1 = f1.getParent();
            f2 = f2.getParent();
        }
        return f1 == null && f2 == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAttribute(FileObject fo, String attrName, String path) {
        Object o;
        FileObject previousFO = attrAskedFileObject.get();
        if (previousFO == null || !MultiFileObject.sameFullName(previousFO, this)) {
            attrAskedFileObject.set(this);
        }
        try {
            o = fo instanceof MultiFileObject ? ((MultiFileObject)fo).getAttribute(attrName, path) : (fo instanceof AbstractFileObject ? ((AbstractFileObject)fo).getAttribute(attrName, path) : fo.getAttribute(attrName));
        }
        finally {
            attrAskedFileObject.set(previousFO);
        }
        return o;
    }

    @Override
    public void setAttribute(String attrName, Object value) throws IOException {
        this.setAttribute(attrName, value, true);
    }

    @Override
    void setAttribute(String attrName, Object value, boolean fire) throws IOException {
        String path = this.getPath();
        FileSystem fs = this.getMultiFileSystem().createWritableOn(path);
        FileObject fo = this.getMultiFileSystem().findResourceOn(fs, path);
        Object oldValue = null;
        String attrToSet = attrName;
        if (fire && (oldValue = this.getAttribute(attrName)) == value) {
            return;
        }
        if (fo == null) {
            fo = fs.getRoot();
            attrToSet = path.replace('/', '\\') + '\\' + attrName;
        }
        this.getAttributeCache().setDelegate(fo);
        this.getAttributeCache().setAttributeName(attrToSet);
        if (fo instanceof AbstractFolder) {
            ((AbstractFolder)fo).setAttribute(attrToSet, MultiFileObject.voidify(value), false);
        } else {
            fire = fire && fo.isRoot();
            fo.setAttribute(attrToSet, MultiFileObject.voidify(value));
        }
        if (fire && oldValue != value && this.hasAtLeastOneListeners()) {
            this.fileAttributeChanged0(new FileAttributeEvent(this, attrName, oldValue, value));
        }
    }

    @Override
    public Enumeration<String> getAttributes() {
        return this.getAttributes(this.getPath());
    }

    private final Enumeration<String> getAttributes(String path) {
        HashSet<String> s = new HashSet<String>();
        FileSystem[] systems = this.getMultiFileSystem().getDelegates();
        String prefix = path.length() == 0 ? null : path.replace('/', '\\') + '\\';
        for (int i = 0; i < systems.length; ++i) {
            String attr;
            Enumeration<String> e;
            if (systems[i] == null) continue;
            FileObject fo = this.getMultiFileSystem().findResourceOn(systems[i], path);
            if (fo != null) {
                e = fo.getAttributes();
                while (e.hasMoreElements()) {
                    attr = e.nextElement();
                    s.add(attr);
                }
            }
            if (prefix == null) continue;
            fo = systems[i].getRoot();
            e = fo instanceof MultiFileObject ? ((MultiFileObject)fo).getAttributes("") : (fo instanceof AbstractFileObject ? ((AbstractFileObject)fo).getAttributes("") : fo.getAttributes());
            while (e.hasMoreElements()) {
                attr = e.nextElement();
                if (!attr.startsWith(prefix) || attr.substring(prefix.length()).indexOf(92) != -1) continue;
                s.add(attr.substring(prefix.length()));
            }
        }
        return Collections.enumeration(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject createFolder(String name) throws IOException {
        MultiFileObject fo;
        try {
            this.getFileSystem().beginAtomicAction();
            MultiFileObject multiFileObject = this;
            synchronized (multiFileObject) {
                MultiFileSystem fs = this.getMultiFileSystem();
                if (fs.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FSisRO", (Object)fs.getDisplayName()));
                }
                if (this.isReadOnly()) {
                    IOException ex = new IOException("Read only: " + this.leader + " delegates: " + this.delegates);
                    Exceptions.attachLocalizedMessage((Throwable)ex, (String)NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FisRO", (Object)name, (Object)fs.getDisplayName()));
                    throw ex;
                }
                String fullName = this.getPath() + '/' + name;
                if (!this.isFolder()) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FoNotFolder", (Object)name, (Object)this.getPath(), (Object)fs.getDisplayName()));
                }
                if (this.getFileObject(name) != null) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FolderAlreadyExist", (Object)name, (Object)fs.getDisplayName(), (Object)this.getPath()));
                }
                FileSystem simple = fs.createWritableOn(fullName);
                FileUtil.createFolder(this.root(simple), fullName);
                this.getMultiFileSystem().unmaskFileOnAll(simple, fullName);
                this.refresh(name, null, true, false);
                fo = this.getMultiChild(name);
                if (fo == null) {
                    throw new FileStateInvalidException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_ApplicationCreateError", (Object)this.getPath(), (Object)name));
                }
                FileObject[] chlds = fo.getChildren();
                for (int i = 0; i < chlds.length; ++i) {
                    this.getMultiFileSystem().maskFile(simple, chlds[i].getPath());
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(this, fo), false);
                }
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject createData(String name, String ext) throws IOException {
        MultiFileObject fo;
        try {
            this.getFileSystem().beginAtomicAction();
            MultiFileObject multiFileObject = this;
            synchronized (multiFileObject) {
                String n;
                MultiFileSystem fs = this.getMultiFileSystem();
                if (fs.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FSisRO", (Object)fs.getDisplayName()));
                }
                if (this.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FisRO", (Object)name, (Object)fs.getDisplayName()));
                }
                String string = n = "".equals(ext) ? name : name + '.' + ext;
                if (!this.isFolder()) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FoNotFolder", (Object)n, (Object)this.getPath(), (Object)fs.getDisplayName()));
                }
                if (this.getFileObject(name, ext) != null) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_DataAlreadyExist", (Object)n, (Object)fs.getDisplayName(), (Object)this.getPath()));
                }
                String fullName = this.getPath() + '/' + n;
                FileSystem simple = fs.createWritableOn(fullName);
                FileUtil.createData(this.root(simple), fullName);
                this.getMultiFileSystem().unmaskFileOnAll(simple, fullName);
                this.refresh(n, null, true, false);
                fo = this.getMultiChild(n);
                if (fo == null) {
                    throw new FileStateInvalidException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_ApplicationCreateError", (Object)this.getPath(), (Object)n));
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(this, fo), true);
                }
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(FileLock lock, String name, String ext) throws IOException {
        MultiFileSystem fs = this.getMultiFileSystem();
        if (this.parent == null) {
            throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_CannotRenameRoot", (Object)fs.getDisplayName()));
        }
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                MfLock l = this.testLock(lock);
                String newFullName = this.parent.getPath() + '/' + name;
                if (this.isData() && ext != null && ext.trim().length() > 0) {
                    newFullName = newFullName + '.' + ext;
                }
                String oldFullName = this.getPath();
                if (this.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_CannotRename", (Object)this.getPath(), (Object)this.getMultiFileSystem().getDisplayName(), (Object)newFullName));
                }
                if (this.getFileSystem().isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FSisRO", (Object)this.getMultiFileSystem().getDisplayName()));
                }
                String on = this.getName();
                String oe = this.getExt();
                FileSystem single = fs.createWritableOnForRename(oldFullName, newFullName);
                if (single == this.leader.getFileSystem()) {
                    this.leader.rename(l.findLock(this.leader), name, ext);
                    this.getMultiFileSystem().unmaskFileOnAll(single, newFullName);
                    MultiFileObject.copyContent(this, this.leader);
                } else {
                    FileObject previousLeader = this.leader;
                    if (this.isData()) {
                        FileObject folder = FileUtil.createFolder(this.root(single), this.getParent().getPath());
                        this.leader = this.leader.copy(folder, name, ext);
                        MultiFileObject.copyAttrs(this, this.leader);
                    } else {
                        FileObject fo = FileUtil.createFolder(this.root(single), newFullName);
                        MultiFileObject.copyContent(this, fo);
                        this.leader = fo;
                        this.name = name;
                        this.update();
                    }
                    l.changeLocks(previousLeader, this.leader);
                }
                if (this.getMultiFileSystem().delegates(oldFullName).hasMoreElements()) {
                    this.getMultiFileSystem().maskFile(single, oldFullName);
                    MultiFileObject.updateFoldersLock(this.getParent());
                }
                if (this.isData()) {
                    name = name + '.' + ext;
                }
                String oldName = this.name;
                this.name = name;
                this.parent.refresh(name, oldName);
                if (this.hasAtLeastOneListeners()) {
                    this.fileRenamed0(new FileRenameEvent((FileObject)this, on, oe));
                }
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleDelete(FileLock lock) throws IOException {
        if (this.parent == null) {
            throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_CannotDeleteRoot", (Object)this.getMultiFileSystem().getDisplayName()));
        }
        MultiFileSystem fs = this.getMultiFileSystem();
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                String fullName = this.getPath();
                FileSystem single = fs.createWritableOn(fullName);
                if (this.needsMask(lock, true)) {
                    this.getMultiFileSystem().maskFile(single, fullName);
                    MultiFileObject.updateFoldersLock(this.getParent());
                }
                String n = this.name;
                this.validFlag = false;
                this.parent.refresh(null, n, true, false);
                if (this.hasAtLeastOneListeners()) {
                    this.fileDeleted0(new FileEvent(this));
                }
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    @Override
    public FileObject copy(FileObject target, String name, String ext) throws IOException {
        return this.leader.copy(target, name, ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject move(FileLock lock, FileObject target, String name, String ext) throws IOException {
        MultiFileSystem fs = this.getMultiFileSystem();
        try {
            fs.beginAtomicAction();
            if (this.parent == null) {
                throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_CannotDeleteRoot", (Object)fs.getDisplayName()));
            }
            MfLock lck = this.testLock(lock);
            FileLock l = lck.findLock(this.leader);
            FileSystem simple = fs.createWritableOn(this.getPath());
            if (fs.isReadOnly()) {
                throw new FSException(NbBundle.getMessage(MultiFileObject.class, (String)"EXC_FSisRO", (Object)fs.getDisplayName()));
            }
            if (l == null && this.leader.getFileSystem() != simple) {
                this.leader = this.writable(true);
                l = lck.findLock(this.leader);
            }
            if (this.needsMask(lock, false)) {
                this.getMultiFileSystem().maskFile(simple, this.getPath());
                MultiFileObject.updateFoldersLock(this.getParent());
            }
            FileObject fileObject = this.leader.move(l, target, name, ext);
            return fileObject;
        }
        finally {
            fs.finishAtomicAction();
        }
    }

    @Override
    public final void refresh(boolean expected) {
        if (!this.isInitialized() && this.isFolder()) {
            return;
        }
        Enumeration<FileObject> en = this.delegates();
        while (en.hasMoreElements()) {
            FileObject fo = en.nextElement();
            fo.refresh(expected);
        }
        super.refresh(expected);
    }

    @Override
    public void fileFolderCreated(FileEvent fe) {
        this.updateAll();
    }

    @Override
    public void fileDataCreated(FileEvent fe) {
        this.refreshAfterEvent(fe);
    }

    @Override
    public void fileChanged(FileEvent fe) {
        FileObject changedFile = this;
        if (fe.getSource().equals(this.leader) && this.hasAtLeastOneListeners() && !fe.firedFrom(markAtomicAction)) {
            if (!fe.getFile().equals(fe.getSource())) {
                changedFile = this.getFileObject(fe.getFile().getName(), fe.getFile().getExt());
            }
            if (changedFile != null) {
                this.fileChanged1(new FileEvent((FileObject)this, changedFile, fe.getTime()));
            }
        }
    }

    @Override
    public void fileDeleted(FileEvent fe) {
        if (fe.getFile().isFolder()) {
            this.updateAll();
        } else {
            this.refreshAfterEvent(fe);
        }
    }

    @Override
    public void fileRenamed(FileRenameEvent fe) {
        this.updateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileAttributeChanged(FileAttributeEvent fe) {
        if (!this.hasAtLeastOneListeners() || this.leader == null) {
            return;
        }
        if (!fe.getFile().equals(this.leader) && fe.getName() != null && this.leader.getAttribute(fe.getName()) != null) {
            return;
        }
        if (!fe.getFile().equals(this.leader) && fe.getNewValue() != null && fe.getName() != null && !fe.getNewValue().equals(this.getAttribute(fe.getName()))) {
            return;
        }
        FileAttributeEvent ev = new FileAttributeEvent(this, fe.getName(), fe.getOldValue(), fe.getNewValue());
        try {
            ev.inheritPostNotify(fe);
            this.fileAttributeChanged0(ev);
        }
        finally {
            ev.setPostNotify(null);
        }
    }

    private static void copyContent(FileObject source, FileObject target) throws IOException {
        FileObject[] srcArr = source.getChildren();
        MultiFileObject.copyAttrs(source, target);
        for (int i = 0; i < srcArr.length; ++i) {
            FileObject child = srcArr[i];
            if (MultiFileSystem.isMaskFile(child) || target.getFileObject(child.getName(), child.getExt()) != null) continue;
            if (child.isData()) {
                FileObject fo = FileUtil.copyFile(child, target, child.getName(), child.getExt());
                if (fo == null) continue;
                MultiFileObject.copyAttrs(child, fo);
                continue;
            }
            FileObject targetChild = target.createFolder(child.getName());
            MultiFileObject.copyContent(child, targetChild);
        }
    }

    private static void copyAttrs(FileObject source, FileObject target) {
        Enumeration<String> en = source.getAttributes();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            Object value = source.getAttribute(key);
            try {
                target.setAttribute(key, value);
            }
            catch (IOException ie) {}
        }
    }

    private boolean needsMask(FileLock lock, boolean deleteDelegates) throws IOException {
        MfLock lck = this.testLock(lock);
        Enumeration<FileObject> e = this.getMultiFileSystem().delegates(this.getPath());
        boolean needsMask = false;
        while (e.hasMoreElements()) {
            FileObject fo = e.nextElement();
            FileLock lockForFo = lck.findLock(fo);
            if (lockForFo == null) {
                needsMask = true;
                continue;
            }
            if (!deleteDelegates) continue;
            fo.delete(lockForFo);
        }
        return needsMask;
    }

    private FileObject root(FileSystem fs) {
        return this.getMultiFileSystem().findResourceOn(fs, "");
    }

    final FileObject getLeader() {
        return this.leader;
    }

    private static class AttributeCache {
        private FileObject delegate;
        private String attribName = "";

        private AttributeCache() {
        }

        private void free() {
            this.delegate = null;
            this.attribName = "";
        }

        private void setDelegate(FileObject delegate) {
            this.delegate = delegate;
        }

        private void setAttributeName(String attribName) {
            this.attribName = attribName;
        }

        private FileObject getDelegate() {
            return this.delegate;
        }

        private String getAttributeName() {
            return this.attribName;
        }
    }

    private class MfLock
    extends FileLock {
        private Map<FileObject, FileLock> map = new HashMap<FileObject, FileLock>(11);

        public MfLock(FileObject leader, Enumeration<FileObject> delegates, Set<? extends FileSystem> systems) throws IOException {
            while (delegates.hasMoreElements()) {
                FileObject fo = delegates.nextElement();
                if (!systems.contains(fo.getFileSystem())) continue;
                FileLock l = fo.lock();
                this.map.put(fo, l);
            }
        }

        public FileLock findLock(FileObject fo) {
            return this.map.get(fo);
        }

        public void addLock(FileObject fo) throws IOException {
            this.map.put(fo, fo.lock());
        }

        public void changeLocks(FileObject old, FileObject n) throws IOException {
            FileLock l = this.map.remove(old);
            if (l != null) {
                l.releaseLock();
            }
            this.addLock(n);
        }

        @Override
        public void releaseLock() {
            if (this.isValid()) {
                super.releaseLock();
                this.releaseLockForDelegates();
                if (this.getCurrentMfLock() == this) {
                    MultiFileObject.this.lock = null;
                }
            }
        }

        private FileLock getCurrentMfLock() {
            FileLock currentLock = null;
            if (MultiFileObject.this.lock != null) {
                currentLock = (FileLock)MultiFileObject.this.lock.get();
            }
            return currentLock;
        }

        private void releaseLockForDelegates() {
            for (FileLock l : this.map.values()) {
                l.releaseLock();
            }
            this.map.clear();
        }

        public String toString() {
            return super.toString() + " for " + MultiFileObject.this + " valid=" + this.isValid();
        }
    }

    static final class VoidValue
    implements Externalizable {
        private static final long serialVersionUID = -2743645909916238684L;
        int level;

        VoidValue(int level) {
            this.level = level;
        }

        public VoidValue() {
        }

        public String toString() {
            return "org.openide.filesystems.MultiFileObject.VoidValue#" + this.level;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.level);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.level = in.readInt();
        }
    }
}

