/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.mtgx;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.FileStoreFileEntry;
import com.paterva.maltego.archive.mtz.FileStoreID;
import com.paterva.maltego.archive.mtz.ImageCacheFileEntry;
import com.paterva.maltego.archive.mtz.ImageCacheIndexEntry;
import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.archive.mtz.MaltegoArchiveWriter;
import com.paterva.maltego.archive.mtz.MaltegoEntityEntry;
import com.paterva.maltego.archive.mtz.MaltegoGraphEntry;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.DataProviders;
import com.paterva.maltego.graph.MaltegoGraph;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.imgfactory.ImageCache;
import com.paterva.maltego.imgfactory.serialization.CachedImage;
import com.paterva.maltego.imgfactory.serialization.ImageCacheIndex;
import com.paterva.maltego.imgfactory.serialization.ImageCacheSerializer;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.typing.serializer.AttachmentsPathRegistry;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.util.FastURL;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.UserCancelException;
import yguard.A.A.D;
import yguard.A.A.K;

public class MtgxDataObject
extends GraphDataObject {
    private static final String SPEC_PROVIDER = "maltego.copy.OriginalEntities";

    public MtgxDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException, IOException {
        super(fileObject, multiFileLoader);
    }

    public String getDefaultExtension() {
        return "mtgx";
    }

    public String getFileDescription() {
        return "Maltego graph files";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected D loadGraph() throws IOException {
        MaltegoArchiveReader maltegoArchiveReader = null;
        Map map = null;
        AttachmentsPathRegistry.lock();
        map = AttachmentsPathRegistry.getPaths();
        File file = null;
        try {
            MaltegoEntitySpec maltegoEntitySpec2;
            Object object;
            Object object22;
            String string = "Graph1";
            FileObject fileObject = this.getPrimaryFile();
            File file2 = FileUtil.toFile((FileObject)fileObject);
            if (file2 == null) {
                file2 = file = this.createTempFile(fileObject);
            }
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(file2);
                if (!zipFile.isValidZipFile()) {
                    throw new IOException("Invalid Maltego graph file.");
                }
                if (zipFile.isEncrypted()) {
                    zipFile.setPassword(this.getPassword());
                }
            }
            catch (ZipException zipException) {
                throw new IOException(zipException);
            }
            maltegoArchiveReader = new MaltegoArchiveReader(zipFile);
            List list = maltegoArchiveReader.readAll(FileStoreFileEntry.class, string);
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            for (Object object22 : list) {
                object = "";
                if (!string.equals(object22.getSubfolder())) {
                    object = object22.getSubfolder().substring(string.length() + 1);
                    object = (String)object + "/";
                }
                hashMap.put(object22.getId(), (String)object + object22.getFilename());
            }
            AttachmentsPathRegistry.setPaths(hashMap);
            List list2 = maltegoArchiveReader.readAll(ImageCacheIndexEntry.class, string);
            object22 = maltegoArchiveReader.readAll(ImageCacheFileEntry.class, string);
            this.updateImageCache(list2, (List<CachedImage>)object22);
            object = maltegoArchiveReader.readAll(MaltegoEntityEntry.class, string);
            DataProviders.Singleton singleton = object.toArray(new MaltegoEntitySpec[object.size()]);
            final EntityRegistry entityRegistry = EntityRegistry.getDefault();
            final ArrayList<MaltegoEntitySpec> arrayList = new ArrayList<MaltegoEntitySpec>();
            for (MaltegoEntitySpec maltegoEntitySpec2 : singleton) {
                if (entityRegistry.contains(maltegoEntitySpec2.getTypeName())) continue;
                arrayList.add(maltegoEntitySpec2);
            }
            if (!arrayList.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)"The graph contains unknown entities. Do you want to import them so that you can use them in other graphs as well?", "New Entities", 0);
                        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation))) {
                            for (MaltegoEntitySpec maltegoEntitySpec : arrayList) {
                                entityRegistry.put((TypeSpec)maltegoEntitySpec, maltegoEntitySpec.getDefaultCategory());
                            }
                        }
                    }
                });
            }
            DataProviders.Singleton singleton2 = new DataProviders.Singleton((Object)singleton);
            EntityRegistry.Memory memory = new EntityRegistry.Memory((MaltegoEntitySpec[])singleton);
            EntityRegistry.Proxy proxy = new EntityRegistry.Proxy(new EntityRegistry[]{entityRegistry, memory});
            maltegoEntitySpec2 = new EntityFactory.Registry((EntityRegistry)proxy);
            D d = maltegoArchiveReader.readGraph(string, (EntityFactory)maltegoEntitySpec2);
            EntityRegistry.associate((D)d, (EntityRegistry)proxy);
            d.A((Object)SPEC_PROVIDER, (K)singleton2);
            D d2 = d;
            return d2;
        }
        finally {
            if (file != null) {
                file.delete();
            }
            AttachmentsPathRegistry.setPaths((Map)map);
            AttachmentsPathRegistry.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempFile(FileObject fileObject) throws IOException {
        File file = null;
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            file = File.createTempFile("mtgx", null);
            fileOutputStream = new FileOutputStream(file);
            inputStream = fileObject.getInputStream();
            FileUtil.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return file;
    }

    public void saveGraph(D d, OutputStream outputStream, ProgressHandle progressHandle, AtomicBoolean atomicBoolean) throws IOException {
        MaltegoArchiveWriter maltegoArchiveWriter = new MaltegoArchiveWriter(outputStream);
        this.save(d, maltegoArchiveWriter, progressHandle, atomicBoolean);
    }

    public void saveGraph(D d, ZipFile zipFile, ZipParameters zipParameters, ProgressHandle progressHandle, AtomicBoolean atomicBoolean) throws IOException {
        MaltegoArchiveWriter maltegoArchiveWriter = new MaltegoArchiveWriter(zipFile, zipParameters);
        this.save(d, maltegoArchiveWriter, progressHandle, atomicBoolean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(D d, MaltegoArchiveWriter maltegoArchiveWriter, ProgressHandle progressHandle, AtomicBoolean atomicBoolean) throws IOException {
        try {
            Set<String> set;
            String string;
            Object object;
            Object object22;
            String string2 = "Graph1";
            int n = 0;
            Set<Attachments> set2 = this.getAttachments(d);
            ImageCacheIndex imageCacheIndex = null;
            if (ImageCacheSerializer.isEnabled()) {
                imageCacheIndex = this.getImageCacheIndex("Graph1", d);
            }
            if (progressHandle != null) {
                progressHandle.progress("Preparing to save...");
                int n2 = 0;
                for (Attachments attachments : set2) {
                    n2 += attachments.size() * 2;
                }
                int n3 = 1;
                int n4 = 1;
                int n5 = imageCacheIndex != null ? imageCacheIndex.size() : 0;
                progressHandle.switchToDeterminate(n2 + n3 + n4 + n5);
            }
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            ArrayList arrayList = new ArrayList();
            for (Attachments attachments : set2) {
                for (Object object3 : attachments) {
                    int n6 = object3.getId();
                    object22 = object3.getFileName();
                    int n7 = -1;
                    do {
                        if (arrayList.size() > ++n7) continue;
                        arrayList.add(new HashSet());
                    } while (((Set)arrayList.get(n7)).contains(object22));
                    ((Set)arrayList.get(n7)).add(object22);
                    String string3 = "";
                    object = "/Graph1";
                    if (n7 > 0) {
                        string = Integer.toString(n7);
                        object = (String)object + "/" + string;
                        string3 = string + "/";
                    }
                    hashMap.put(n6, string3 + (String)object22);
                    string = new FileStoreID(n6, (String)object, (String)object22);
                    this.updateProgress(progressHandle, "Saving attachments - " + (String)object22, n, atomicBoolean);
                    n += 2;
                    maltegoArchiveWriter.write((Entry)new FileStoreFileEntry((FileStoreID)string));
                }
            }
            AttachmentsPathRegistry.setPaths(hashMap);
            this.updateProgress(progressHandle, "Saving graph", n++, atomicBoolean);
            maltegoArchiveWriter.write((Entry)new MaltegoGraphEntry(d, "Graph1"));
            this.updateProgress(progressHandle, "Saving entities", n++, atomicBoolean);
            EntityRegistry entityRegistry = EntityRegistry.getDefault();
            DataProviders.Singleton singleton = (DataProviders.Singleton)d.G((Object)SPEC_PROVIDER);
            if (singleton != null) {
                set = new EntityRegistry.Memory((MaltegoEntitySpec[])singleton.get());
                entityRegistry = new EntityRegistry.Proxy(new EntityRegistry[]{set, entityRegistry});
            }
            set = this.getUniqueEntityTypes(d);
            set = this.appendInheritedEntityTypes(entityRegistry, set);
            for (String string4 : set) {
                object22 = (MaltegoEntitySpec)entityRegistry.get(string4);
                if (object22 == null) continue;
                maltegoArchiveWriter.write((Entry)new MaltegoEntityEntry((MaltegoEntitySpec)object22));
            }
            if (imageCacheIndex != null && !imageCacheIndex.isEmpty()) {
                Object object3;
                maltegoArchiveWriter.write((Entry)new ImageCacheIndexEntry(imageCacheIndex));
                object3 = ImageCache.getDefault();
                for (Object object22 : imageCacheIndex.entrySet()) {
                    String string5 = imageCacheIndex.getName();
                    int n8 = (Integer)object22.getKey();
                    object = object3.getImage(object22.getValue(), null);
                    string = new CachedImage(string5, n8, (Image)object);
                    this.updateProgress(progressHandle, "Saving entity images - " + object22.getValue(), n++, atomicBoolean);
                    maltegoArchiveWriter.write((Entry)new ImageCacheFileEntry((CachedImage)string));
                }
            }
            this.updateProgress(progressHandle, "Done", n, atomicBoolean);
        }
        finally {
            AttachmentsPathRegistry.setPaths(null);
            maltegoArchiveWriter.close();
        }
    }

    private void updateProgress(ProgressHandle progressHandle, String string, int n, AtomicBoolean atomicBoolean) throws UserCancelException {
        if (progressHandle != null) {
            progressHandle.progress(string, n);
            if (atomicBoolean.get()) {
                throw new UserCancelException("Cancelled");
            }
        }
    }

    private Set<String> getUniqueEntityTypes(D d) {
        TreeSet<String> treeSet = new TreeSet<String>();
        MaltegoGraph maltegoGraph = MaltegoGraphManager.get((D)d);
        for (MaltegoEntity maltegoEntity : maltegoGraph.entities()) {
            treeSet.add(maltegoEntity.getTypeName());
        }
        return treeSet;
    }

    private Set<String> appendInheritedEntityTypes(EntityRegistry entityRegistry, Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            List list = InheritanceHelper.getInheritanceList((SpecRegistry)entityRegistry, (String)string);
            hashSet.addAll(list);
        }
        hashSet.addAll(set);
        hashSet.remove("maltego.Unknown");
        return hashSet;
    }

    private ImageCacheIndex getImageCacheIndex(String string, D d) {
        ImageCacheIndex imageCacheIndex = new ImageCacheIndex(string);
        Integer n = 0;
        for (FastURL fastURL : this.getCachedImageUrls(d)) {
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
            imageCacheIndex.put((Object)n2, (Object)fastURL);
        }
        return imageCacheIndex;
    }

    private Set<FastURL> getCachedImageUrls(D d) {
        ImageCache imageCache = ImageCache.getDefault();
        MaltegoGraph maltegoGraph = MaltegoGraphManager.get((D)d);
        EntityRegistry entityRegistry = EntityRegistry.forGraph((D)d);
        HashSet<FastURL> hashSet = new HashSet<FastURL>();
        for (MaltegoEntity maltegoEntity : maltegoGraph.entities()) {
            Object object = InheritanceHelper.getImage((EntityRegistry)entityRegistry, (MaltegoEntity)maltegoEntity);
            if (!(object instanceof FastURL) || !imageCache.contains(object)) continue;
            hashSet.add((FastURL)object);
        }
        return hashSet;
    }

    private void updateImageCache(List<ImageCacheIndex> list, List<CachedImage> list2) {
        ImageCache imageCache = ImageCache.getDefault();
        for (ImageCacheIndex imageCacheIndex : list) {
            for (CachedImage cachedImage : list2) {
                FastURL fastURL;
                if (imageCacheIndex == null || cachedImage == null || !imageCacheIndex.getName().equals(cachedImage.getCacheName()) || (fastURL = (FastURL)imageCacheIndex.get((Object)cachedImage.getId())) == null) continue;
                imageCache.addImage((Object)fastURL, cachedImage.getImage());
            }
        }
    }

    private Set<Attachments> getAttachments(D d) {
        MaltegoGraph maltegoGraph = MaltegoGraphManager.get((D)d);
        HashSet<Attachments> hashSet = new HashSet<Attachments>();
        for (MaltegoEntity maltegoEntity : maltegoGraph.entities()) {
            this.addAttachments((MaltegoPart)maltegoEntity, hashSet);
        }
        for (MaltegoEntity maltegoEntity : maltegoGraph.links()) {
            this.addAttachments((MaltegoPart)maltegoEntity, hashSet);
        }
        return hashSet;
    }

    private void addAttachments(MaltegoPart maltegoPart, Set<Attachments> set) {
        PropertyDescriptorCollection propertyDescriptorCollection = maltegoPart.getProperties();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorCollection) {
            Object object;
            if (!Attachments.class.equals((Object)propertyDescriptor.getType()) || !((object = maltegoPart.getValue(propertyDescriptor)) instanceof Attachments)) continue;
            set.add((Attachments)object);
        }
    }
}

