# config from cloud.resource where api.name = 'aws-appsync-graphql-api' AND json.rule = wafWebAclArn is not empty as X; config from cloud.resource where api.name = 'aws-waf-v2-web-acl-resource' AND json.rule = (webACL.postProcessFirewallManagerRuleGroups.firewallManagerStatement.name does not contain AWSManagedRulesAnonymousIpList or webACL.postProcessFirewallManagerRuleGroups.firewallManagerStatement.name does not contain AWSManagedRulesKnownBadInputsRuleSet) and NOT ( webACL.rules[*].statement.managedRuleGroupStatement.name contains AWSManagedRulesAnonymousIpList and webACL.rules[*].statement.managedRuleGroupStatement.name contains AWSManagedRulesKnownBadInputsRuleSet ) as Y; filter '$.Y.webACL.arn equals $.X.wafWebAclArn'; show X;

# Fail
resource "aws_wafv2_web_acl" "example_fail" {
  name        = "appsync-waf-fail"
  description = "WAF"
  scope       = "REGIONAL" # AppSync WAFs are REGIONAL

  default_action {
    allow {}
  }

  # Missing AWSManagedRulesKnownBadInputsRuleSet
  rule {
    name     = "AWSManagedRulesAnonymousIpListRule"
    priority = 1

    override_action {
      none {}
    }

    statement {
      managed_rule_group_statement {
        name        = "AWSManagedRulesAnonymousIpList"
        vendor_name = "AWS"
      }
    }

    visibility_config {
      cloudwatch_metrics_enabled = false
      metric_name                = "AnonymousIpList"
      sampled_requests_enabled   = false
    }
  }

  visibility_config {
    cloudwatch_metrics_enabled = false
    metric_name                = "appsync-waf-fail"
    sampled_requests_enabled   = false
  }
}

resource "aws_appsync_graphql_api" "example_fail" {
  authentication_type = "API_KEY"
  name                = "appsync-api-fail"
}

resource "aws_wafv2_web_acl_association" "example_fail" {
  resource_arn = aws_appsync_graphql_api.example_fail.arn
  web_acl_arn  = aws_wafv2_web_acl.example_fail.arn
}

# Fail2
resource "aws_wafv2_web_acl" "example_fail2" {
  name        = "appsync-waf-fail2"
  description = "WAF"
  scope       = "REGIONAL" # AppSync WAFs are REGIONAL

  default_action {
    allow {}
  }

  # Includes BOTH required managed rule groups
  rule {
    name     = "AWSManagedRulesAnonymousIpListRule"
    priority = 1

    override_action {
      none {}
    }

    statement {
      managed_rule_group_statement {
        name        = "AWSManagedRulesAnonymousIpList"
        vendor_name = "AWS"
      }
    }

    visibility_config {
      cloudwatch_metrics_enabled = false
      metric_name                = "AnonymousIpList"
      sampled_requests_enabled   = false
    }
  }

  rule {
    name     = "AWSManagedRulesKnownBadInputsRuleSetRule"
    priority = 2

    override_action {
      none {}
    }

    statement {
      managed_rule_group_statement {
        name        = "foo"
        vendor_name = "AWS"
      }
    }

    visibility_config {
      cloudwatch_metrics_enabled = false
      metric_name                = "KnownBadInputs"
      sampled_requests_enabled   = false
    }
  }

  visibility_config {
    cloudwatch_metrics_enabled = false
    metric_name                = "appsync-waf-pass"
    sampled_requests_enabled   = false
  }
}

resource "aws_appsync_graphql_api" "example_fail2" {
  authentication_type = "API_KEY"
  name                = "appsync-api-fail2"
}

resource "aws_wafv2_web_acl_association" "example_fail2" {
  resource_arn = aws_appsync_graphql_api.example_fail2.arn
  web_acl_arn  = aws_wafv2_web_acl.example_fail2.arn
}

# ==================================
# Pass
resource "aws_wafv2_web_acl" "example_pass" {
  name        = "appsync-waf-pass"
  description = "WAF"
  scope       = "REGIONAL" # AppSync WAFs are REGIONAL

  default_action {
    allow {}
  }

  # Includes BOTH required managed rule groups
  rule {
    name     = "AWSManagedRulesAnonymousIpListRule"
    priority = 1

    override_action {
      none {}
    }

    statement {
      managed_rule_group_statement {
        name        = "AWSManagedRulesAnonymousIpList"
        vendor_name = "AWS"
      }
    }

    visibility_config {
      cloudwatch_metrics_enabled = false
      metric_name                = "AnonymousIpList"
      sampled_requests_enabled   = false
    }
  }

  rule {
    name     = "AWSManagedRulesKnownBadInputsRuleSetRule"
    priority = 2

    override_action {
      none {}
    }

    statement {
      managed_rule_group_statement {
        name        = "AWSManagedRulesKnownBadInputsRuleSet"
        vendor_name = "AWS"
      }
    }

    visibility_config {
      cloudwatch_metrics_enabled = false
      metric_name                = "KnownBadInputs"
      sampled_requests_enabled   = false
    }
  }

  visibility_config {
    cloudwatch_metrics_enabled = false
    metric_name                = "appsync-waf-pass"
    sampled_requests_enabled   = false
  }
}

resource "aws_appsync_graphql_api" "example_pass" {
  authentication_type = "API_KEY"
  name                = "appsync-api-pass"
}

resource "aws_wafv2_web_acl_association" "example_pass" {
  resource_arn = aws_appsync_graphql_api.example_pass.arn
  web_acl_arn  = aws_wafv2_web_acl.example_pass.arn
}


# Pass - not connected
resource "aws_appsync_graphql_api" "pass_not_connected" {
  authentication_type = "API_KEY"
  name                = "not-connected"
}