from exploits.ACVE import ACVE
from . import Utils

__author__ = "Benoit Maurin <bmaurin@immunit.ch> - Jean Lejeune <jlejeune@immunit.ch>"
__copyright__ = "Copyright 2019, ImmunIT"


class Checker(ACVE):
    """This class checks if the given target is vulnerable to the CVE-2018-7600.
    """

    def __init__(self, request, logger):
        self.logger = logger
        self.helper = Utils.Helper(request.url, request, logger)

    def run(self, version):
        if self.helper.setup():
            self.logger.handle("\n[+] The target seems to be vulnerable", self.logger.SUCCESS)
        else:
            self.logger.handle("\n[-] The target is not vulnerable", self.logger.ERROR)