---
title: "RDP"
draft: false
description: "Reference material for the RDP exploiter"
pre: "<i class='fas fa-desktop'></i> "
---

{{< table_of_contents >}}

## Supported operating systems

| Operating system | Attack from                 | Target                      |
| :--------------- | :-------------------------- | :-------------------------- |
| Linux            | {{< os-icon-supported >}}   | {{< os-icon-unsupported >}} |
| Windows          | {{< os-icon-supported >}}   | {{< os-icon-supported >}}   |

## Configuration

<!--
This documentation was autogenerated by passing the plugin's config-schema.json
through https://github.com/adobe/jsonschema2md. It was then modified by hand to
remove extraneous information.
-->

| Property                                                       | Type     | Required | Nullable       |
| :------------------------------------------------------------- | :------- | :------- | :------------- |
| [agent\_binary\_upload\_timeout](#agent_binary_upload_timeout) | `number` | Optional | cannot be null |
| [domains](#domains)                                            | `array`  | Optional | cannot be null |
| [login\_timeout](#login_timeout)                               | `number` | Optional | cannot be null |
| [rdp\_connect\_timeout](#rdp_connect_timeout)                  | `number` | Optional | cannot be null |

### agent\_binary\_upload\_timeout

The timeout (in seconds) for uploading the Agent binary to the target machine.

`agent_binary_upload_timeout`

* is optional

* Type: `number`

* cannot be null

#### agent\_binary\_upload\_timeout Constraints

**maximum**: the value of this number must smaller than or equal to: `100`

**minimum (exclusive)**: the value of this number must be greater than: `0`

#### agent\_binary\_upload\_timeout Default Value

The default value is:

```json
30
```

### domains

The Windows domains to try when logging in to the target machine.

`domains`

* is optional

* Type: `string[]`

* cannot be null

#### domains Constraints

**unique items**: all items in this array must be unique. Duplicates are not allowed.

#### domains Default Value

The default value is:

```json
[
  "WORKGROUP"
]
```

### login\_timeout

The maximum time (in seconds) to wait for the desktop to load after logging in.

`login_timeout`

* is optional

* Type: `number`

* cannot be null

#### login\_timeout Constraints

**maximum**: the value of this number must smaller than or equal to: `100`

**minimum (exclusive)**: the value of this number must be greater than: `0`

#### login\_timeout Default Value

The default value is:

```json
60
```

### rdp\_connect\_timeout

The maximum time (in seconds) to wait for a response on an RDP connection.

`rdp_connect_timeout`

* is optional

* Type: `number`

* cannot be null

#### rdp\_connect\_timeout Constraints

**maximum**: the value of this number must smaller than or equal to: `100`

**minimum (exclusive)**: the value of this number must be greater than: `0`

#### rdp\_connect\_timeout Default Value

The default value is:

```json
15
```

## Order of credentials used for brute-forcing

Different combinations of credentials are attempted in the following order:

1. Brute force usernames and passwords
1. Brute force usernames and NT hashes
