from typing import Callable

from agentpluginapi import (
    IAgentBinaryRepository,
    IAgentCommandBuilderFactory,
    IAgentEventPublisher,
    IHTTPAgentBinaryServerRegistrar,
    IPropagationCredentialsRepository,
    ITCPPortSelector,
    LocalMachineInfo,
)
from monkeytypes import AgentID
from serpentarium import SingleUsePlugin

from .i_plugin_factory import IPluginFactory


class ExploiterPluginFactory(IPluginFactory):
    def __init__(
        self,
        agent_id: AgentID,
        http_agent_binary_server_registrar: IHTTPAgentBinaryServerRegistrar,
        agent_binary_repository: IAgentBinaryRepository,
        agent_event_publisher: IAgentEventPublisher,
        propagation_credentials_repository: IPropagationCredentialsRepository,
        tcp_port_selector: ITCPPortSelector,
        local_machine_info: LocalMachineInfo,
        agent_command_builder_factory: IAgentCommandBuilderFactory,
        create_plugin: Callable[..., SingleUsePlugin],
    ):
        self._agent_id = agent_id
        self._http_agent_binary_server_registrar = http_agent_binary_server_registrar
        self._agent_binary_repository = agent_binary_repository
        self._agent_event_publisher = agent_event_publisher
        self._propagation_credentials_repository = propagation_credentials_repository
        self._tcp_port_selector = tcp_port_selector
        self._local_machine_info = local_machine_info
        self._agent_command_builder_factory = agent_command_builder_factory
        self._create_plugin = create_plugin

    def create(self, plugin_name: str) -> SingleUsePlugin:
        return self._create_plugin(
            plugin_name=plugin_name,
            agent_id=self._agent_id,
            agent_binary_repository=self._agent_binary_repository,
            agent_event_publisher=self._agent_event_publisher,
            propagation_credentials_repository=self._propagation_credentials_repository,
            tcp_port_selector=self._tcp_port_selector,
            http_agent_binary_server_registrar=self._http_agent_binary_server_registrar,
            local_machine_info=self._local_machine_info,
            agent_command_builder_factory=self._agent_command_builder_factory,
        )
