# Leo colorizer control file for nsis2 mode.
# This file is in the public domain.

# Properties for nsis2 mode.
properties = {
    "indentNextLine": "\\s*(.*:|(function\\s+.*)|(section\\s+.*)|(subsection\\s+.*))",
    "lineComment": ";",
}

# Attributes dict for nsis2_main ruleset.
nsis2_main_attributes_dict = {
    "default": "NULL",
    "digit_re": "",
    "escape": "$\\",
    "highlight_digits": "true",
    "ignore_case": "true",
    "no_word_sep": "",
}

# Attributes dict for nsis2_nsis_literal ruleset.
nsis2_nsis_literal_attributes_dict = {
    "default": "LITERAL1",
    "digit_re": "",
    "escape": "$\\",
    "highlight_digits": "true",
    "ignore_case": "true",
    "no_word_sep": "-{}_",
}

# Dictionary of attributes dictionaries for nsis2 mode.
attributesDictDict = {
    "nsis2_main": nsis2_main_attributes_dict,
    "nsis2_nsis_literal": nsis2_nsis_literal_attributes_dict,
}

# Keywords dict for nsis2_main ruleset.
nsis2_main_keywords_dict = {
    "!addincludedir": "keyword2",
    "!addplugindir": "keyword2",
    "!cd": "keyword2",
    "!define": "keyword2",
    "!echo": "keyword2",
    "!else": "keyword1",
    "!endif": "keyword1",
    "!error": "keyword2",
    "!ifdef": "keyword1",
    "!ifndef": "keyword1",
    "!include": "keyword2",
    "!insertmacro": "keyword2",
    "!macro": "keyword1",
    "!macroend": "keyword1",
    "!packhdr": "keyword2",
    "!system": "keyword2",
    "!undef": "keyword2",
    "!verbose": "keyword2",
    "!warning": "keyword2",
    "$$": "literal3",
    "$0": "keyword3",
    "$1": "keyword3",
    "$2": "keyword3",
    "$3": "keyword3",
    "$4": "keyword3",
    "$5": "keyword3",
    "$6": "keyword3",
    "$7": "keyword3",
    "$8": "keyword3",
    "$9": "keyword3",
    "$\\n": "literal3",
    "$\\r": "literal3",
    "$cmdline": "keyword3",
    "$desktop": "literal3",
    "$exedir": "literal3",
    "$hwndparent": "literal3",
    "$instdir": "keyword3",
    "$language": "keyword3",
    "$outdir": "keyword3",
    "$pluginsdir": "literal3",
    "$programfiles": "literal3",
    "$quicklaunch": "literal3",
    "$r0": "keyword3",
    "$r1": "keyword3",
    "$r2": "keyword3",
    "$r3": "keyword3",
    "$r4": "keyword3",
    "$r5": "keyword3",
    "$r6": "keyword3",
    "$r7": "keyword3",
    "$r8": "keyword3",
    "$r9": "keyword3",
    "$smprograms": "literal3",
    "$smstartup": "literal3",
    "$startmenu": "literal3",
    "$sysdir": "literal3",
    "$temp": "literal3",
    "$windir": "literal3",
    "${nsisdir}": "literal3",
    ".onguiinit": "keyword3",
    ".oninit": "keyword3",
    ".oninstfailed": "keyword3",
    ".oninstsuccess": "keyword3",
    ".onmouseoversection": "keyword3",
    ".onselchange": "keyword3",
    ".onuserabort": "keyword3",
    ".onverifyinstdir": "keyword3",
    "/0": "keyword4",
    "/a": "keyword4",
    "/componentsonlyoncustom": "keyword4",
    "/customstring": "keyword4",
    "/e": "keyword4",
    "/filesonly": "keyword4",
    "/ifempty": "keyword4",
    "/imgid": "keyword4",
    "/italic": "keyword4",
    "/lang": "keyword4",
    "/nocustom": "keyword4",
    "/nonfatal": "keyword4",
    "/nounload": "keyword4",
    "/oname": "keyword4",
    "/r": "keyword4",
    "/rebootok": "keyword4",
    "/resizetofit": "keyword4",
    "/rtl": "keyword4",
    "/short": "keyword4",
    "/silent": "keyword4",
    "/strike": "keyword4",
    "/timeout": "keyword4",
    "/trim": "keyword4",
    "/underline": "keyword4",
    "/windows": "keyword4",
    "a": "literal3",
    "abort": "keyword1",
    "addbrandingimage": "keyword2",
    "addsize": "keyword2",
    "all": "literal3",
    "allowrootdirinstall": "keyword2",
    "allowskipfiles": "keyword2",
    "alt": "literal3",
    "alwaysoff": "literal3",
    "archive": "literal3",
    "auto": "literal3",
    "autoclosewindow": "keyword2",
    "bggradient": "keyword2",
    "both": "literal3",
    "bottom": "literal3",
    "brandingtext": "keyword2",
    "bringtofront": "keyword2",
    "bzip2": "literal3",
    "call": "keyword1",
    "callinstdll": "keyword2",
    "caption": "keyword2",
    "center": "literal3",
    "changeui": "keyword2",
    "checkbitmap": "keyword2",
    "checkbox": "literal3",
    "clearerrors": "keyword1",
    "colored": "literal3",
    "completedtext": "keyword2",
    "components": "literal3",
    "componenttext": "keyword2",
    "control": "literal3",
    "copyfiles": "keyword2",
    "crccheck": "keyword2",
    "createdirectory": "keyword2",
    "createfont": "keyword2",
    "createshortcut": "keyword2",
    "cur": "literal3",
    "current": "literal3",
    "custom": "literal3",
    "delete": "keyword2",
    "deleteinisec": "keyword2",
    "deleteinistr": "keyword2",
    "deleteregkey": "keyword2",
    "deleteregvalue": "keyword2",
    "detailprint": "keyword2",
    "detailsbuttontext": "keyword2",
    "dim": "invalid",
    "directory": "literal3",
    "dirshow": "keyword2",
    "dirtext": "keyword2",
    "end": "literal3",
    "enumregkey": "keyword2",
    "enumregvalue": "keyword2",
    "exch": "keyword2",
    "exec": "keyword2",
    "execshell": "keyword2",
    "execwait": "keyword2",
    "expandenvstrings": "keyword2",
    "ext": "literal3",
    "f1": "literal3",
    "f10": "literal3",
    "f11": "literal3",
    "f12": "literal3",
    "f13": "literal3",
    "f14": "literal3",
    "f15": "literal3",
    "f16": "literal3",
    "f17": "literal3",
    "f18": "literal3",
    "f19": "literal3",
    "f2": "literal3",
    "f20": "literal3",
    "f21": "literal3",
    "f22": "literal3",
    "f23": "literal3",
    "f24": "literal3",
    "f3": "literal3",
    "f4": "literal3",
    "f5": "literal3",
    "f6": "literal3",
    "f7": "literal3",
    "f8": "literal3",
    "f9": "literal3",
    "false": "literal3",
    "file": "keyword2",
    "file_attribute_archive": "literal3",
    "file_attribute_hidden": "literal3",
    "file_attribute_normal": "literal3",
    "file_attribute_offline": "literal3",
    "file_attribute_readonly": "literal3",
    "file_attribute_system": "literal3",
    "file_attribute_temporary": "literal3",
    "fileclose": "keyword2",
    "fileerrortext": "keyword2",
    "fileopen": "keyword2",
    "fileread": "keyword2",
    "filereadbyte": "keyword2",
    "fileseek": "keyword2",
    "filewrite": "keyword2",
    "filewritebyte": "keyword2",
    "findclose": "keyword2",
    "findfirst": "keyword2",
    "findnext": "keyword2",
    "findwindow": "keyword2",
    "flushini": "keyword2",
    "force": "literal3",
    "function": "keyword1",
    "functionend": "keyword1",
    "getcurinsttype": "keyword2",
    "getcurrentaddress": "keyword2",
    "getdlgitem": "keyword2",
    "getdllversion": "keyword2",
    "getdllversionlocal": "keyword2",
    "getfiletime": "keyword2",
    "getfiletimelocal": "keyword2",
    "getfullpathname": "keyword2",
    "getfunctionaddress": "keyword2",
    "getlabeladdress": "keyword2",
    "gettempfilename": "keyword2",
    "getwindowtext": "keyword2",
    "goto": "keyword1",
    "hidden": "literal3",
    "hide": "literal3",
    "hidewindow": "keyword2",
    "hkcc": "literal3",
    "hkcr": "literal3",
    "hkcu": "literal3",
    "hkdd": "literal3",
    "hklm": "literal3",
    "hkpd": "literal3",
    "hku": "literal3",
    "icon": "keyword2",
    "idabort": "literal3",
    "idcancel": "literal3",
    "idignore": "literal3",
    "idno": "literal3",
    "idok": "literal3",
    "idretry": "literal3",
    "idyes": "literal3",
    "ifabort": "keyword1",
    "iferrors": "keyword1",
    "iffileexists": "keyword1",
    "ifnewer": "literal3",
    "ifrebootflag": "keyword1",
    "initpluginsdir": "keyword2",
    "installbuttontext": "keyword2",
    "installcolors": "keyword2",
    "installdir": "keyword2",
    "installdirregkey": "keyword2",
    "instfiles": "literal3",
    "instprogressflags": "keyword2",
    "insttype": "keyword2",
    "insttypegettext": "keyword2",
    "insttypesettext": "keyword2",
    "intcmp": "keyword1",
    "intcmpu": "keyword1",
    "intfmt": "keyword2",
    "intop": "keyword2",
    "iswindow": "keyword1",
    "langstring": "keyword2",
    "langstringup": "keyword2",
    "left": "literal3",
    "license": "literal3",
    "licensebkcolor": "keyword2",
    "licensedata": "keyword2",
    "licenseforceselection": "keyword2",
    "licensetext": "keyword2",
    "listonly": "literal3",
    "loadlanguagefile": "keyword2",
    "logset": "keyword2",
    "logtext": "keyword2",
    "manual": "literal3",
    "mb_abortretryignore": "literal3",
    "mb_defbutton1": "literal3",
    "mb_defbutton2": "literal3",
    "mb_defbutton3": "literal3",
    "mb_defbutton4": "literal3",
    "mb_iconexclamation": "literal3",
    "mb_iconinformation": "literal3",
    "mb_iconquestion": "literal3",
    "mb_iconstop": "literal3",
    "mb_ok": "literal3",
    "mb_okcancel": "literal3",
    "mb_retrycancel": "literal3",
    "mb_right": "literal3",
    "mb_setforeground": "literal3",
    "mb_topmost": "literal3",
    "mb_yesno": "literal3",
    "mb_yesnocancel": "literal3",
    "messagebox": "keyword1",
    "miscbuttontext": "keyword2",
    "name": "keyword2",
    "nevershow": "literal3",
    "none": "literal3",
    "nop": "keyword2",
    "normal": "literal3",
    "off": "literal3",
    "offline": "literal3",
    "on": "literal3",
    "outfile": "keyword2",
    "page": "keyword2",
    "plugindir": "keyword2",
    "pop": "keyword2",
    "push": "keyword2",
    "quit": "keyword1",
    "r": "literal3",
    "radiobuttons": "literal3",
    "readenvstr": "keyword2",
    "readinistr": "keyword2",
    "readonly": "literal3",
    "readregdword": "keyword2",
    "readregstr": "keyword2",
    "reboot": "keyword1",
    "regdll": "keyword2",
    "rename": "keyword2",
    "reservefile": "keyword2",
    "return": "keyword1",
    "right": "literal3",
    "rmdir": "keyword2",
    "ro": "literal3",
    "searchpath": "keyword2",
    "section": "keyword1",
    "sectionend": "keyword1",
    "sectiongetflags": "keyword2",
    "sectiongetinsttypes": "keyword2",
    "sectiongetsize": "keyword2",
    "sectiongettext": "keyword2",
    "sectionin": "keyword2",
    "sectionsetflags": "keyword2",
    "sectionsetinsttypes": "keyword2",
    "sectionsetsize": "keyword2",
    "sectionsettext": "keyword2",
    "sendmessage": "keyword2",
    "set": "literal3",
    "setautoclose": "keyword2",
    "setbkcolor": "keyword2",
    "setbrandingimage": "keyword2",
    "setcompress": "keyword2",
    "setcompressor": "keyword2",
    "setcurinsttype": "keyword2",
    "setdatablockoptimize": "keyword2",
    "setdatesave": "keyword2",
    "setdetailsprint": "keyword2",
    "setdetailsview": "keyword2",
    "seterrors": "keyword1",
    "setfileattributes": "keyword2",
    "setfont": "keyword2",
    "setoutpath": "keyword2",
    "setoverwrite": "keyword2",
    "setpluginunload": "keyword2",
    "setrebootflag": "keyword2",
    "setshellvarcontext": "keyword2",
    "setstaticbkcolor": "keyword2",
    "setwindowlong": "keyword2",
    "shift": "literal3",
    "show": "literal3",
    "showinstdetails": "keyword2",
    "showuninstdetails": "keyword2",
    "showwindow": "keyword2",
    "silent": "literal3",
    "silentinstall": "keyword2",
    "silentlog": "literal3",
    "silentuninstall": "keyword2",
    "sleep": "keyword2",
    "smooth": "literal3",
    "spacetexts": "keyword2",
    "strcmp": "keyword1",
    "strcpy": "keyword2",
    "strlen": "keyword2",
    "subcaption": "keyword2",
    "subsection": "keyword1",
    "subsectionend": "keyword1",
    "sw_showmaximized": "literal3",
    "sw_showminimized": "literal3",
    "sw_shownormal": "literal3",
    "system": "literal3",
    "temporary": "literal3",
    "textonly": "literal3",
    "top": "literal3",
    "true": "literal3",
    "try": "literal3",
    "un.onguiinit": "keyword3",
    "un.oninit": "keyword3",
    "un.onuninstfailed": "keyword3",
    "un.onuninstsuccess": "keyword3",
    "un.onuserabort": "keyword3",
    "uninstallbuttontext": "keyword2",
    "uninstallcaption": "keyword2",
    "uninstallexename": "invalid",
    "uninstallicon": "keyword2",
    "uninstallsubcaption": "keyword2",
    "uninstalltext": "keyword2",
    "uninstconfirm": "literal3",
    "uninstpage": "keyword2",
    "unregdll": "keyword2",
    "var": "keyword2",
    "viaddversionkey": "keyword2",
    "vicomments": "keyword2",
    "vicompanyname": "keyword2",
    "videscription": "keyword2",
    "vilegalcopyrights": "keyword2",
    "vilegaltrademarks": "keyword2",
    "viproductname": "keyword2",
    "viproductversion": "keyword2",
    "w": "literal3",
    "windowicon": "keyword2",
    "writeinistr": "keyword2",
    "writeregbin": "keyword2",
    "writeregdword": "keyword2",
    "writeregexpandstr": "keyword2",
    "writeregstr": "keyword2",
    "writeuninstaller": "keyword2",
    "xpstyle": "keyword2",
    "zlib": "literal3",
}

# Keywords dict for nsis2_nsis_literal ruleset.
nsis2_nsis_literal_keywords_dict = {}

# Dictionary of keywords dictionaries for nsis2 mode.
keywordsDictDict = {
    "nsis2_main": nsis2_main_keywords_dict,
    "nsis2_nsis_literal": nsis2_nsis_literal_keywords_dict,
}

# Rules for nsis2_main ruleset.


def nsis2_rule0(colorer, s, i):
    return colorer.match_eol_span(s, i, kind="comment1", seq=";")


def nsis2_rule1(colorer, s, i):
    return colorer.match_eol_span(s, i, kind="comment2", seq="#")


def nsis2_rule2(colorer, s, i):
    return colorer.match_mark_following(s, i, kind="keyword3", pattern="$")


def nsis2_rule3(colorer, s, i):
    return colorer.match_mark_previous(s, i, kind="function", pattern="::", exclude_match=True)


def nsis2_rule4(colorer, s, i):
    return colorer.match_mark_previous(s, i, kind="label", pattern=":", exclude_match=True)


def nsis2_rule5(colorer, s, i):
    return colorer.match_span(
        s, i, kind="literal1", begin="\"", end="\"", delegate="nsis2::nsis_literal"
    )


def nsis2_rule6(colorer, s, i):
    return colorer.match_span(
        s, i, kind="literal1", begin="'", end="'", delegate="nsis2::nsis_literal"
    )


def nsis2_rule7(colorer, s, i):
    return colorer.match_span(
        s, i, kind="literal1", begin="`", end="`", delegate="nsis2::nsis_literal"
    )


def nsis2_rule8(colorer, s, i):
    return colorer.match_keywords(s, i)


# Rules dict for nsis2_main ruleset.
rulesDict1 = {
    "!": [
        nsis2_rule8,
    ],
    "\"": [
        nsis2_rule5,
    ],
    "#": [
        nsis2_rule1,
    ],
    "$": [
        nsis2_rule2,
        nsis2_rule8,
    ],
    "'": [
        nsis2_rule6,
    ],
    ".": [
        nsis2_rule8,
    ],
    "/": [
        nsis2_rule8,
    ],
    "0": [
        nsis2_rule8,
    ],
    "1": [
        nsis2_rule8,
    ],
    "2": [
        nsis2_rule8,
    ],
    "3": [
        nsis2_rule8,
    ],
    "4": [
        nsis2_rule8,
    ],
    "5": [
        nsis2_rule8,
    ],
    "6": [
        nsis2_rule8,
    ],
    "7": [
        nsis2_rule8,
    ],
    "8": [
        nsis2_rule8,
    ],
    "9": [
        nsis2_rule8,
    ],
    ":": [
        nsis2_rule3,
        nsis2_rule4,
    ],
    ";": [
        nsis2_rule0,
    ],
    "@": [
        nsis2_rule8,
    ],
    "A": [
        nsis2_rule8,
    ],
    "B": [
        nsis2_rule8,
    ],
    "C": [
        nsis2_rule8,
    ],
    "D": [
        nsis2_rule8,
    ],
    "E": [
        nsis2_rule8,
    ],
    "F": [
        nsis2_rule8,
    ],
    "G": [
        nsis2_rule8,
    ],
    "H": [
        nsis2_rule8,
    ],
    "I": [
        nsis2_rule8,
    ],
    "J": [
        nsis2_rule8,
    ],
    "K": [
        nsis2_rule8,
    ],
    "L": [
        nsis2_rule8,
    ],
    "M": [
        nsis2_rule8,
    ],
    "N": [
        nsis2_rule8,
    ],
    "O": [
        nsis2_rule8,
    ],
    "P": [
        nsis2_rule8,
    ],
    "Q": [
        nsis2_rule8,
    ],
    "R": [
        nsis2_rule8,
    ],
    "S": [
        nsis2_rule8,
    ],
    "T": [
        nsis2_rule8,
    ],
    "U": [
        nsis2_rule8,
    ],
    "V": [
        nsis2_rule8,
    ],
    "W": [
        nsis2_rule8,
    ],
    "X": [
        nsis2_rule8,
    ],
    "Y": [
        nsis2_rule8,
    ],
    "Z": [
        nsis2_rule8,
    ],
    "\\": [
        nsis2_rule8,
    ],
    "_": [
        nsis2_rule8,
    ],
    "`": [
        nsis2_rule7,
    ],
    "a": [
        nsis2_rule8,
    ],
    "b": [
        nsis2_rule8,
    ],
    "c": [
        nsis2_rule8,
    ],
    "d": [
        nsis2_rule8,
    ],
    "e": [
        nsis2_rule8,
    ],
    "f": [
        nsis2_rule8,
    ],
    "g": [
        nsis2_rule8,
    ],
    "h": [
        nsis2_rule8,
    ],
    "i": [
        nsis2_rule8,
    ],
    "j": [
        nsis2_rule8,
    ],
    "k": [
        nsis2_rule8,
    ],
    "l": [
        nsis2_rule8,
    ],
    "m": [
        nsis2_rule8,
    ],
    "n": [
        nsis2_rule8,
    ],
    "o": [
        nsis2_rule8,
    ],
    "p": [
        nsis2_rule8,
    ],
    "q": [
        nsis2_rule8,
    ],
    "r": [
        nsis2_rule8,
    ],
    "s": [
        nsis2_rule8,
    ],
    "t": [
        nsis2_rule8,
    ],
    "u": [
        nsis2_rule8,
    ],
    "v": [
        nsis2_rule8,
    ],
    "w": [
        nsis2_rule8,
    ],
    "x": [
        nsis2_rule8,
    ],
    "y": [
        nsis2_rule8,
    ],
    "z": [
        nsis2_rule8,
    ],
    "{": [
        nsis2_rule8,
    ],
    "}": [
        nsis2_rule8,
    ],
}

# Rules for nsis2_nsis_literal ruleset.


def nsis2_rule9(colorer, s, i):
    return colorer.match_mark_following(s, i, kind="keyword3", pattern="$")


# Rules dict for nsis2_nsis_literal ruleset.
rulesDict2 = {
    "$": [
        nsis2_rule9,
    ],
}

# x.rulesDictDict for nsis2 mode.
rulesDictDict = {
    "nsis2_main": rulesDict1,
    "nsis2_nsis_literal": rulesDict2,
}

# Import dict for nsis2 mode.
importDict = {}
