/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.ctxmenu;

import com.paterva.maltego.util.ui.ctxmenu.ContextActionButton;
import com.paterva.maltego.util.ui.treelist.PositionActionComparator;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;

public class ContextActionsPanel
extends JPanel {
    private static final int VGAP = 2;
    private static final int MIN_WIDTH = 180;
    private final List<ContextActionButton> _buttons = new ArrayList<ContextActionButton>();
    private static final OtherButtonsAction _otherButtonsAction = new OtherButtonsAction();
    private final int _actionCount;

    ContextActionsPanel(Action[] actions) {
        this.setOpaque(false);
        actions = this.removeNull(actions);
        this._actionCount = actions.length;
        Arrays.sort(actions, new PositionActionComparator());
        for (Action action : actions) {
            ContextActionButton button = new ContextActionButton(action);
            this._buttons.add(button);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        _otherButtonsAction.setOtherButtons(Collections.EMPTY_LIST);
    }

    @Override
    public Dimension getPreferredSize() {
        int minWidth = (ContextActionButton.BUTTON_WIDTH + 2) * this._actionCount + 2;
        return new Dimension(minWidth, ContextActionButton.BUTTON_HEIGHT);
    }

    @Override
    public void doLayout() {
        int actionCount = (this.getWidth() - 2) / (ContextActionButton.BUTTON_WIDTH + 2);
        this.removeAll();
        int count = 0;
        int x = 0;
        ArrayList<ContextActionButton> otherButtons = new ArrayList<ContextActionButton>();
        for (ContextActionButton button : this._buttons) {
            if (count >= actionCount) {
                otherButtons.add(button);
                continue;
            }
            this.add(button);
            button.setLocation(x, 0);
            button.setSize(ContextActionButton.BUTTON_WIDTH, ContextActionButton.BUTTON_HEIGHT);
            ++count;
            x += ContextActionButton.BUTTON_WIDTH + 2;
        }
        if (!otherButtons.isEmpty()) {
            _otherButtonsAction.setOtherButtons(otherButtons);
            ContextActionButton button = new ContextActionButton((Action)((Object)_otherButtonsAction));
            this.add(button);
            button.setLocation(x, 0);
            button.setSize(ContextActionButton.BUTTON_WIDTH, ContextActionButton.BUTTON_HEIGHT);
        }
    }

    private Action[] removeNull(Action[] actions) {
        ArrayList<Action> list = new ArrayList<Action>();
        for (Action action : actions) {
            if (action == null || ContextActionsPanel.isTransformOrMachineAction(action)) continue;
            list.add(action);
        }
        return list.toArray(new Action[list.size()]);
    }

    private static boolean isTransformOrMachineAction(Action action) {
        String simpleName = action.getClass().getSimpleName();
        return "TransformsAction".equals(simpleName) || "RunOnEntityAction".equals(simpleName);
    }

    static class OtherButtonsAction
    extends NodeAction {
        private List<ContextActionButton> _otherButtons;

        OtherButtonsAction() {
        }

        public void setOtherButtons(List<ContextActionButton> otherButtons) {
            this._otherButtons = otherButtons;
        }

        public JMenuItem getPopupPresenter() {
            JMenu menu = new JMenu();
            for (ContextActionButton button : this._otherButtons) {
                Presenter.Popup popupAction;
                JMenuItem menuItem;
                boolean added = false;
                Action action = button.getAction();
                if (action instanceof Presenter.Popup && (menuItem = (popupAction = (Presenter.Popup)action).getPopupPresenter()) instanceof JMenu) {
                    JMenu innerMenu = (JMenu)menuItem;
                    innerMenu.setIcon(button.getIcon());
                    innerMenu.setText(button.getName());
                    menu.add(innerMenu);
                    added = true;
                }
                if (added) continue;
                JMenuItem menuItem2 = new JMenuItem(action);
                menuItem2.setIcon(button.getIcon());
                menuItem2.setText(button.getName());
                menu.add(menuItem2);
            }
            return menu;
        }

        protected String iconResource() {
            return "com/paterva/maltego/util/ui/ctxmenu/OtherActions.png";
        }

        protected void performAction(Node[] activatedNodes) {
        }

        protected boolean enable(Node[] activatedNodes) {
            return true;
        }

        public String getName() {
            return "More Actions";
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
    }
}

