/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.treelist;

import com.paterva.maltego.util.ui.treelist.TreeListItem;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

class PersistedExpandStates {
    private static final String PREF_PREFIX = "tle";
    private static PersistedExpandStates _instance;

    private PersistedExpandStates() {
    }

    public static synchronized PersistedExpandStates getInstance() {
        if (_instance == null) {
            _instance = new PersistedExpandStates();
        }
        return _instance;
    }

    public boolean isExpanded(TreeListItem item) {
        String property = this.getPropertyName(item);
        return this.getPrefs().getBoolean(property, item.isExpandedByDefault());
    }

    public void setExpanded(TreeListItem item, boolean expanded) {
        String property = this.getPropertyName(item);
        this.getPrefs().putBoolean(property, expanded);
    }

    private String getPropertyName(TreeListItem item) {
        StringBuilder sb = new StringBuilder(PREF_PREFIX);
        for (TreeListItem parent = item; parent != null; parent = parent.getParent()) {
            sb.append(".");
            sb.append(parent.getName().replaceAll("[^\\w]", "_"));
        }
        return sb.toString();
    }

    private Preferences getPrefs() {
        return NbPreferences.forModule(PersistedExpandStates.class);
    }
}

