/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.serializers.compact.stubs;

import com.google.gson.annotations.SerializedName;
import com.paterva.maltego.serializers.compact.stubs.NoteStub;
import com.paterva.maltego.serializers.compact.stubs.PartStub;
import com.paterva.maltego.serializers.compact.stubs.PositionStub;
import com.paterva.maltego.serializers.util.ListUtil;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="entity", strict=false)
public class EntityStub
extends PartStub {
    @ElementList(inline=true, type=PositionStub.class, required=false)
    @SerializedName(value="positions")
    private List<PositionStub> _centers;
    @Attribute(name="bm", required=false)
    @SerializedName(value="bm")
    private String _bookmark;
    @Attribute(name="w8", required=false)
    @SerializedName(value="w8")
    private String _weight;
    @Element(name="note", required=false)
    @SerializedName(value="note")
    private NoteStub _note;
    @Attribute(name="img", required=false)
    @SerializedName(value="img")
    private String _imageExpression;
    @Attribute(name="pinned", required=false)
    @SerializedName(value="pinned")
    private Boolean _pinned;

    public void addCenter(PositionStub stub) {
        this._centers = ListUtil.add(this._centers, stub);
    }

    public List<PositionStub> getCenters() {
        return ListUtil.get(this._centers);
    }

    public Integer getWeight() {
        if (this._weight == null) {
            return null;
        }
        return Integer.parseInt(this._weight);
    }

    public void setWeight(Integer weight) {
        this._weight = weight == null ? null : weight.toString();
    }

    public Integer getBookmark() {
        if (this._bookmark == null) {
            return null;
        }
        return Integer.parseInt(this._bookmark);
    }

    public void setBookmark(Integer bookmark) {
        this._bookmark = bookmark == null ? null : bookmark.toString();
    }

    public void setNote(String text, Boolean visible) {
        if (visible != null || text != null) {
            this._note = new NoteStub();
            this._note.setText(text);
            this._note.setVisible(visible == null ? null : visible.toString());
        } else {
            this._note = null;
        }
    }

    public boolean isNoteVisibleSet() {
        return this._note != null && this._note.getVisible() != null;
    }

    public Boolean getNoteVisible() {
        if (this.isNoteVisibleSet()) {
            return Boolean.parseBoolean(this._note.getVisible());
        }
        return null;
    }

    public String getNoteText() {
        if (this._note != null) {
            String text = this._note.getText();
            if (text == null) {
                return "";
            }
            return text;
        }
        return null;
    }

    public void setImageExpression(String imgExpr) {
        this._imageExpression = imgExpr;
    }

    public String getImageExpression() {
        return this._imageExpression;
    }

    public Boolean isPinned() {
        return this._pinned;
    }

    public void setPinned(Boolean pinned) {
        this._pinned = pinned;
    }

    @Override
    public boolean isDataEmpty() {
        return super.isDataEmpty() && this._bookmark == null && this._imageExpression == null && this._note == null && this._weight == null;
    }
}

