/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.transform.descriptor.InheritedTypesProvider;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformFilter;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.runner.RegistryInheritedTypesProvider;
import com.paterva.maltego.ui.graph.util.GraphUtils;
import java.util.Iterator;
import java.util.Set;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public abstract class TransformSelector {
    public static TransformSelector getDefault() {
        TransformSelector selector = (TransformSelector)Lookup.getDefault().lookup(TransformSelector.class);
        if (selector == null) {
            selector = new DefaultTransformSelector();
        }
        return selector;
    }

    public abstract Set<TransformDefinition> getTransforms(GraphID var1, Set<EntityID> var2);

    public abstract Set<TransformDefinition> getCandidateTransforms(GraphID var1, Set<EntityID> var2, InheritedTypesProvider var3);

    public abstract Set<TransformDefinition> getAlwaysOnTransforms();

    private static class AlwaysOnConstraintFilter
    implements TransformFilter {
        private AlwaysOnConstraintFilter() {
        }

        public boolean matches(TransformDefinition def) {
            return def.isEnabled() && def.getInputConstraint() == null;
        }
    }

    private static class EntityConstraintFilter
    implements TransformFilter {
        private final GraphID _graphID;
        private final Set<EntityID> _entities;
        private final InheritedTypesProvider _typeProvider;
        private Set<String> _entityTypes;

        private EntityConstraintFilter(GraphID graphID, Set<EntityID> entities, InheritedTypesProvider typeProvider) {
            this._graphID = graphID;
            this._entities = entities;
            this._typeProvider = typeProvider;
            try {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
                GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
                this._entityTypes = dataReader.getEntityTypesOnly(entities);
                EntityRegistry registry = EntityRegistry.forGraphID((GraphID)this._graphID);
                if (registry == null) {
                    registry = EntityRegistry.getDefault();
                }
                this._entityTypes = GraphUtils.getAllTypeNames(this._entityTypes, (EntityRegistry)registry, (boolean)true);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public boolean matches(TransformDefinition def) {
            if (def.isEnabled() && def.getInputConstraint() != null) {
                return def.getInputConstraint().isSatisfiedByAny(this._graphID, this._entities, this._typeProvider);
            }
            return false;
        }
    }

    private static class EntityIterator
    implements Iterable<TypedPropertyBag>,
    Iterator<TypedPropertyBag> {
        private final Node[] _nodes;
        private int _index = 0;

        public EntityIterator(Node[] nodes) {
            this._nodes = nodes;
        }

        @Override
        public Iterator<TypedPropertyBag> iterator() {
            return new EntityIterator(this._nodes);
        }

        @Override
        public boolean hasNext() {
            return this._index < this._nodes.length;
        }

        @Override
        public TypedPropertyBag next() {
            return (TypedPropertyBag)this._nodes[this._index++].getLookup().lookup(TypedPropertyBag.class);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private static class DefaultTransformSelector
    extends TransformSelector {
        private DefaultTransformSelector() {
        }

        @Override
        public Set<TransformDefinition> getTransforms(GraphID graphID, Set<EntityID> entities) {
            InheritedTypesProvider typeProvider = this.getInheritedTypesProvider(graphID, entities);
            Set<TransformDefinition> transforms = TransformSelector.getDefault().getCandidateTransforms(graphID, entities, typeProvider);
            return transforms;
        }

        private InheritedTypesProvider getInheritedTypesProvider(GraphID graphID, Set<EntityID> entities) {
            EntityRegistry registry = EntityRegistry.forGraphID((GraphID)graphID);
            if (registry == null) {
                registry = EntityRegistry.getDefault();
            }
            return new RegistryInheritedTypesProvider(graphID, registry, entities);
        }

        @Override
        public Set<TransformDefinition> getCandidateTransforms(GraphID graphID, Set<EntityID> entities, InheritedTypesProvider typeProvider) {
            return DefaultTransformSelector.filterByTas(TransformRepositoryRegistry.getDefault().find((TransformFilter)new EntityConstraintFilter(graphID, entities, typeProvider)));
        }

        @Override
        public Set<TransformDefinition> getAlwaysOnTransforms() {
            return DefaultTransformSelector.filterByTas(TransformRepositoryRegistry.getDefault().find((TransformFilter)new AlwaysOnConstraintFilter()));
        }

        private static Set<TransformDefinition> filterByTas(Set<TransformDefinition> set) {
            boolean filteringNoLongerNeeded = true;
            if (filteringNoLongerNeeded) {
                return set;
            }
            TransformServerRegistry servers = TransformServerRegistry.getDefault();
            Iterator<TransformDefinition> it = set.iterator();
            while (it.hasNext()) {
                TransformDefinition def = it.next();
                if (servers.exists(def.getName(), true)) continue;
                it.remove();
            }
            return set;
        }
    }
}

