/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.BadMessageException;
import org.xlightweb.ComposedByteBuffer;
import org.xlightweb.HeaderlineParser;
import org.xlightweb.HttpResponseHeader;
import org.xlightweb.IHttpHeader;
import org.xlightweb.IMessageHeaderParser;
import org.xlightweb.SimpleResponseMessageException;
import org.xsocket.connection.INonBlockingConnection;

final class HttpResponseHeaderParser
implements IMessageHeaderParser {
    private static final Logger LOG = Logger.getLogger(HttpResponseHeaderParser.class.getName());
    private static ThreadLocal<HttpResponseHeaderParser> instanceThreadLocal = new ThreadLocal();
    private static final int MAX_HEADER_SIZE = 8192;
    private static final int STATE_INIT = 0;
    private static final int STATE_READING_REQUEST_LINE = 5;
    private static final int STATE_READING_HEADER_LINES = 9;
    private int state = 0;
    private HttpResponseHeader responseHeader = null;
    private ResponseLineParser responseLineParser;
    private HeaderlineParser headerlineParser;

    HttpResponseHeaderParser() {
    }

    static HttpResponseHeaderParser newInstance() {
        HttpResponseHeaderParser instance = instanceThreadLocal.get();
        if (instance == null) {
            instance = new HttpResponseHeaderParser();
        }
        instanceThreadLocal.set(null);
        return instance;
    }

    static void recycleInstance(HttpResponseHeaderParser parser) {
        instanceThreadLocal.set(parser);
    }

    public void recycle() {
        HttpResponseHeaderParser.recycleInstance(this);
    }

    public IHttpHeader parse(INonBlockingConnection connection, ComposedByteBuffer composedByteBuffer) throws SimpleResponseMessageException, BadMessageException, IOException {
        int size = 0;
        switch (this.state) {
            case 0: {
                this.responseHeader = new HttpResponseHeader();
                this.responseLineParser = ResponseLineParser.newInstance();
                this.state = 5;
                return this.parse(connection, composedByteBuffer);
            }
            case 5: {
                size = this.computeSizeToRead(composedByteBuffer);
                for (int i = 0; i < size; ++i) {
                    boolean isRead = this.responseLineParser.parse(connection, composedByteBuffer, this.responseHeader);
                    if (!isRead) continue;
                    this.responseLineParser.recycle();
                    this.responseLineParser = null;
                    this.headerlineParser = HeaderlineParser.newInstance();
                    this.state = 9;
                    return this.parse(connection, composedByteBuffer);
                }
                break;
            }
            case 9: {
                size = this.computeSizeToRead(composedByteBuffer);
                for (int i = 0; i < size; ++i) {
                    boolean isRead = this.headerlineParser.parse(composedByteBuffer, this.responseHeader);
                    if (!isRead) continue;
                    this.headerlineParser.recycle();
                    this.headerlineParser = null;
                    HttpResponseHeader result = this.responseHeader;
                    this.responseHeader = null;
                    this.state = 0;
                    return result;
                }
                break;
            }
        }
        if (this.responseHeader.incCountParsedChars(size) >= 8192) {
            throw new BadMessageException("max header size exceeded");
        }
        return null;
    }

    private int computeSizeToRead(ComposedByteBuffer composedByteBuffer) {
        int remaining;
        int size = remaining = composedByteBuffer.remaining();
        if (remaining > 8192 - this.responseHeader.getCountParsedChars()) {
            size = 8192 - this.responseHeader.getCountParsedChars();
        }
        return size;
    }

    public void onException(IOException ioe, ComposedByteBuffer rawData) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("error occured by receiving header. Reason: " + ioe.toString());
            StringBuilder sb = new StringBuilder();
            if (this.responseHeader != null) {
                sb.append(this.responseHeader.toString());
            }
            LOG.info("received header lines: " + sb.toString());
        }
    }

    private static final class ResponseLineParser {
        private static ThreadLocal<ResponseLineParser> instanceThreadLocal = new ThreadLocal();
        private int state = 0;
        private final StringBuilder protocolSchemeBuilder = new StringBuilder(4);
        private final StringBuilder protocolVersionBuilder = new StringBuilder(3);
        private final StringBuilder statusBuilder = new StringBuilder(3);
        private final StringBuilder reasonBuilder = new StringBuilder(8);

        private ResponseLineParser() {
        }

        static ResponseLineParser newInstance() {
            ResponseLineParser instance = instanceThreadLocal.get();
            if (instance == null) {
                instance = new ResponseLineParser();
            }
            instanceThreadLocal.set(null);
            return instance;
        }

        static void recycleInstance(ResponseLineParser parser) {
            instanceThreadLocal.set(parser);
        }

        public boolean parse(INonBlockingConnection connection, ComposedByteBuffer composedByteBuffer, HttpResponseHeader messageHeader) throws SimpleResponseMessageException, BadMessageException, IOException {
            byte b = composedByteBuffer.getByte();
            block0 : switch (this.state) {
                case 0: {
                    switch (b) {
                        case 13: {
                            break block0;
                        }
                        case 10: {
                            break block0;
                        }
                        case 32: {
                            break block0;
                        }
                        case 9: {
                            break block0;
                        }
                        case 47: {
                            String protocolScheme = this.protocolSchemeBuilder.toString();
                            messageHeader.setProtocolSchemeSilence(protocolScheme);
                            this.state = 5;
                            break block0;
                        }
                    }
                    this.protocolSchemeBuilder.append((char)b);
                    if (this.protocolSchemeBuilder.length() <= 4) break;
                    composedByteBuffer.addFirst(this.protocolSchemeBuilder.toString().getBytes("ISO-8859-1"));
                    this.reset();
                    throw new SimpleResponseMessageException();
                }
                case 5: {
                    this.protocolVersionBuilder.append((char)b);
                    this.state = 10;
                    break;
                }
                case 10: {
                    switch (b) {
                        case 32: {
                            messageHeader.setProtocolVersionSilence(this.protocolVersionBuilder.toString());
                            this.state = 15;
                            break block0;
                        }
                        case 9: {
                            messageHeader.setProtocolVersionSilence(this.protocolVersionBuilder.toString());
                            this.state = 15;
                            break block0;
                        }
                        case 13: {
                            break block0;
                        }
                        case 10: {
                            throw new BadMessageException("bad request");
                        }
                    }
                    this.protocolVersionBuilder.append((char)b);
                    break;
                }
                case 15: {
                    switch (b) {
                        case 32: {
                            break block0;
                        }
                        case 9: {
                            break block0;
                        }
                    }
                    this.statusBuilder.append((char)b);
                    this.state = 20;
                    break;
                }
                case 20: {
                    switch (b) {
                        case 32: {
                            messageHeader.setStatus(Integer.parseInt(this.statusBuilder.toString()));
                            this.state = 30;
                            break block0;
                        }
                        case 9: {
                            messageHeader.setStatus(Integer.parseInt(this.statusBuilder.toString()));
                            this.state = 30;
                            break block0;
                        }
                        case 13: {
                            break block0;
                        }
                        case 10: {
                            messageHeader.setStatus(Integer.parseInt(this.statusBuilder.toString()));
                            this.reset();
                            return true;
                        }
                    }
                    this.statusBuilder.append((char)b);
                    break;
                }
                case 30: {
                    switch (b) {
                        case 32: {
                            break block0;
                        }
                        case 9: {
                            break block0;
                        }
                    }
                    this.reasonBuilder.append((char)b);
                    this.state = 35;
                    break;
                }
                case 35: {
                    switch (b) {
                        case 13: {
                            break block0;
                        }
                        case 10: {
                            messageHeader.setReason(this.reasonBuilder.toString());
                            this.reset();
                            return true;
                        }
                    }
                    this.reasonBuilder.append((char)b);
                    break;
                }
            }
            return false;
        }

        public void reset() {
            this.state = 0;
            this.protocolSchemeBuilder.setLength(0);
            this.protocolVersionBuilder.setLength(0);
            this.statusBuilder.setLength(0);
            this.reasonBuilder.setLength(0);
        }

        public void recycle() {
            ResponseLineParser.recycleInstance(this);
        }
    }
}

