/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws.oauth;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OAuthHttpUtils {
    public static final String HTML_REDIRECT_BASIC = "<html>\n<head>\n    <title>Redirecting...</title>\n    <script>\n    function redirLoad(){\n        document.getElementById(\"redirForm\").submit();\n    }\n    </script>\n</head>\n<body onload=\"redirLoad()\">\n    <form id=\"redirForm\" action=\"%s\"/>\n</body>\n</html>";
    public static final String HTML_REDIRECT_COMPLEX_START = "<html>\n<head>\n    <title>Redirecting...</title>\n    <script>\n    function redirLoad(){\n        document.getElementById(\"redirForm\").submit();\n    }\n    </script>\n</head>\n<body onload=\"redirLoad()\">\n    <form id=\"redirForm\" action=\"%s\" method=\"%s\">\n";
    public static final String HTML_REDIRECT_COMPLEX_ELEMENT = "        <input type=\"hidden\" name=\"%s\" value=\"%s\">\n";
    public static final String HTML_REDIRECT_COMPLEX_END = "    </form>\n</body>\n</html>";
    public static final String HTML_IMAGE_SUCCESS = "<html><body><img style=\"display: table;margin: 0 auto;padding-top: 50px\" src=\"%s\"/></body></html>";

    public static String buildHtmlRedirect(String authorizationUrl, String requestType) {
        StringBuilder response = new StringBuilder();
        int indexOf = authorizationUrl.indexOf("?");
        if (indexOf > 0) {
            Map<String, String> parameters = OAuthHttpUtils.getParameters(authorizationUrl);
            authorizationUrl = authorizationUrl.substring(0, indexOf);
            response.append(String.format(HTML_REDIRECT_COMPLEX_START, authorizationUrl, requestType));
            parameters.forEach((key, value) -> response.append(String.format(HTML_REDIRECT_COMPLEX_ELEMENT, key, value)));
            response.append(HTML_REDIRECT_COMPLEX_END);
        } else {
            response.append(String.format(HTML_REDIRECT_BASIC, authorizationUrl));
        }
        return response.toString();
    }

    public static Map<String, String> getParameters(String urlValue) {
        int indexOf = urlValue.indexOf("?");
        if (indexOf > 0) {
            urlValue = urlValue.substring(indexOf + 1);
        }
        return Stream.of(urlValue.split("&")).map(keyValue -> keyValue.split("=")).filter(tokens -> ((String[])tokens).length == 2).collect(Collectors.toMap(tokens -> tokens[0], tokens -> tokens[1], BinaryOperator.minBy(String::compareTo), LinkedHashMap::new));
    }
}

