/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.update.wizard;

import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import com.paterva.maltego.util.ui.dialog.ProgressComponent;
import com.paterva.maltego.util.ui.dialog.ProgressControl;
import com.paterva.maltego.util.ui.dialog.WizardNavigationSupport;
import com.paterva.maltego.welcome.update.UpdateUtils;
import com.paterva.maltego.welcome.update.wizard.InstallSuccessPanel;
import com.paterva.maltego.welcome.update.wizard.ProgressFailedPanel;
import com.paterva.maltego.welcome.update.wizard.UpdateWizardConstants;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class UpdateInstallController
extends PassFailProgressController<Object, InstallSuccessPanel, ProgressFailedPanel>
implements WizardNavigationSupport {
    private ProgressControl _progressControl;
    private InstallSupport _support;
    private OperationSupport.Restarter _restarter;

    public UpdateInstallController() {
        this.setName("Install updates");
        this.setDescription("A summary of the progress to update Maltego is shown below.");
    }

    protected ProgressComponent createProgressComponent() {
        this._progressControl = new ProgressControl();
        return this._progressControl;
    }

    protected InstallSuccessPanel createPassComponent() {
        return new InstallSuccessPanel();
    }

    protected ProgressFailedPanel createFailComponent() {
        return new ProgressFailedPanel();
    }

    protected void pass(WizardDescriptor descriptor, InstallSuccessPanel component, Object result) {
        descriptor.putProperty(UpdateWizardConstants.PROP_INSTALL_SUPPORT, (Object)this._support);
        descriptor.putProperty(UpdateWizardConstants.PROP_RESTARTER, (Object)this._restarter);
    }

    protected void fail(ProgressFailedPanel component, Exception e) {
        try {
            component.setHeader("An error occurred during installation!");
            component.setError(e.getMessage());
            if (this._support != null) {
                this._support.doCancel();
                this._support = null;
            }
            NormalException.logStackTrace((Throwable)e);
        }
        catch (OperationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected OperationSupport.Restarter doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws Exception {
        UpdateUtils.debugSleep();
        Collection updateElements = (Collection)descriptor.getProperty(UpdateWizardConstants.PROP_UPDATE_ELEMENTS);
        OperationContainer<InstallSupport> ops = this.getContainerForUpdate(updateElements);
        this._support = (InstallSupport)ops.getSupport();
        UpdateUtils.debugSleep();
        handle = ProgressHandleFactory.createHandle((String)"Downloading...");
        this._progressControl.setProgressComponent(UpdateInstallController.createProgressBar((ProgressHandle)handle, (boolean)false));
        InstallSupport.Validator validator = this._support.doDownload(handle, Boolean.valueOf(true), true);
        if (validator != null) {
            UpdateUtils.debugSleep();
            handle = ProgressHandleFactory.createHandle((String)"Validating...");
            this._progressControl.setProgressComponent(UpdateInstallController.createProgressBar((ProgressHandle)handle, (boolean)false));
            InstallSupport.Installer installer = this._support.doValidate(validator, handle);
            if (installer != null) {
                UpdateUtils.debugSleep();
                this.doCheckCertificate(updateElements, this._support);
                UpdateUtils.debugSleep();
                handle = ProgressHandleFactory.createHandle((String)"Installing...");
                this._progressControl.setProgressComponent(UpdateInstallController.createProgressBar((ProgressHandle)handle, (boolean)false));
                this._restarter = this._support.doInstall(installer, handle);
                UpdateUtils.debugSleep();
                return this._restarter;
            }
        }
        throw new OperationException(OperationException.ERROR_TYPE.INSTALL, "Updates were cancelled.");
    }

    public OperationContainer<InstallSupport> getContainerForUpdate(Collection<UpdateElement> updateElements) {
        OperationContainer container = OperationContainer.createForUpdate();
        for (UpdateElement element : updateElements) {
            OperationContainer.OperationInfo operationInfo;
            if (!container.canBeAdded(element.getUpdateUnit(), element) || (operationInfo = container.add(element)) == null) continue;
            container.add((Collection)operationInfo.getRequiredElements());
        }
        return container;
    }

    private void doCheckCertificate(Collection<UpdateElement> updateElements, InstallSupport support) throws Exception {
        Certificate maltegoCert = this.getMaltegoCertificate();
        for (UpdateElement updateElement : updateElements) {
            if (this.isTrusted(support, updateElement, maltegoCert)) continue;
            String msg = "The following update is not trusted: " + updateElement.getDisplayName();
            msg = msg + "\nNo updates will be installed";
            throw new OperationException(OperationException.ERROR_TYPE.INSTALLER, msg);
        }
    }

    private Certificate getMaltegoCertificate() throws Exception {
        FileObject fo = FileUtil.getConfigFile((String)"Maltego/AutoUpdateCertificates/distributionCert");
        InputStream is = fo.getInputStream();
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate maltegoCert = cf.generateCertificate(is);
        return maltegoCert;
    }

    private boolean isTrusted(InstallSupport support, UpdateElement updateElement, Certificate maltegoCert) {
        Collection certs = support.getCertificates(updateElement);
        if (certs == null) {
            return false;
        }
        for (Certificate cert : certs) {
            if (!cert.equals(maltegoCert)) continue;
            return true;
        }
        return false;
    }

    protected void storeSettings(WizardDescriptor settings) {
        super.storeSettings(settings);
        settings.putProperty(UpdateWizardConstants.PROP_RESTART_NOW, (Object)((InstallSuccessPanel)this.successComponent()).isRestartNow());
    }

    public boolean canBack() {
        return false;
    }

    protected String getFailureMessage() {
        return null;
    }
}

