/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformFilter;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.repository.FSTransformRepositoryRegistry;
import com.paterva.maltego.transform.repository.TransformSourceTransformRepository;
import java.io.IOException;
import java.util.Set;

public class DelegatingTransformRepositoryRegistry
extends TransformRepositoryRegistry {
    private final FSTransformRepositoryRegistry fsRegistry = new FSTransformRepositoryRegistry();
    private final TransformSourceTransformRepository txSourceRepository = new TransformSourceTransformRepository();

    public TransformDefinition findTransform(String uniqueName) {
        TransformDefinition transform = this.fsRegistry.findTransform(uniqueName);
        if (transform == null) {
            return this.txSourceRepository.get(uniqueName);
        }
        return transform;
    }

    public TransformRepository getRepository(String name) {
        return "Generated".equals(name) ? this.txSourceRepository : this.fsRegistry.getRepository(name);
    }

    public TransformRepository getOrCreateRepository(String name) throws IOException {
        return "Generated".equals(name) ? this.txSourceRepository : this.fsRegistry.getOrCreateRepository(name);
    }

    public Set<TransformDefinition> find(TransformFilter filter) {
        Set<TransformDefinition> transforms = this.fsRegistry.find(filter);
        transforms.addAll(this.txSourceRepository.find(filter));
        return transforms;
    }

    public boolean removeTransform(String name) {
        return this.fsRegistry.removeTransform(name);
    }
}

