/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene;

import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.PandoraQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;

abstract class PandoraQueryImpl
implements PandoraQuery {
    private int _maxResults = Integer.MAX_VALUE;
    private final List<SortProperty> _sorters = new ArrayList<SortProperty>();
    private final List<PandoraFilter> _filters = new ArrayList<PandoraFilter>();
    private List<IncludeProperty> _properties = new ArrayList<IncludeProperty>();
    private boolean _changed = false;

    PandoraQueryImpl() {
    }

    public boolean mustResetPaging() {
        return this._changed;
    }

    public void setPagingMode() {
        this._changed = false;
    }

    @Deprecated
    public PandoraQuery limit(int maxResults) {
        this._maxResults = maxResults;
        return this;
    }

    public PandoraQuery sort(String property, boolean ascending) {
        this.sort(property, ascending, false);
        return this;
    }

    public PandoraQuery sort(String property, boolean ascending, boolean emptyFirst) {
        this._sorters.add(new SortProperty(property, ascending, emptyFirst));
        this._changed = true;
        return this;
    }

    public PandoraQuery sort(String property, boolean ascending, Class type) {
        this.sort(property, ascending, false, type);
        return this;
    }

    public PandoraQuery sort(String property, boolean ascending, boolean emptyFirst, Class type) {
        this._sorters.add(new SortProperty(property, type, ascending, emptyFirst));
        this._changed = true;
        return this;
    }

    public PandoraQuery sortKey(boolean ascending) {
        return this.sort("__key", ascending);
    }

    public PandoraQuery sortIndexDate(boolean ascending) {
        return this.sort("__index-date", ascending);
    }

    public PandoraQuery sortBirthDate(boolean ascending) {
        return this.sort("__birth-date", ascending);
    }

    public PandoraQuery include(String property) {
        return this.include(property, null);
    }

    public PandoraQuery include(String property, Class type) {
        if (this._properties.isEmpty()) {
            this.includeKeyOnly();
        }
        this._properties.add(new IncludeProperty(property, type, true));
        return this;
    }

    public PandoraQuery exclude(String property) {
        return this.exclude(property, null);
    }

    public PandoraQuery exclude(String property, Class type) {
        if (property.equals("__index-date") || property.equals("__birth-date") || property.equals("__key")) {
            throw new IllegalArgumentException("Excluding the key or index date is not allowed.");
        }
        this._properties.add(new IncludeProperty(property, type, false));
        return this;
    }

    public PandoraQuery includeAll() {
        this._properties.clear();
        return this;
    }

    public PandoraQuery includeKeyOnly() {
        this._properties.clear();
        this._properties.add(new IncludeProperty("__key", true));
        this._properties.add(new IncludeProperty("__index-date", true));
        this._properties.add(new IncludeProperty("__birth-date", true));
        return this;
    }

    public PandoraQuery filter(PandoraFilter ... filter) {
        this._filters.addAll(Arrays.asList(filter));
        this._changed = true;
        return this;
    }

    public <T> PandoraQuery filterContains(String property, T ... values) {
        return this.filter(new PandoraFilter[]{new PandoraFilter.Contains(property, (Object[])values)});
    }

    public <T> PandoraQuery filterContainsAny(String property, T ... values) {
        return this.filter(new PandoraFilter[]{new PandoraFilter.ContainsAny(property, (Object[])values)});
    }

    public PandoraQuery filterEmpty(String property) {
        return this.filter(new PandoraFilter[]{new PandoraFilter.Empty(property)});
    }

    public PandoraQuery filterNotEmpty(String property) {
        return this.filter(new PandoraFilter[]{new PandoraFilter.NotEmpty(property)});
    }

    public <T> PandoraQuery filterWithin(String property, T ... value) {
        return this.filter(new PandoraFilter[]{new PandoraFilter.Within(property, (Object[])value)});
    }

    public <T> PandoraQuery filterWithinAny(String property, T ... values) {
        return this.filter(new PandoraFilter[]{new PandoraFilter.WithinAny(property, (Object[])values)});
    }

    public <T> PandoraQuery filterOverlaps(String property, T ... values) {
        return this.filter(new PandoraFilter[]{new PandoraFilter.Intersects(property, (Object[])values)});
    }

    public <T> PandoraQuery filterOverlapsAny(String property, T ... values) {
        return this.filter(new PandoraFilter[]{new PandoraFilter.IntersectsAny(property, (Object[])values)});
    }

    public <T> PandoraQuery filterBetween(String property, T from, T to) {
        return this.filter(new PandoraFilter[]{new PandoraFilter.Between(property, from, to, true)});
    }

    public <T> PandoraQuery filterGreaterThan(String property, T from) {
        return this.filter(new PandoraFilter[]{new PandoraFilter.GreaterThan(property, from, false)});
    }

    public <T> PandoraQuery filterLessThan(String property, T to) {
        return this.filter(new PandoraFilter[]{new PandoraFilter.LessThan(property, to, false)});
    }

    public <T> PandoraQuery filterGreaterOrEqual(String property, T from) {
        return this.filter(new PandoraFilter[]{new PandoraFilter.GreaterThan(property, from, true)});
    }

    public <T> PandoraQuery filterLessOrEqual(String property, T to) {
        return this.filter(new PandoraFilter[]{new PandoraFilter.LessThan(property, to, true)});
    }

    public PandoraQuery filterLike(String property, String query) {
        return this.filter(new PandoraFilter[]{new PandoraFilter.Like(property, query)});
    }

    public String escape(String query) {
        return QueryParserUtil.escape((String)query);
    }

    public PandoraQuery not() {
        if (this._filters.isEmpty()) {
            throw new UnsupportedOperationException("A not filter must follow another filter.");
        }
        PandoraFilter lastFilter = this._filters.get(this._filters.size() - 1);
        PandoraFilter.Not replaceFilter = new PandoraFilter.Not(lastFilter);
        this._filters.set(this._filters.size() - 1, (PandoraFilter)replaceFilter);
        this._changed = true;
        return this;
    }

    public PandoraQuery andAny(PandoraFilter ... filters) {
        PandoraFilter.Or orGroup = new PandoraFilter.Or(filters);
        return this.filter(new PandoraFilter[]{orGroup});
    }

    public PandoraQuery keys(long ... values) {
        if (values.length == 1) {
            return this.filterContains("__key", values[0]);
        }
        return this.filterContainsAny("__key", (T[])new long[][]{values});
    }

    public PandoraQuery keyBetween(long from, long to) {
        return this.filterBetween("__key", from, to);
    }

    public PandoraQuery indexDateBetween(Date from, Date to) {
        return this.filterBetween("__index-date", from, to);
    }

    public PandoraQuery birthDateBetween(Date from, Date to) {
        return this.filterBetween("__birth-date", from, to);
    }

    @Deprecated
    protected int getMaxResults() {
        return this._maxResults;
    }

    protected SortProperty[] getSorters() {
        return this._sorters.toArray(new SortProperty[0]);
    }

    protected IncludeProperty[] getProperties() {
        IncludeProperty[] properties = this._properties.toArray(new IncludeProperty[0]);
        return properties;
    }

    protected PandoraFilter[] getFilters() {
        return this._filters.toArray(new PandoraFilter[0]);
    }

    public String toString() {
        return "PandoraQuery{\n sorters=" + this._sorters + "\n filters=" + this._filters + "\n properties=" + this._properties + "\n}";
    }

    public static class IncludeProperty {
        private final String _property;
        private final Class _type;
        private final boolean _include;

        public IncludeProperty(String property, boolean include) {
            this(property, null, include);
        }

        public IncludeProperty(String property, Class type, boolean include) {
            this._property = property;
            this._include = include;
            this._type = type;
        }

        public String getProperty() {
            return this._property;
        }

        public Class getType() {
            return this._type;
        }

        public boolean isIncluded() {
            return this._include;
        }

        public String toString() {
            String type = this._type == null ? "" : "[" + this._type + "]";
            return (this._include ? "include" : "exclude") + "{" + this._property + type + "}";
        }
    }

    public static class SortProperty {
        private String _property;
        private boolean _ascending;
        private Class _type;
        private boolean _emptyFirst;

        public SortProperty(String property, boolean ascending, boolean emptyFirst) {
            this(property, null, ascending, emptyFirst);
        }

        public SortProperty(String property, Class type, boolean ascending, boolean emptyFirst) {
            this._property = property;
            this._ascending = ascending;
            this._type = type;
            this._emptyFirst = emptyFirst;
        }

        public String getProperty() {
            return this._property;
        }

        public boolean isAscending() {
            return this._ascending;
        }

        public boolean isEmptyFirst() {
            return this._emptyFirst;
        }

        public Class getType() {
            return this._type;
        }

        public String toString() {
            if (this._type == null) {
                return this._property + " " + (this._ascending ? "asc" : "desc") + " " + (this._emptyFirst ? "emptyFirst" : "emptyLast");
            }
            return this._property + " (" + this._type + ") " + (this._ascending ? "asc" : "desc") + " " + (this._emptyFirst ? "emptyFirst" : "emptyLast");
        }
    }
}

