/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.save;

import com.maltego.cloud.crypto.CloudGraphKeystore;
import com.maltego.cloud.crypto.util.CryptoUtilities;
import com.maltego.cloud.data.Case;
import com.maltego.cloud.data.CaseKey;
import com.maltego.cloud.data.NewCase;
import com.maltego.cloud.data.SymmetricEncryptionConfig;
import com.maltego.cloud.rest.GraphStoreRestClient;
import com.maltego.cloud.ui.cases.CaseSelectionUI;
import com.maltego.cloud.ui.cases.NewCaseAction;
import com.maltego.cloud.ui.cases.NewCaseSelection;
import com.maltego.cloud.ui.save.SaveToCloudAction;
import com.maltego.cloud.ui.save.SaveToCloudOptions;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.ui.HtmlUIUtils;
import com.paterva.maltego.util.ui.components.LabelGroupWithBackground;
import com.paterva.maltego.util.ui.components.LabelWithBackground;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKey;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

class SaveToCloudDialog {
    private static final String OPEN_BROWSER_GRAPH = "openBrowserGraph";
    private static CaseSelectionUI caseSelectionUI;
    private static NewCaseAction newCaseCallback;

    private SaveToCloudDialog() {
    }

    static SaveToCloudOptions showSaveToCloudDialog(String graphName) throws IOException {
        final JButton saveOption = new JButton("Save To Maltego Cases");
        JButton cancelOption = new JButton("Cancel");
        Object[] options = new Object[]{saveOption, cancelOption};
        String description = "<b>Do you want to save your graph to Maltego Cases?</b>";
        String title = "Save To Maltego Cases";
        JEditorPane htmlPane = HtmlUIUtils.getHtmlPane((String)description);
        htmlPane.setBackground(new JPanel().getBackground());
        JPanel formPane = new JPanel();
        formPane.setLayout(new GridBagLayout());
        LabelWithBackground graphNameLabel = new LabelWithBackground("File Name:");
        JTextField graphNameField = new JTextField();
        graphNameField.setText(graphName);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(15, 10, 15, 10), 0, 0);
        formPane.add((Component)graphNameLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.ipadx = 220;
        formPane.add((Component)graphNameField, gbc);
        JPanel wrapperPane = new JPanel();
        wrapperPane.setLayout(new BoxLayout(wrapperPane, 1));
        wrapperPane.add(formPane);
        AtomicReference result = new AtomicReference();
        AtomicReference<Dialog> dialogRef = new AtomicReference<Dialog>();
        Case[] caseList = GraphStoreRestClient.fetchCaseList();
        newCaseCallback = new NewCaseAction(){

            @Override
            public void actionPerformed(NewCaseSelection selection, NewCaseAction.Callback callback) {
                saveOption.setEnabled(false);
                RequestProcessor.getDefault().post(() -> {
                    NotifyDescriptor.Message msg;
                    String errorMessage;
                    try {
                        CaseKey caseKey = null;
                        if (selection.isEncrypted()) {
                            CloudGraphKeystore keystore = CloudGraphKeystore.getDefault();
                            SecretKey caseSecretKey = CryptoUtilities.generateAESKey();
                            PublicKey publicKey = keystore.getPublicKey();
                            byte[] encryptCaseKey = CryptoUtilities.encryptCaseKey((SecretKey)caseSecretKey, (PublicKey)publicKey);
                            String encryptCaseKeyString = Base64.getEncoder().encodeToString(encryptCaseKey);
                            caseKey = new CaseKey(keystore.getKeyPairID(), new SymmetricEncryptionConfig("RSA_OAEP"), encryptCaseKeyString);
                        }
                        NewCase newCase = new NewCase(selection.getCaseName(), caseKey);
                        GraphStoreRestClient.createNewCase((NewCase)newCase);
                    }
                    catch (IOException | GeneralSecurityException ex) {
                        NormalException.logStackTrace((Throwable)ex);
                        errorMessage = "Creating new case failed: " + ex.getMessage();
                        msg = new NotifyDescriptor.Message((Object)errorMessage, 0);
                        msg.setTitle("Create New Case");
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    }
                    try {
                        Case[] caseList = GraphStoreRestClient.fetchCaseList();
                        SwingUtilities.invokeLater(() -> {
                            caseSelectionUI.setCases(caseList);
                            callback.callback();
                            saveOption.setEnabled(true);
                        });
                    }
                    catch (IOException ex) {
                        NormalException.logStackTrace((Throwable)ex);
                        errorMessage = "Refreshing case list failed: " + ex.getMessage();
                        msg = new NotifyDescriptor.Message((Object)errorMessage, 0);
                        msg.setTitle("Create New Case");
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    }
                });
            }
        };
        caseSelectionUI = new CaseSelectionUI(caseList, newCaseCallback);
        wrapperPane.add(caseSelectionUI);
        JCheckBox openGraphInBrowserCheckBox = new JCheckBox();
        openGraphInBrowserCheckBox.setSelected(SaveToCloudDialog.mustOpenBrowserGraph());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(new Insets(15, 10, 15, 10)));
        LabelGroupWithBackground label = new LabelGroupWithBackground("Open in Maltego Graph (Browser)");
        label.setLabelFor((Component)openGraphInBrowserCheckBox);
        panel.add((Component)label, "West");
        panel.add((Component)openGraphInBrowserCheckBox, "Center");
        wrapperPane.add(panel);
        ActionListener listener = e -> {
            boolean mustClose = false;
            if (e.getSource() == saveOption) {
                try {
                    int row = caseSelectionUI.getCaseTable().convertRowIndexToModel(caseSelectionUI.getCaseTable().getSelectedRow());
                    Case selectedCase = (Case)caseSelectionUI.getModel().getRow(row);
                    boolean openGraphInBrowser = openGraphInBrowserCheckBox.isSelected();
                    SaveToCloudDialog.setOpenBrowserGraph(openGraphInBrowser);
                    result.set(new SaveToCloudOptions(graphNameField.getText(), openGraphInBrowser, selectedCase));
                    mustClose = true;
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(wrapperPane, "Please select a Case to save the Cloud Graph in, or create a new Case", "No Case Selected", 1);
                }
            } else {
                result.set(null);
                mustClose = true;
            }
            if (mustClose) {
                Dialog dialog = (Dialog)dialogRef.get();
                dialog.setVisible(false);
                dialog.dispose();
            }
        };
        DialogDescriptor dd = new DialogDescriptor((Object)wrapperPane, title, true, options, (Object)saveOption, 0, HelpCtx.DEFAULT_HELP, listener);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialogRef.set(dialog);
        dialog.setVisible(true);
        return (SaveToCloudOptions)result.get();
    }

    private static boolean mustOpenBrowserGraph() {
        return NbPreferences.forModule(SaveToCloudAction.class).getBoolean(OPEN_BROWSER_GRAPH, false);
    }

    private static void setOpenBrowserGraph(boolean enabled) {
        NbPreferences.forModule(SaveToCloudAction.class).putBoolean(OPEN_BROWSER_GRAPH, enabled);
    }
}

