/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.builtins.DataViewPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToIndexNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSDataView;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class DataViewPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<DataViewPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new DataViewPrototypeBuiltins();

    protected DataViewPrototypeBuiltins() {
        super("DataView.prototype", DataViewPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, DataViewPrototype builtinEnum) {
        switch (builtinEnum) {
            case getBigInt64: 
            case getBigUint64: 
            case getFloat32: 
            case getFloat64: 
            case getInt16: 
            case getInt32: 
            case getInt8: 
            case getUint16: 
            case getUint32: 
            case getUint8: {
                return DataViewPrototypeBuiltinsFactory.DataViewGetNodeGen.create(context, builtin, DataViewPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case setBigInt64: 
            case setBigUint64: 
            case setFloat32: 
            case setFloat64: 
            case setInt16: 
            case setInt32: 
            case setInt8: 
            case setUint16: 
            case setUint32: 
            case setUint8: {
                return DataViewPrototypeBuiltinsFactory.DataViewSetNodeGen.create(context, builtin, DataViewPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
        }
        return null;
    }

    @ImportStatic(value={JSDataView.class})
    public static abstract class DataViewSetNode
    extends DataViewAccessNode {
        @Node.Child
        private JSToNumberNode toNumberNode;
        @Node.Child
        private JSToBigIntNode toBigIntNode;

        public DataViewSetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            if (this.factory.isBigInt()) {
                this.toBigIntNode = JSToBigIntNode.create();
            } else {
                this.toNumberNode = JSToNumberNode.create();
            }
        }

        @Specialization(guards={"isJSDataView(dataView)"})
        protected Object doDataView(Object dataView, Object byteOffset, Object value, Object littleEndian, @Cached(value="create()") JSToIndexNode toIndexNode, @Cached(value="create()") BranchProfile errorBranch, @Cached(value="createClassProfile()") ValueProfile bufferTypeProfile, @Cached(value="createClassProfile()") ValueProfile arrayTypeProfile) {
            boolean isLittleEndian;
            DynamicObject buffer = (DynamicObject)bufferTypeProfile.profile((Object)JSDataView.getArrayBuffer(dataView));
            long getIndex = toIndexNode.executeLong(byteOffset);
            Object numberValue = this.factory.isBigInt() ? this.toBigIntNode.executeBigInteger(value) : this.toNumberNode.executeNumber(value);
            boolean bl = isLittleEndian = this.factory.getBytesPerElement() == 1 ? true : this.toBooleanNode.executeBoolean(littleEndian);
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(buffer)) {
                errorBranch.enter();
                throw Errors.createTypeErrorDetachedBuffer();
            }
            int viewLength = JSDataView.typedArrayGetLength(dataView);
            int elementSize = this.factory.getBytesPerElement();
            if (getIndex + (long)elementSize > (long)viewLength) {
                errorBranch.enter();
                throw Errors.createRangeError("index + elementSize > viewLength");
            }
            int viewOffset = JSDataView.typedArrayGetOffset(dataView);
            assert (getIndex + (long)viewOffset <= Integer.MAX_VALUE);
            int bufferIndex = (int)(getIndex + (long)viewOffset);
            boolean isInteropBuffer = JSArrayBuffer.isJSInteropArrayBuffer(buffer);
            TypedArray strategy = (TypedArray)arrayTypeProfile.profile((Object)this.factory.createArrayType(JSArrayBuffer.isJSDirectOrSharedArrayBuffer(buffer), true, isInteropBuffer));
            strategy.setBufferElement(buffer, bufferIndex, isLittleEndian, numberValue, isInteropBuffer ? this.getInterop() : null);
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSDataView(thisObj)"})
        protected DynamicObject doIncompatibleReceiver(Object thisObj, Object byteOffset, Object value, Object littleEndian) {
            throw Errors.createTypeErrorNotADataView();
        }
    }

    @ImportStatic(value={JSDataView.class})
    public static abstract class DataViewGetNode
    extends DataViewAccessNode {
        public DataViewGetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSDataView(dataView)"})
        protected final Object doDataView(Object dataView, Object byteOffset, Object littleEndian, @Cached(value="create()") JSToIndexNode toIndexNode, @Cached(value="create()") BranchProfile errorBranch, @Cached(value="createClassProfile()") ValueProfile bufferTypeProfile, @Cached(value="createClassProfile()") ValueProfile arrayTypeProfile) {
            boolean isLittleEndian;
            DynamicObject buffer = (DynamicObject)bufferTypeProfile.profile((Object)JSDataView.getArrayBuffer(dataView));
            long getIndex = toIndexNode.executeLong(byteOffset);
            boolean bl = isLittleEndian = this.factory.getBytesPerElement() == 1 ? true : this.toBooleanNode.executeBoolean(littleEndian);
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(buffer)) {
                errorBranch.enter();
                throw Errors.createTypeErrorDetachedBuffer();
            }
            int viewLength = JSDataView.typedArrayGetLength(dataView);
            int elementSize = this.factory.getBytesPerElement();
            if (getIndex + (long)elementSize > (long)viewLength) {
                errorBranch.enter();
                throw Errors.createRangeError("index + elementSize > viewLength");
            }
            int viewOffset = JSDataView.typedArrayGetOffset(dataView);
            assert (getIndex + (long)viewOffset <= Integer.MAX_VALUE);
            int bufferIndex = (int)(getIndex + (long)viewOffset);
            boolean isInteropBuffer = JSArrayBuffer.isJSInteropArrayBuffer(buffer);
            TypedArray strategy = (TypedArray)arrayTypeProfile.profile((Object)this.factory.createArrayType(JSArrayBuffer.isJSDirectOrSharedArrayBuffer(buffer), true, isInteropBuffer));
            return strategy.getBufferElement(buffer, bufferIndex, isLittleEndian, isInteropBuffer ? this.getInterop() : null);
        }

        @Specialization(guards={"!isJSDataView(thisObj)"})
        protected DynamicObject doIncompatibleReceiver(Object thisObj, Object byteOffset, Object littleEndian) {
            throw Errors.createTypeErrorNotADataView();
        }
    }

    public static abstract class DataViewAccessNode
    extends JSBuiltinNode {
        protected final TypedArrayFactory factory;
        @Node.Child
        protected JSToBooleanNode toBooleanNode;
        @Node.Child
        private InteropLibrary interopLibrary;

        public DataViewAccessNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.factory = DataViewAccessNode.typedArrayFactoryFromType(builtin.getName().substring(3));
            this.toBooleanNode = this.factory.getBytesPerElement() == 1 ? null : JSToBooleanNode.create();
        }

        private static TypedArrayFactory typedArrayFactoryFromType(String type) {
            for (TypedArrayFactory factory : TypedArray.factories()) {
                if (!factory.getName().startsWith(type)) continue;
                return factory;
            }
            throw new IllegalArgumentException(type);
        }

        protected final InteropLibrary getInterop() {
            InteropLibrary lib = this.interopLibrary;
            if (lib == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.interopLibrary = lib = (InteropLibrary)this.insert((Node)InteropLibrary.getFactory().createDispatched(5));
            }
            return lib;
        }
    }

    public static enum DataViewPrototype implements BuiltinEnum<DataViewPrototype>
    {
        getBigInt64(1),
        getBigUint64(1),
        getFloat32(1),
        getFloat64(1),
        getInt8(1),
        getInt16(1),
        getInt32(1),
        getUint8(1),
        getUint16(1),
        getUint32(1),
        setBigInt64(2),
        setBigUint64(2),
        setFloat32(2),
        setFloat64(2),
        setInt8(2),
        setInt16(2),
        setInt32(2),
        setUint8(2),
        setUint16(2),
        setUint32(2);

        private final int length;

        private DataViewPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

