/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.descriptor;

import com.paterva.maltego.imgfactoryapi.ImageFactory;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.PropertyConfiguration;
import com.paterva.maltego.typing.descriptor.ToolboxItem;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Color;
import java.awt.Image;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ToolboxItemSpec<TInstance>
extends TypeSpec
implements ToolboxItem {
    private String _description;
    private String _helpUrl;
    private String _helpText;
    private Class<? extends TInstance> _class;
    private boolean _canBeRoot = true;
    private Image _smallIcon;
    private Image _largeIcon;
    private String _smallIconResource;
    private String _largeIconResource;
    private Color _color;
    private static final String VALUE_PROPERTY = "value";
    private String _displayValueExpression;

    public ToolboxItemSpec() {
    }

    public ToolboxItemSpec(String name, DisplayDescriptorCollection properties) {
        super(name, properties);
    }

    public ToolboxItemSpec(String name, DisplayDescriptorCollection properties, GroupDefinitions groups) {
        super(name, properties, groups);
    }

    public ToolboxItemSpec(String name, PropertyConfiguration properties) {
        super(name, properties);
    }

    public ToolboxItemSpec(ToolboxItemSpec other) {
        super(other);
        this._description = other._description;
        this._helpUrl = other._helpUrl;
        this._helpText = other._helpText;
        this._class = other._class;
        this._canBeRoot = other._canBeRoot;
        this._smallIcon = other._smallIcon;
        this._largeIcon = other._largeIcon;
        this._smallIconResource = other._smallIconResource;
        this._largeIconResource = other._largeIconResource;
        this._color = other._color;
        this._displayValueExpression = other._displayValueExpression;
    }

    @Override
    public boolean isCopy(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolboxItemSpec)) {
            return false;
        }
        ToolboxItemSpec other = (ToolboxItemSpec)obj;
        if (this._description == null ? other._description != null : !this._description.equals(other._description)) {
            return false;
        }
        if (this._helpUrl == null ? other._helpUrl != null : !this._helpUrl.equals(other._helpUrl)) {
            return false;
        }
        if (this._helpText == null ? other._helpText != null : !this._helpText.equals(other._helpText)) {
            return false;
        }
        if (!(this._class == other._class || this._class != null && this._class.equals(other._class))) {
            return false;
        }
        if (this._canBeRoot != other._canBeRoot) {
            return false;
        }
        if (!(this._smallIcon == other._smallIcon || this._smallIcon != null && this._smallIcon.equals(other._smallIcon))) {
            return false;
        }
        if (!(this._largeIcon == other._largeIcon || this._largeIcon != null && this._largeIcon.equals(other._largeIcon))) {
            return false;
        }
        String smallResourceThis = this.getSmallIconResource();
        String smallResourceOther = other.getSmallIconResource();
        if (smallResourceThis == null ? smallResourceOther != null : !smallResourceThis.equals(smallResourceOther)) {
            return false;
        }
        if (this._largeIconResource == null ? other._largeIconResource != null : !this._largeIconResource.equals(other._largeIconResource)) {
            return false;
        }
        if (!(this._color == other._color || this._color != null && this._color.equals(other._color))) {
            return false;
        }
        if (!Objects.equals(this._displayValueExpression, other._displayValueExpression)) {
            return false;
        }
        return super.isCopy(other);
    }

    public void setDisplayValueExpression(String displayExpr) {
        if (StringUtils.isBlank((CharSequence)displayExpr)) {
            displayExpr = null;
        }
        this._displayValueExpression = displayExpr;
    }

    public String getDisplayValueExpression() {
        DisplayDescriptor valueProperty;
        if (StringUtils.isBlank((CharSequence)this._displayValueExpression) && (valueProperty = this.getValueProperty()) != null) {
            return valueProperty.getName();
        }
        return this._displayValueExpression != null ? this._displayValueExpression : "";
    }

    public void setValueProperty(DisplayDescriptor value) {
        this.setSpecialProperty(VALUE_PROPERTY, value);
    }

    public DisplayDescriptor getValueProperty() {
        return this.getSpecialProperty(VALUE_PROPERTY);
    }

    @Override
    public String getHelpUrl() {
        return this._helpUrl;
    }

    @Override
    public void setHelpUrl(String url) {
        this._helpUrl = url;
    }

    public void setInstanceClass(Class<? extends TInstance> clazz) {
        this._class = clazz;
    }

    public Class<? extends TInstance> getInstanceClass() {
        return this._class;
    }

    @Override
    public boolean isToolboxItem() {
        return this._canBeRoot;
    }

    @Override
    public void setToolboxItem(boolean value) {
        this._canBeRoot = value;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(String description) {
        this._description = description;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getHelpText() {
        return this._helpText;
    }

    public void setHelpText(String helpText) {
        this._helpText = helpText;
    }

    @Override
    public Image getSmallIcon() {
        return this._smallIcon;
    }

    @Override
    public Image getLargeIcon() {
        return this._largeIcon;
    }

    @Override
    public void setSmallIcon(Image image) {
        if (image != null) {
            this._smallIconResource = null;
        }
        this._smallIcon = image;
    }

    @Override
    public void setLargeIcon(Image image) {
        if (image != null) {
            this._largeIconResource = null;
        }
        this._largeIcon = image;
    }

    @Override
    public String getHelp() {
        return this._helpText;
    }

    @Override
    public void setHelp(String help) {
        this._helpText = help;
    }

    @Override
    public Color getColor() {
        return this._color;
    }

    @Override
    public void setColor(Color color) {
        this._color = color;
    }

    public String getSmallIconResource() {
        if (StringUtilities.isNullOrEmpty((String)this._smallIconResource)) {
            return this.getLargeIconResource();
        }
        return this._smallIconResource;
    }

    public void setSmallIconResource(String url) {
        if (!StringUtilities.isNullOrEmpty((String)url)) {
            this._smallIconResource = url;
            this._smallIcon = null;
        }
    }

    public String getLargeIconResource() {
        return this._largeIconResource;
    }

    public void setLargeIconResource(String url) {
        if (!StringUtilities.isNullOrEmpty((String)url)) {
            this._largeIconResource = url;
            this._largeIcon = null;
        }
    }

    public Image getIcon(int size) {
        return this.getIcon(size, size);
    }

    public Image getIcon(int width, int height) {
        if (height >= 0 && height <= 20) {
            if (!StringUtilities.isNullOrEmpty((String)this.getSmallIconResource())) {
                return ToolboxItemSpec.getImageFromResource(this.getSmallIconResource(), width, height);
            }
            return this._smallIcon;
        }
        if (!StringUtilities.isNullOrEmpty((String)this.getLargeIconResource())) {
            return ToolboxItemSpec.getImageFromResource(this.getLargeIconResource(), width, height);
        }
        return this._largeIcon;
    }

    private static Image getImageFromResource(String resource, int width, int height) {
        Image image = ImageFactory.getDefault().getImage((Object)resource, width, height, null);
        return image;
    }
}

