/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.analytics;

import com.paterva.maltego.util.MaltegoUrl;
import com.paterva.maltego.util.Version;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class AmplitudeProperties {
    private static final Logger LOG = Logger.getLogger(AmplitudeProperties.class.getName());
    private static AmplitudeProperties INSTANCE;
    private final Properties props = new Properties();

    private AmplitudeProperties() {
    }

    public static final synchronized AmplitudeProperties getInstance() {
        if (INSTANCE == null) {
            AmplitudeProperties amplitudeProperties = new AmplitudeProperties();
            String amplitudeFileName = "Amplitude.properties";
            if (Version.getCurrent().isDevBuild()) {
                if (MaltegoUrl.MALTEGO_ID_LICENSE_DEV_ENV_TESTING) {
                    amplitudeFileName = "AmplitudeDev.properties";
                } else if (MaltegoUrl.MALTEGO_ID_LICENSE_QA_ENV_TESTING) {
                    amplitudeFileName = "AmplitudeQA.properties";
                } else if (MaltegoUrl.MALTEGO_ID_LICENSE_Staging_ENV_TESTING) {
                    amplitudeFileName = "AmplitudeStaging.properties";
                }
            }
            try (InputStream is = AmplitudeProperties.class.getResourceAsStream(amplitudeFileName);){
                amplitudeProperties.props.load(is);
                INSTANCE = amplitudeProperties;
            }
            catch (FileNotFoundException ex) {
                LOG.log(Level.FINE, "Cannot open Amplitude properties file", ex);
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Error opening Amplitude properties file", ex);
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return INSTANCE;
    }

    public String getAPIKey() {
        return this.props.getProperty("amplitude.apikey");
    }

    public String getUrl() {
        return this.props.getProperty("amplitude.url");
    }
}

