/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.analysis;

import com.android.tools.smali.dexlib2.analysis.AnalyzedInstruction;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.iface.instruction.InlineIndexInstruction;
import com.android.tools.smali.dexlib2.iface.instruction.VariableRegisterInstruction;
import com.android.tools.smali.dexlib2.immutable.ImmutableMethod;
import com.android.tools.smali.dexlib2.immutable.ImmutableMethodParameter;
import com.android.tools.smali.dexlib2.immutable.util.ParamUtil;
import com.android.tools.smali.util.IteratorUtils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class InlineMethodResolver {
    public static final int STATIC = 8;
    public static final int VIRTUAL = 1;
    public static final int DIRECT = 2;

    @Nonnull
    public static InlineMethodResolver createInlineMethodResolver(int odexVersion) {
        if (odexVersion == 35) {
            return new InlineMethodResolver_version35();
        }
        if (odexVersion == 36) {
            return new InlineMethodResolver_version36();
        }
        throw new RuntimeException(String.format("odex version %d is not supported yet", odexVersion));
    }

    protected InlineMethodResolver() {
    }

    @Nonnull
    private static Method inlineMethod(int accessFlags, @Nonnull String cls, @Nonnull String name, @Nonnull String params, @Nonnull String returnType) {
        List<ImmutableMethodParameter> paramList = Collections.unmodifiableList(IteratorUtils.toList(ParamUtil.parseParamString(params)));
        return new ImmutableMethod(cls, name, paramList, returnType, accessFlags, null, null, null);
    }

    @Nonnull
    public abstract Method resolveExecuteInline(@Nonnull AnalyzedInstruction var1);

    private static class InlineMethodResolver_version35
    extends InlineMethodResolver {
        private final Method[] inlineMethods = new Method[]{InlineMethodResolver.access$000(8, "Lorg/apache/harmony/dalvik/NativeTestTarget;", "emptyInlineMethod", "", "V"), InlineMethodResolver.access$000(1, "Ljava/lang/String;", "charAt", "I", "C"), InlineMethodResolver.access$000(1, "Ljava/lang/String;", "compareTo", "Ljava/lang/String;", "I"), InlineMethodResolver.access$000(1, "Ljava/lang/String;", "equals", "Ljava/lang/Object;", "Z"), InlineMethodResolver.access$000(1, "Ljava/lang/String;", "length", "", "I"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "abs", "I", "I"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "abs", "J", "J"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "abs", "F", "F"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "abs", "D", "D"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "min", "II", "I"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "max", "II", "I"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "sqrt", "D", "D"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "cos", "D", "D"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "sin", "D", "D")};

        @Override
        @Nonnull
        public Method resolveExecuteInline(@Nonnull AnalyzedInstruction analyzedInstruction) {
            InlineIndexInstruction instruction = (InlineIndexInstruction)analyzedInstruction.instruction;
            int inlineIndex = instruction.getInlineIndex();
            if (inlineIndex < 0 || inlineIndex >= this.inlineMethods.length) {
                throw new RuntimeException("Invalid inline index: " + inlineIndex);
            }
            return this.inlineMethods[inlineIndex];
        }
    }

    private static class InlineMethodResolver_version36
    extends InlineMethodResolver {
        private final Method[] inlineMethods;
        private final Method indexOfIMethod = InlineMethodResolver.access$000(1, "Ljava/lang/String;", "indexOf", "I", "I");
        private final Method indexOfIIMethod = InlineMethodResolver.access$000(1, "Ljava/lang/String;", "indexOf", "II", "I");
        private final Method fastIndexOfMethod = InlineMethodResolver.access$000(2, "Ljava/lang/String;", "fastIndexOf", "II", "I");
        private final Method isEmptyMethod = InlineMethodResolver.access$000(1, "Ljava/lang/String;", "isEmpty", "", "Z");

        public InlineMethodResolver_version36() {
            this.inlineMethods = new Method[]{InlineMethodResolver.inlineMethod(8, "Lorg/apache/harmony/dalvik/NativeTestTarget;", "emptyInlineMethod", "", "V"), InlineMethodResolver.inlineMethod(1, "Ljava/lang/String;", "charAt", "I", "C"), InlineMethodResolver.inlineMethod(1, "Ljava/lang/String;", "compareTo", "Ljava/lang/String;", "I"), InlineMethodResolver.inlineMethod(1, "Ljava/lang/String;", "equals", "Ljava/lang/Object;", "Z"), null, null, InlineMethodResolver.inlineMethod(1, "Ljava/lang/String;", "length", "", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "abs", "I", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "abs", "J", "J"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "abs", "F", "F"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "abs", "D", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "min", "II", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "max", "II", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "sqrt", "D", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "cos", "D", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "sin", "D", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Float;", "floatToIntBits", "F", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Float;", "floatToRawIntBits", "F", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Float;", "intBitsToFloat", "I", "F"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Double;", "doubleToLongBits", "D", "J"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Double;", "doubleToRawLongBits", "D", "J"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Double;", "longBitsToDouble", "J", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "abs", "I", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "abs", "J", "J"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "abs", "F", "F"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "abs", "D", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "min", "II", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "max", "II", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "sqrt", "D", "D")};
        }

        @Override
        @Nonnull
        public Method resolveExecuteInline(@Nonnull AnalyzedInstruction analyzedInstruction) {
            InlineIndexInstruction instruction = (InlineIndexInstruction)analyzedInstruction.instruction;
            int inlineIndex = instruction.getInlineIndex();
            if (inlineIndex < 0 || inlineIndex >= this.inlineMethods.length) {
                throw new RuntimeException("Invalid method index: " + inlineIndex);
            }
            if (inlineIndex == 4) {
                int parameterCount = ((VariableRegisterInstruction)((Object)instruction)).getRegisterCount();
                if (parameterCount == 2) {
                    return this.indexOfIMethod;
                }
                if (parameterCount == 3) {
                    return this.fastIndexOfMethod;
                }
                throw new RuntimeException("Could not determine the correct inline method to use");
            }
            if (inlineIndex == 5) {
                int parameterCount = ((VariableRegisterInstruction)((Object)instruction)).getRegisterCount();
                if (parameterCount == 3) {
                    return this.indexOfIIMethod;
                }
                if (parameterCount == 1) {
                    return this.isEmptyMethod;
                }
                throw new RuntimeException("Could not determine the correct inline method to use");
            }
            return this.inlineMethods[inlineIndex];
        }
    }
}

