/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.rewriter;

import com.android.tools.smali.dexlib2.base.value.BaseAnnotationEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseArrayEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseEnumEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseFieldEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseMethodEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseTypeEncodedValue;
import com.android.tools.smali.dexlib2.iface.AnnotationElement;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.iface.value.AnnotationEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.ArrayEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.EncodedValue;
import com.android.tools.smali.dexlib2.iface.value.EnumEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.FieldEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.MethodEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.TypeEncodedValue;
import com.android.tools.smali.dexlib2.rewriter.Rewriter;
import com.android.tools.smali.dexlib2.rewriter.RewriterUtils;
import com.android.tools.smali.dexlib2.rewriter.Rewriters;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class EncodedValueRewriter
implements Rewriter<EncodedValue> {
    @Nonnull
    protected final Rewriters rewriters;

    public EncodedValueRewriter(@Nonnull Rewriters rewriters) {
        this.rewriters = rewriters;
    }

    @Override
    @Nonnull
    public EncodedValue rewrite(@Nonnull EncodedValue encodedValue) {
        switch (encodedValue.getValueType()) {
            case 24: {
                return new RewrittenTypeEncodedValue((TypeEncodedValue)encodedValue);
            }
            case 25: {
                return new RewrittenFieldEncodedValue((FieldEncodedValue)encodedValue);
            }
            case 26: {
                return new RewrittenMethodEncodedValue((MethodEncodedValue)encodedValue);
            }
            case 27: {
                return new RewrittenEnumEncodedValue((EnumEncodedValue)encodedValue);
            }
            case 28: {
                return new RewrittenArrayEncodedValue((ArrayEncodedValue)encodedValue);
            }
            case 29: {
                return new RewrittenAnnotationEncodedValue((AnnotationEncodedValue)encodedValue);
            }
        }
        return encodedValue;
    }

    protected class RewrittenTypeEncodedValue
    extends BaseTypeEncodedValue {
        @Nonnull
        protected TypeEncodedValue typeEncodedValue;

        public RewrittenTypeEncodedValue(TypeEncodedValue typeEncodedValue) {
            this.typeEncodedValue = typeEncodedValue;
        }

        @Override
        @Nonnull
        public String getValue() {
            return EncodedValueRewriter.this.rewriters.getTypeRewriter().rewrite(this.typeEncodedValue.getValue());
        }
    }

    protected class RewrittenFieldEncodedValue
    extends BaseFieldEncodedValue {
        @Nonnull
        protected FieldEncodedValue fieldEncodedValue;

        public RewrittenFieldEncodedValue(FieldEncodedValue fieldEncodedValue) {
            this.fieldEncodedValue = fieldEncodedValue;
        }

        @Override
        @Nonnull
        public FieldReference getValue() {
            return EncodedValueRewriter.this.rewriters.getFieldReferenceRewriter().rewrite(this.fieldEncodedValue.getValue());
        }
    }

    protected class RewrittenMethodEncodedValue
    extends BaseMethodEncodedValue {
        @Nonnull
        protected MethodEncodedValue methodEncodedValue;

        public RewrittenMethodEncodedValue(MethodEncodedValue methodEncodedValue) {
            this.methodEncodedValue = methodEncodedValue;
        }

        @Override
        @Nonnull
        public MethodReference getValue() {
            return EncodedValueRewriter.this.rewriters.getMethodReferenceRewriter().rewrite(this.methodEncodedValue.getValue());
        }
    }

    protected class RewrittenEnumEncodedValue
    extends BaseEnumEncodedValue {
        @Nonnull
        protected EnumEncodedValue enumEncodedValue;

        public RewrittenEnumEncodedValue(EnumEncodedValue enumEncodedValue) {
            this.enumEncodedValue = enumEncodedValue;
        }

        @Override
        @Nonnull
        public FieldReference getValue() {
            return EncodedValueRewriter.this.rewriters.getFieldReferenceRewriter().rewrite(this.enumEncodedValue.getValue());
        }
    }

    protected class RewrittenArrayEncodedValue
    extends BaseArrayEncodedValue {
        @Nonnull
        protected ArrayEncodedValue arrayEncodedValue;

        public RewrittenArrayEncodedValue(ArrayEncodedValue arrayEncodedValue) {
            this.arrayEncodedValue = arrayEncodedValue;
        }

        @Override
        @Nonnull
        public List<? extends EncodedValue> getValue() {
            return RewriterUtils.rewriteList(EncodedValueRewriter.this.rewriters.getEncodedValueRewriter(), this.arrayEncodedValue.getValue());
        }
    }

    protected class RewrittenAnnotationEncodedValue
    extends BaseAnnotationEncodedValue {
        @Nonnull
        protected AnnotationEncodedValue annotationEncodedValue;

        public RewrittenAnnotationEncodedValue(AnnotationEncodedValue annotationEncodedValue) {
            this.annotationEncodedValue = annotationEncodedValue;
        }

        @Override
        @Nonnull
        public String getType() {
            return EncodedValueRewriter.this.rewriters.getTypeRewriter().rewrite(this.annotationEncodedValue.getType());
        }

        @Override
        @Nonnull
        public Set<? extends AnnotationElement> getElements() {
            return RewriterUtils.rewriteSet(EncodedValueRewriter.this.rewriters.getAnnotationElementRewriter(), this.annotationEncodedValue.getElements());
        }
    }
}

