/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.bundle.Config;
import com.android.bundle.SdkMetadataOuterClass;
import com.android.bundle.SdkModulesConfigOuterClass;
import com.android.tools.build.bundletool.model.AutoValue_SdkAsar;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.BundleParser;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteSource;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

@AutoValue
public abstract class SdkAsar {
    public static final String SDK_METADATA_FILE_NAME = "SdkMetadata.pb";

    public static SdkAsar buildFromZip(ZipFile asar, ZipFile modulesFile, Path modulesFilePath) {
        Document document;
        SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig = BundleParser.readSdkModulesConfig(modulesFile);
        BundleModule sdkModule = Iterables.getOnlyElement(BundleParser.sanitize(BundleParser.extractModules(modulesFile, Config.BundleConfig.BundleType.REGULAR, Version.of(sdkModulesConfig.getBundletool().getVersion()), Optional.empty(), Optional.of(sdkModulesConfig), ImmutableSet.of())));
        Builder sdkAsarBuilder = SdkAsar.builder().setModule(sdkModule).setSdkModulesConfig(sdkModulesConfig).setModulesFile(modulesFilePath.toFile()).setSdkMetadata(SdkAsar.readSdkMetadata(asar));
        BundleParser.readSdkInterfaceDescriptors(asar).ifPresent(sdkAsarBuilder::setSdkInterfaceDescriptors);
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e11) {
            throw new IllegalStateException(e11);
        }
        return sdkAsarBuilder.setManifest(document).build();
    }

    public abstract Document getManifest();

    public abstract BundleModule getModule();

    public abstract SdkModulesConfigOuterClass.SdkModulesConfig getSdkModulesConfig();

    public abstract File getModulesFile();

    public abstract SdkMetadataOuterClass.SdkMetadata getSdkMetadata();

    public abstract Optional<ByteSource> getSdkInterfaceDescriptors();

    public String getPackageName() {
        return this.getSdkMetadata().getPackageName();
    }

    public int getMajorVersion() {
        return this.getSdkMetadata().getSdkVersion().getMajor();
    }

    public int getMinorVersion() {
        return this.getSdkMetadata().getSdkVersion().getMinor();
    }

    public String getCertificateDigest() {
        return this.getSdkMetadata().getCertificateDigest();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_SdkAsar.Builder();
    }

    private static SdkMetadataOuterClass.SdkMetadata readSdkMetadata(ZipFile asarFile) {
        ZipEntry sdkMetadataEntry = asarFile.getEntry(SDK_METADATA_FILE_NAME);
        if (sdkMetadataEntry == null) {
            throw InvalidBundleException.builder().withUserMessage("ASAR is expected to contain '%s' file.", SDK_METADATA_FILE_NAME).build();
        }
        try {
            return SdkMetadataOuterClass.SdkMetadata.parseFrom(ZipUtils.asByteSource(asarFile, sdkMetadataEntry).read());
        }
        catch (InvalidProtocolBufferException e11) {
            throw InvalidBundleException.builder().withCause(e11).withUserMessage("SDK metadata file '%s' could not be parsed.", SDK_METADATA_FILE_NAME).build();
        }
        catch (IOException e12) {
            throw new UncheckedIOException(String.format("Error reading file '%s'.", SDK_METADATA_FILE_NAME), e12);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setManifest(Document var1);

        public abstract Builder setModule(BundleModule var1);

        public abstract Builder setSdkModulesConfig(SdkModulesConfigOuterClass.SdkModulesConfig var1);

        public abstract Builder setModulesFile(File var1);

        public abstract Builder setSdkMetadata(SdkMetadataOuterClass.SdkMetadata var1);

        public abstract Builder setSdkInterfaceDescriptors(ByteSource var1);

        public abstract SdkAsar build();
    }
}

