/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class ZipUtils {
    public static Stream<ZipPath> allFileEntriesPaths(ZipFile zipFile) {
        return ZipUtils.allFileEntries(zipFile).map(zipEntry -> ZipPath.create(zipEntry.getName()));
    }

    public static ImmutableList<ZipPath> allFileEntriesPaths(ZipInputStream zipInputStream) {
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                listBuilder.add(ZipPath.create(zipEntry.getName()));
            }
        }
        catch (IOException e11) {
            throw new UncheckedIOException(String.format("Error reading zip file '%s'.", zipInputStream), e11);
        }
        return listBuilder.build();
    }

    public static Stream<? extends ZipEntry> allFileEntries(ZipFile zipFile) {
        return zipFile.stream().filter(Predicates.not(ZipEntry::isDirectory));
    }

    public static ZipFile openZipFile(Path path) {
        FilePreconditions.checkFileExistsAndReadable(path);
        try {
            return new ZipFile(path.toFile());
        }
        catch (IOException e11) {
            throw new UncheckedIOException(String.format("Error reading zip file '%s'.", path), e11);
        }
    }

    public static ZipPath convertBundleToModulePath(ZipPath bundlePath) {
        return bundlePath.subpath(1, bundlePath.getNameCount());
    }

    public static ByteSource asByteSource(ZipFile file2, ZipEntry entry) {
        return new ZipEntryByteSource(file2, entry);
    }

    private ZipUtils() {
    }

    private static final class ZipEntryByteSource
    extends ByteSource {
        private final ZipFile file;
        private final ZipEntry entry;

        ZipEntryByteSource(ZipFile file2, ZipEntry entry) {
            this.file = Preconditions.checkNotNull(file2);
            this.entry = Preconditions.checkNotNull(entry);
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.file.getInputStream(this.entry);
        }

        @Override
        public Optional<Long> sizeIfKnown() {
            return this.entry.getSize() == -1L ? Optional.absent() : Optional.of(this.entry.getSize());
        }

        public String toString() {
            return "ZipUtils.asByteSource(" + this.file + ", " + this.entry + ")";
        }
    }
}

