/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.mac;

public class IOReturnException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int ioReturn;

    public IOReturnException(int kr2) {
        this(kr2, IOReturnException.formatMessage(kr2));
    }

    protected IOReturnException(int kr2, String msg) {
        super(msg);
        this.ioReturn = kr2;
    }

    public int getIOReturnCode() {
        return this.ioReturn;
    }

    public static int getSystem(int kr2) {
        return kr2 >> 26 & 0x3F;
    }

    public static int getSubSystem(int kr2) {
        return kr2 >> 14 & 0xFFF;
    }

    public static int getCode(int kr2) {
        return kr2 & 0x3FFF;
    }

    private static String formatMessage(int kr2) {
        return "IOReturn error code: " + kr2 + " (system=" + IOReturnException.getSystem(kr2) + ", subSystem=" + IOReturnException.getSubSystem(kr2) + ", code=" + IOReturnException.getCode(kr2) + ")";
    }
}

