/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.apk;

import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;

public final class YamlLine {
    public final int indent;
    public final String key;
    public final String value;
    public final boolean isComment;
    public final boolean isEmpty;
    public final boolean hasColon;
    public final boolean isNull;
    public final boolean isItem;

    /*
     * Enabled aggressive block sorting
     */
    public YamlLine(String object) {
        int n;
        this.indent = 0;
        this.key = "";
        this.value = "";
        this.isNull = Objects.isNull(object);
        if (this.isNull) {
            return;
        }
        this.isEmpty = ((String)object).trim().isEmpty();
        if (this.isEmpty) {
            return;
        }
        for (n = 0; n < ((String)object).length() && ((String)object).charAt(n) == ' '; ++this.indent, ++n) {
        }
        object = ((String)object).trim();
        char c = ((String)object).charAt(0);
        n = c;
        boolean bl = c == '#' || n == 33;
        this.isComment = bl;
        n = n == 45 ? 1 : 0;
        this.isItem = n;
        if (!bl) {
            this.hasColon = ((String)object).contains(":");
            if (n == 0) {
                if (((String[])(object = ((String)object).split(":"))).length <= 0) return;
                this.key = ((String)object[0]).trim();
                if (((Object)object).length <= 1) return;
                this.value = ((String)object[1]).trim();
                return;
            }
        }
        this.value = ((String)object).substring(1).trim();
    }

    public final String getValue() {
        if (this.value.equals("null")) {
            return null;
        }
        return StringEscapeUtils.UNESCAPE_JAVA.translate(this.value).replaceAll("^\"|\"$", "").replaceAll("^'|'$", "");
    }

    public final String getKey() {
        return StringEscapeUtils.UNESCAPE_JAVA.translate(this.key).replaceAll("^\"|\"$", "").replaceAll("^'|'$", "");
    }

    public final boolean getValueBool() {
        return Objects.equals(this.value, "true");
    }
}

