/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import android.util.TypedValue;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.CantFindFrameworkResException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.axml.NamespaceStack;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.decoder.StringBlock;
import brut.androlib.res.xml.ResXmlEncoders;
import brut.util.ExtCountingDataInput;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AXmlResourceParser
implements XmlPullParser {
    public static final Logger LOGGER = Logger.getLogger(AXmlResourceParser.class.getName());
    public ExtCountingDataInput mIn;
    public final ResTable mResTable;
    public AndrolibException mFirstError;
    public boolean isOperational = false;
    public StringBlock mStringBlock;
    public int[] mResourceIds;
    public final NamespaceStack mNamespaces;
    public boolean m_decreaseDepth;
    public int mEvent;
    public int mLineNumber;
    public int mNameIndex;
    public int mNamespaceIndex;
    public int[] mAttributes;

    public final int getAttributeOffset(int n) {
        if (this.mEvent == 2) {
            int n2 = n * 5;
            if (n2 < this.mAttributes.length) {
                return n2;
            }
            throw new IndexOutOfBoundsException("Invalid attribute index (" + n + ").");
        }
        throw new IndexOutOfBoundsException("Current event is not START_TAG.");
    }

    public final void doNext() {
        block30: {
            int n;
            if (((AXmlResourceParser)((Object)n16)).mStringBlock == null) {
                ((AXmlResourceParser)((Object)n16)).mIn.skipBytes(4);
                ((AXmlResourceParser)((Object)n16)).mIn.skipBytes(4);
                ((AXmlResourceParser)((Object)n16)).mStringBlock = StringBlock.readWithChunk(((AXmlResourceParser)((Object)n16)).mIn);
                ((AXmlResourceParser)((Object)n16)).mNamespaces.increaseDepth();
                ((AXmlResourceParser)((Object)n16)).isOperational = true;
            }
            if ((n = ((AXmlResourceParser)((Object)n16)).mEvent) == 1) {
                return;
            }
            ((AXmlResourceParser)((Object)n16)).mEvent = -1;
            ((AXmlResourceParser)((Object)n16)).mLineNumber = -1;
            ((AXmlResourceParser)((Object)n16)).mNameIndex = -1;
            ((AXmlResourceParser)((Object)n16)).mNamespaceIndex = -1;
            ((AXmlResourceParser)((Object)n16)).mAttributes = null;
            while (true) {
                int n2;
                int n3;
                int n4;
                NamespaceStack namespaceStack;
                if (((AXmlResourceParser)((Object)n16)).m_decreaseDepth) {
                    ((AXmlResourceParser)((Object)n16)).m_decreaseDepth = false;
                    namespaceStack = ((AXmlResourceParser)((Object)n16)).mNamespaces;
                    n4 = namespaceStack.m_dataLength;
                    if (n4 != 0) {
                        n3 = n4 - 1;
                        n3 = namespaceStack.m_data[n3];
                        if (n4 - 2 - (n3 *= 2) != 0) {
                            namespaceStack.m_dataLength = n4 - (n3 + 2);
                            --namespaceStack.m_depth;
                        }
                    }
                }
                if (n == 3) {
                    namespaceStack = ((AXmlResourceParser)((Object)n16)).mNamespaces;
                    if (namespaceStack.m_depth == 1) {
                        int n5;
                        n4 = namespaceStack.m_dataLength;
                        if (n4 == 0) {
                            n5 = 0;
                        } else {
                            int n6 = n4 - 1;
                            n5 = namespaceStack.m_data[n6];
                        }
                        if (n5 == 0) {
                            ((AXmlResourceParser)((Object)n16)).mEvent = 1;
                            break block30;
                        }
                    }
                }
                if (((AXmlResourceParser)((Object)n16)).mIn.mCountIn.available() == 0) {
                    Integer n7 = ((AXmlResourceParser)((Object)n16)).mIn.position();
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = n7;
                    LOGGER.warning(String.format("AXML hit unexpected end of file at byte: 0x%X", objectArray2));
                    ((AXmlResourceParser)((Object)n16)).mEvent = 1;
                    break block30;
                }
                int n8 = 0;
                if (n == 0) {
                    n4 = 258;
                } else {
                    n4 = ((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readShort();
                    n8 = ((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readShort();
                }
                if (n4 == 384) {
                    n8 = ((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readInt();
                    if (n8 >= 8 && n8 % 4 == 0) {
                        ((AXmlResourceParser)((Object)n16)).mResourceIds = ((AXmlResourceParser)((Object)n16)).mIn.readIntArray(n8 / 4 - 2);
                        continue;
                    }
                    throw new IOException("Invalid resource ids size (" + n8 + ").");
                }
                if (n4 < 256 || n4 > 383) break;
                if (n4 == 258 && n == -1) {
                    ((AXmlResourceParser)((Object)n16)).mEvent = 0;
                    break block30;
                }
                ((AXmlResourceParser)((Object)n16)).mIn.skipBytes(4);
                ((AXmlResourceParser)((Object)n16)).mLineNumber = ((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readInt();
                ((AXmlResourceParser)((Object)n16)).mIn.skipBytes(4);
                if (n4 != 256 && n4 != 257) {
                    if (n4 == 258) {
                        ((AXmlResourceParser)((Object)n16)).mNamespaceIndex = ((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readInt();
                        ((AXmlResourceParser)((Object)n16)).mNameIndex = ((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readInt();
                        ((AXmlResourceParser)((Object)n16)).mIn.skipBytes(2);
                        n = ((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readShort();
                        n8 = ((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readShort();
                        ((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readShort();
                        ((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readShort();
                        ((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readShort();
                        ((AXmlResourceParser)((Object)n16)).mAttributes = ((AXmlResourceParser)((Object)n16)).mIn.readIntArray(n8 * 5);
                        n4 = 3;
                        while (true) {
                            int[] nArray = ((AXmlResourceParser)((Object)n16)).mAttributes;
                            if (n4 >= ((AXmlResourceParser)((Object)n16)).mAttributes.length) break;
                            nArray[n4] = nArray[n4] >>> 24;
                            n4 += 5;
                        }
                        n4 = n8 * 20;
                        if (n4 < (n *= n8)) {
                            ((AXmlResourceParser)((Object)n16)).mIn.skipBytes(n -= n4);
                            LOGGER.fine("Skipping " + n + " unknown bytes in attributes area.");
                        }
                        ((AXmlResourceParser)((Object)n16)).mNamespaces.increaseDepth();
                        ((AXmlResourceParser)((Object)n16)).mEvent = 2;
                    } else if (n4 == 259) {
                        ((AXmlResourceParser)((Object)n16)).mNamespaceIndex = ((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readInt();
                        ((AXmlResourceParser)((Object)n16)).mNameIndex = ((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readInt();
                        ((AXmlResourceParser)((Object)n16)).mEvent = 3;
                        ((AXmlResourceParser)((Object)n16)).m_decreaseDepth = true;
                    } else {
                        if (n4 != 260) continue;
                        ((AXmlResourceParser)((Object)n16)).mNameIndex = ((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readInt();
                        ((AXmlResourceParser)((Object)n16)).mIn.skipBytes(4);
                        ((AXmlResourceParser)((Object)n16)).mIn.skipBytes(4);
                        ((AXmlResourceParser)((Object)n16)).mEvent = 4;
                    }
                    break block30;
                }
                if (n4 == 256) {
                    n4 = ((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readInt();
                    n3 = ((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readInt();
                    NamespaceStack namespaceStack2 = ((AXmlResourceParser)((Object)n16)).mNamespaces;
                    if (namespaceStack2.m_depth == 0) {
                        namespaceStack2.increaseDepth();
                    }
                    int[] nArray = namespaceStack2.m_data;
                    int n9 = namespaceStack2.m_dataLength;
                    int n10 = namespaceStack2.m_data.length - n9;
                    if (n10 <= 2) {
                        nArray = new int[(nArray.length + n10) * 2];
                        System.arraycopy(nArray, 0, nArray, 0, n9);
                        namespaceStack2.m_data = nArray;
                    }
                    int n11 = namespaceStack2.m_dataLength;
                    n2 = n11 - 1;
                    int[] nArray2 = namespaceStack2.m_data;
                    int n12 = n4;
                    n4 = nArray2[n2];
                    nArray2[n11 - 2 - n4 * 2] = ++n4;
                    nArray2[n2] = n12;
                    nArray2[n11] = n3;
                    namespaceStack2.m_data[n11 - -1] = n4;
                    namespaceStack2.m_dataLength = n11 + 2;
                } else {
                    ((AXmlResourceParser)((Object)n16)).mIn.skipBytes(4);
                    ((AXmlResourceParser)((Object)n16)).mIn.skipBytes(4);
                    NamespaceStack namespaceStack3 = ((AXmlResourceParser)((Object)n16)).mNamespaces;
                    n3 = namespaceStack3.m_dataLength;
                    if (n3 != 0) {
                        n2 = n3 - 1;
                        int[] nArray = namespaceStack3.m_data;
                        if ((n2 = namespaceStack3.m_data[n2]) != 0) {
                            int n13 = n3;
                            int n14 = n2 + -1;
                            nArray[n3 -= 3] = n14;
                            nArray[n3 - (n14 * 2 + 1)] = n14;
                            namespaceStack3.m_dataLength = n13 - 2;
                        }
                    }
                }
                if (n8 <= 16) continue;
                Integer n15 = n8 -= 16;
                Object[] objectArray = new Object[1];
                Object[] objectArray3 = objectArray;
                objectArray[0] = n15;
                LOGGER.warning(String.format("AXML header larger than 0x10 bytes, skipping %d bytes.", objectArray3));
                ((AXmlResourceParser)((Object)n16)).mIn.skipBytes(n8);
            }
            ((AXmlResourceParser)((Object)n16)).mIn.skipBytes(((AXmlResourceParser)((Object)n16)).mIn.mDelegate.readInt() - 8);
            Integer n16 = ((AXmlResourceParser)((Object)n16)).mIn.position();
            Object[] objectArray = new Object[1];
            Object[] objectArray4 = objectArray;
            objectArray[0] = n16;
            LOGGER.warning(String.format("Unknown chunk type at: (0x%08x) skipping...", objectArray4));
        }
    }

    @Override
    public final int nextToken() {
        if (this.mIn != null) {
            try {
                AXmlResourceParser aXmlResourceParser = this;
                aXmlResourceParser.doNext();
                return aXmlResourceParser.mEvent;
            }
            catch (IOException iOException) {
                if (this.isOperational) {
                    this.isOperational = false;
                    this.mIn = null;
                    this.mStringBlock = null;
                    this.mResourceIds = null;
                    NamespaceStack namespaceStack = this.mNamespaces;
                    namespaceStack.m_dataLength = 0;
                    namespaceStack.m_depth = 0;
                    this.mEvent = -1;
                    this.mLineNumber = -1;
                    this.mNameIndex = -1;
                    this.mNamespaceIndex = -1;
                    this.mAttributes = null;
                }
                throw iOException;
            }
        }
        throw new XmlPullParserException("Parser is not opened.", this, null);
    }

    @Override
    public final int getDepth() {
        return this.mNamespaces.m_depth - 1;
    }

    @Override
    public final int getEventType() {
        return this.mEvent;
    }

    @Override
    public final int getLineNumber() {
        return this.mLineNumber;
    }

    @Override
    public final String getName() {
        int n;
        int n2 = this.mNameIndex;
        if (n2 != -1 && ((n = this.mEvent) == 2 || n == 3)) {
            return this.mStringBlock.getString(n2);
        }
        return null;
    }

    @Override
    public final String getText() {
        int n = this.mNameIndex;
        if (n != -1 && this.mEvent == 4) {
            return this.mStringBlock.getString(n);
        }
        return null;
    }

    @Override
    public final String getNamespace() {
        return this.mStringBlock.getString(this.mNamespaceIndex);
    }

    @Override
    public final String getPositionDescription() {
        return "XML line #" + this.mLineNumber;
    }

    @Override
    public final int getNamespaceCount(int n) {
        int n2;
        NamespaceStack namespaceStack = ((AXmlResourceParser)((Object)namespaceStack)).mNamespaces;
        if (namespaceStack.m_dataLength != 0 && n >= 0) {
            n2 = namespaceStack.m_depth;
            if (n > n2) {
                n = n2;
            }
            n2 = 0;
            int n3 = 0;
            while (n != 0) {
                int n4 = namespaceStack.m_data[n3];
                n2 += n4;
                n3 = n4 * 2 + 2 + n3;
                --n;
            }
        } else {
            n2 = 0;
        }
        return n2;
    }

    @Override
    public final String getNamespacePrefix(int n) {
        AXmlResourceParser aXmlResourceParser = this;
        int n2 = aXmlResourceParser.mNamespaces.get(n, true);
        return aXmlResourceParser.mStringBlock.getString(n2);
    }

    @Override
    public final String getNamespaceUri(int n) {
        AXmlResourceParser aXmlResourceParser = this;
        int n2 = aXmlResourceParser.mNamespaces.get(n, false);
        return aXmlResourceParser.mStringBlock.getString(n2);
    }

    @Override
    public final int getAttributeCount() {
        if (this.mEvent != 2) {
            return -1;
        }
        return this.mAttributes.length / 5;
    }

    @Override
    public final String getAttributeNamespace(int n) {
        int n2 = n;
        AXmlResourceParser aXmlResourceParser = this;
        n = aXmlResourceParser.getAttributeOffset(n);
        int n3 = aXmlResourceParser.mAttributes[n];
        int n4 = this.getAttributeNameResource(n2) >> 24 & 0xFF;
        if (n4 == 0) {
            n4 = 2;
        }
        if (n3 == -1 && n4 == 1) {
            return "http://schemas.android.com/apk/res/android";
        }
        if (n3 == -1) {
            return "";
        }
        String string = this.mStringBlock.getString(n3);
        if (string != null && !string.isEmpty()) {
            return string;
        }
        if (n4 == 127) {
            return this.mStringBlock.getString(this.mNamespaces.get(n, true)) != null ? this.mStringBlock.getString(this.mNamespaces.get(n, false)) : "http://schemas.android.com/apk/res-auto";
        }
        return "http://schemas.android.com/apk/res/android";
    }

    public final String decodeFromResourceId(int n) {
        if (n != 0) {
            try {
                return StringUtils.replace(this.mResTable.getResSpec((int)n).mName, "\"", "q");
            }
            catch (CantFindFrameworkResException cantFindFrameworkResException) {
            }
            catch (UndefinedResObjectException undefinedResObjectException) {}
        }
        return null;
    }

    @Override
    public final String getAttributeName(int n) {
        String string;
        AXmlResourceParser aXmlResourceParser = string2;
        int n2 = aXmlResourceParser.getAttributeOffset(n);
        if ((n2 = aXmlResourceParser.mAttributes[n2 + 1]) == -1) {
            return "";
        }
        AXmlResourceParser aXmlResourceParser2 = string2;
        String string2 = ((AXmlResourceParser)((Object)string2)).mStringBlock.getString(n2);
        n = aXmlResourceParser2.getAttributeNameResource(n);
        try {
            string = aXmlResourceParser2.decodeFromResourceId(n);
        }
        catch (AndrolibException androlibException) {
            string = null;
        }
        if (string != null) {
            return string;
        }
        if (string2 != null) {
            return string2;
        }
        return "APKTOOL_MISSING_" + Integer.toHexString(n);
    }

    public final int getAttributeNameResource(int n) {
        AXmlResourceParser aXmlResourceParser = this;
        int n2 = aXmlResourceParser.getAttributeOffset(n);
        n2 = aXmlResourceParser.mAttributes[n2 + 1];
        int[] nArray = aXmlResourceParser.mResourceIds;
        if (aXmlResourceParser.mResourceIds != null && n2 >= 0 && n2 < nArray.length) {
            return nArray[n2];
        }
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getAttributeValue(int var1_1) {
        block19: {
            block20: {
                block21: {
                    v0 = this;
                    var2_3 = v0.getAttributeOffset(var1_1);
                    var3_4 = v0.mAttributes;
                    v1 = var2_3;
                    v2 = var2_3;
                    var2_3 = var3_4[var2_3 + 3];
                    var3_5 = var3_4[v2 + 4];
                    var4_6 = v0.mAttributes[v1 + 2];
                    if (var4_6 != -1) break block21;
                    var4_7 = null;
                    ** GOTO lbl15
                }
                try {
                    var4_7 = ResXmlEncoders.escapeXmlChars(this.mStringBlock.getString(var4_6));
lbl15:
                    // 2 sources

                    var5_9 = null;
                    if (var2_3 == 1 || var2_3 == 7 || var2_3 == 2 || var2_3 == 8) {
                        var5_9 = this.decodeFromResourceId(var3_5);
                    }
                    if (var4_7 != null && var5_9 != null) {
                        var6_12 = var4_7.lastIndexOf("/");
                    }
                    ** GOTO lbl32
                }
                catch (AndrolibException var4_8) {
                    break block19;
                }
                {
                    var7_15 = var4_7.lastIndexOf(":");
                    if (var6_12 == -1) ** GOTO lbl30
                    if (var7_15 != -1) ** GOTO lbl32
                    var4_7 = var4_7.substring(0, var6_12);
                }
                {
                    block22: {
                        var4_7 = (String)var4_7 + "/" + var5_9;
                        break block22;
lbl30:
                        // 1 sources

                        if (!var4_7.equals(var5_9)) {
                            var4_7 = var5_9;
                        }
                    }
                    var5_10 = this.getAttributeNameResource(var1_1);
                }
                {
                    var4_7 = this.mResTable.getCurrentResPackage().getValueFactory().factory((String)var4_7, var2_3, var3_5);
                    var6_13 = null;
                    if (var5_10 <= 0) break block20;
                    try {
                        var6_13 = ((ResAttr)this.mResTable.getResSpec((int)var5_10).getDefaultResource().mValue).convertToResXmlFormat((ResScalarValue)var4_7);
                    }
                    catch (ClassCastException v3) {
                    }
                    catch (UndefinedResObjectException v4) {}
                }
            }
            if (var6_13 == null) return var4_7.encodeAsResXmlAttr();
            return var6_13;
        }
        if (this.mFirstError == null) {
            this.mFirstError = var4_8;
        }
        v5 = this;
        var5_11 = AXmlResourceParser.LOGGER;
        var6_14 = Level.WARNING;
        var7_16 = "Could not decode attr value, using undecoded value instead: ns=%s, name=%s, value=0x%08x";
        var8_17 = v5.getAttributeOffset(var1_1);
        var8_17 = v5.mAttributes[var8_17];
        var9_19 = v5.mNamespaces;
        var10_20 = var9_19.m_dataLength;
        if (var10_20 == 0) {
            while (true) {
                var8_17 = -1;
                break;
            }
        } else {
            --var10_20;
            var11_21 = var9_19.m_depth;
            block10: while (true) {
                if (var11_21 == 0) ** continue;
                var12_22 = var9_19.m_data[var10_20];
                var10_20 -= 2;
                while (var12_22 != 0) {
                    var13_23 = var9_19.m_data;
                    if (var9_19.m_data[var10_20 + 1] == var8_17) {
                        var8_17 = var13_23[var10_20];
                        break block10;
                    }
                    var10_20 -= 2;
                    --var12_22;
                }
                --var11_21;
            }
        }
        var8_18 = var8_17 == -1 ? "" : this.mStringBlock.getString(var8_17);
        this = this.getAttributeName(var1_1);
        var1_2 = var3_5;
        var5_11.log(var6_14, String.format(var7_16, new Object[]{var8_18, this, var1_2}), var4_8);
        return TypedValue.coerceToString(var2_3, var3_5);
    }

    @Override
    public final String getInputEncoding() {
        return null;
    }

    @Override
    public final int getColumnNumber() {
        return -1;
    }

    public final void setInput(InputStream inputStream) {
        if (((AXmlResourceParser)((Object)extCountingDataInput2)).isOperational) {
            ((AXmlResourceParser)((Object)extCountingDataInput2)).isOperational = false;
            ((AXmlResourceParser)((Object)extCountingDataInput2)).mIn = null;
            ((AXmlResourceParser)((Object)extCountingDataInput2)).mStringBlock = null;
            ((AXmlResourceParser)((Object)extCountingDataInput2)).mResourceIds = null;
            NamespaceStack namespaceStack = ((AXmlResourceParser)((Object)extCountingDataInput2)).mNamespaces;
            namespaceStack.m_dataLength = 0;
            namespaceStack.m_depth = 0;
            ((AXmlResourceParser)((Object)extCountingDataInput2)).mEvent = -1;
            ((AXmlResourceParser)((Object)extCountingDataInput2)).mLineNumber = -1;
            ((AXmlResourceParser)((Object)extCountingDataInput2)).mNameIndex = -1;
            ((AXmlResourceParser)((Object)extCountingDataInput2)).mNamespaceIndex = -1;
            ((AXmlResourceParser)((Object)extCountingDataInput2)).mAttributes = null;
        }
        if (inputStream != null) {
            LittleEndianDataInputStream littleEndianDataInputStream;
            ExtCountingDataInput extCountingDataInput;
            AXmlResourceParser aXmlResourceParser = extCountingDataInput2;
            ExtCountingDataInput extCountingDataInput2 = extCountingDataInput;
            LittleEndianDataInputStream littleEndianDataInputStream2 = littleEndianDataInputStream;
            littleEndianDataInputStream = new LittleEndianDataInputStream(inputStream);
            extCountingDataInput = new ExtCountingDataInput(littleEndianDataInputStream2);
            aXmlResourceParser.mIn = extCountingDataInput2;
        }
    }

    @Override
    public final Object getProperty() {
        return null;
    }

    @Override
    public final boolean getFeature() {
        return false;
    }

    public AXmlResourceParser(ResTable resTable) {
        NamespaceStack namespaceStack;
        NamespaceStack namespaceStack2 = namespaceStack;
        namespaceStack = new NamespaceStack();
        v1.mNamespaces = namespaceStack2;
        v1.mResTable = resTable;
        v1.mEvent = -1;
        v1.mLineNumber = -1;
        v1.mNameIndex = -1;
        v1.mNamespaceIndex = -1;
        v1.mAttributes = null;
    }
}

