from owtf.config import config_handler
from owtf.plugin.helper import plugin_helper
from owtf.plugin.params import plugin_params

DESCRIPTION = "Launches all Exploits for a category(ies) -i.e. for IDS testing-"
CATEGORIES = ["LINUX", "WINDOWS", "OSX"]
SUBCATEGORIES = [
    "DCERPC",
    "FTP",
    "HTTP",
    "IIS",
    "IMAP",
    "ISAPI",
    "LDAP",
    "LPD",
    "MDNS",
    "MISC",
    "MMSP",
    "MSSQL",
    "MYSQL",
    "NOVELL",
    "NFS",
    "NNTP",
    "NTP",
    "ORACLE",
    "PHP",
    "POP3",
    "POSTGRES",
    "PPTP",
    "PROXY",
    "REALSERVER",
    "RPC",
    "RTSP",
    "SAMBA",
    "SCADA",
    "SIP",
    "SMB",
    "SMTP",
    "SOFTCART",
    "SSH",
    "SSL",
    "SUNRPC",
    "SVN",
    "TACACS",
    "TELNET",
    "TFTP",
    "UNICENTER",
    "VNC",
    "VPN",
    "WEBAPP",
    "WINS",
    "WYSE",
]


def run(PluginInfo):
    Content = []
    args = {
        "Description": DESCRIPTION,
        "Mandatory": {
            "RHOST": config_handler.get_val("RHOST_DESCRIP"),
            "RPORT": config_handler.get_val("RPORT_DESCRIP"),
            "CATEGORY": "Category to use (i.e. " + ", ".join(sorted(CATEGORIES)) + ")",
            "SUBCATEGORY": "Subcategory to use (i.e. "
            + ", ".join(sorted(SUBCATEGORIES))
            + ")",
        },
        "Optional": {"REPEAT_DELIM": config_handler.get_val("REPEAT_DELIM_DESCRIP")},
    }
    for args in plugin_params.get_args(args, PluginInfo):
        plugin_params.set_config(args)
        resource = config_handler.get_resources(
            "LaunchExploit_" + args["CATEGORY"] + "_" + args["SUBCATEGORY"]
        )
        Content += plugin_helper.CommandDump(
            "Test Command", "Output", resource, PluginInfo, ""
        )
    return Content
